/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.authenticationservice;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.LoginException;
import org.eclipse.equinox.security.auth.ILoginContext;
import org.eclipse.equinox.security.auth.LoginContextFactory;
import org.eclipse.riena.internal.security.authenticationservice.AuthenticationServiceCallbackHandler;
import org.eclipse.riena.security.common.ISubjectHolder;
import org.eclipse.riena.security.common.authentication.AuthenticationFailure;
import org.eclipse.riena.security.common.authentication.AuthenticationTicket;
import org.eclipse.riena.security.common.authentication.Callback2CredentialConverter;
import org.eclipse.riena.security.common.authentication.IAuthenticationService;
import org.eclipse.riena.security.common.authentication.credentials.AbstractCredential;
import org.eclipse.riena.security.common.session.ISessionHolder;
import org.eclipse.riena.security.common.session.Session;
import org.eclipse.riena.security.server.session.ISessionService;

public class AuthenticationService
implements IAuthenticationService {
    public static final String VERSION_ID = "$Id: AuthenticationService.java,v 1.15 2009/07/29 09:17:14 sliebig Exp $";
    private ISessionService sessionService;
    private ISubjectHolder subjectHolder;
    private ISessionHolder sessionHolder;

    public void bind(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void unbind(ISessionService sessionService) {
        if (this.sessionService == sessionService) {
            this.sessionService = null;
        }
    }

    public void bind(ISubjectHolder subjectHolder) {
        this.subjectHolder = subjectHolder;
    }

    public void unbind(ISubjectHolder subjectHolder) {
        if (this.subjectHolder == subjectHolder) {
            this.subjectHolder = null;
        }
    }

    public void bind(ISessionHolder sessionHolder) {
        this.sessionHolder = sessionHolder;
    }

    public void unbind(ISessionHolder sessionHolder) {
        if (this.sessionHolder == sessionHolder) {
            this.sessionHolder = null;
        }
    }

    public AuthenticationTicket login(String loginContext, AbstractCredential[] credentials) throws AuthenticationFailure {
        try {
            Callback[] callbacks = Callback2CredentialConverter.credentials2Callbacks((AbstractCredential[])credentials);
            ILoginContext secureContext = LoginContextFactory.createContext((String)loginContext);
            AuthenticationServiceCallbackHandler.setCallbacks(callbacks);
            secureContext.login();
            Set<Principal> principals = secureContext.getSubject().getPrincipals();
            AuthenticationTicket ticket = new AuthenticationTicket();
            Session session = this.sessionHolder.getSession();
            if (session != null) {
                this.sessionService.invalidateSession(session);
            }
            Principal[] pArray = principals.toArray(new Principal[principals.size()]);
            session = this.sessionService.generateSession(pArray);
            this.sessionHolder.setSession(session);
            for (Principal p : principals) {
                ticket.getPrincipals().add(p);
            }
            ticket.setSession(session);
            AuthenticationTicket authenticationTicket = ticket;
            return authenticationTicket;
        }
        catch (LoginException e) {
            throw new AuthenticationFailure("AuthenticationService login failed", (Throwable)e);
        }
        finally {
            AuthenticationServiceCallbackHandler.setCallbacks(null);
        }
    }

    public void logout() throws AuthenticationFailure {
        Session session = this.sessionHolder.getSession();
        if (session == null) {
            throw new AuthenticationFailure("no valid session");
        }
        this.sessionService.invalidateSession(session);
        this.sessionHolder.setSession(null);
    }
}

