/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.sessionservice;

import java.security.Principal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.security.common.session.Session;
import org.eclipse.riena.security.server.session.ISessionService;
import org.eclipse.riena.security.server.session.SessionFailure;
import org.eclipse.riena.security.sessionservice.ISessionProvider;
import org.eclipse.riena.security.sessionservice.ISessionStore;
import org.eclipse.riena.security.sessionservice.SessionEntry;

public class SessionService
implements ISessionService {
    private ISessionStore store;
    private ISessionProvider sessionProvider;

    public SessionService() {
    }

    public void bind(ISessionStore store) {
        this.store = store;
    }

    public void unbind(ISessionStore store) {
        if (this.store == store) {
            this.store = null;
        }
    }

    public void bind(ISessionProvider provider) {
        this.sessionProvider = provider;
    }

    public void unbind(ISessionProvider provider) {
        if (this.sessionProvider == provider) {
            this.sessionProvider = null;
        }
    }

    public SessionService(ISessionStore store, ISessionProvider sessionProvider) {
        this.store = store;
        this.sessionProvider = sessionProvider;
    }

    public Session generateSession(Principal[] principals) {
        Assert.isNotNull((Object)this.store, (String)"store instance is null");
        Session session = this.sessionProvider.createSession(principals);
        if (session == null) {
            throw new SessionFailure("internal error, generating a session failed");
        }
        SessionEntry entry = new SessionEntry(session, principals);
        this.store.write(entry);
        return session;
    }

    public Principal[] findPrincipals(Session session) {
        SessionEntry entry = this.store.read(session);
        if (entry == null) {
            return null;
        }
        return entry.getPrincipals().toArray(new Principal[entry.getPrincipals().size()]);
    }

    public boolean isValidSession(Session session) {
        SessionEntry entry = this.store.read(session);
        return entry != null && entry.getValid();
    }

    public boolean hasSession(Session session) {
        SessionEntry entry = this.store.read(session);
        return entry != null;
    }

    public void invalidateSession(Session session) {
        this.store.delete(session);
    }
}

