/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.client.controller.test;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.example.client.controllers.MarkerSubModuleController;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.ui.swt.test.TestUtils;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.ui.swt.controllers.AbstractSubModuleControllerTest;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.ICompositeTableRidget;
import org.eclipse.riena.ui.ridgets.IDateTextRidget;
import org.eclipse.riena.ui.ridgets.IDateTimeRidget;
import org.eclipse.riena.ui.ridgets.IDecimalTextRidget;
import org.eclipse.riena.ui.ridgets.IGroupedTreeTableRidget;
import org.eclipse.riena.ui.ridgets.IListRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMultipleChoiceRidget;
import org.eclipse.riena.ui.ridgets.INumericTextRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.riena.ui.tests.base.TestSingleSelectionBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonUITestCase
public class MarkerSubModuleControllerTest
extends AbstractSubModuleControllerTest<MarkerSubModuleController> {
    private List<Person> personList;

    protected void setUp() throws Exception {
        super.setUp();
        this.personList = PersonFactory.createPersonList();
    }

    protected MarkerSubModuleController createController(ISubModuleNode node) {
        MarkerSubModuleController newInst = new MarkerSubModuleController();
        node.setNodeId(new NavigationNodeId("org.eclipse.riena.example.marker"));
        newInst.setNavigationNode(node);
        return newInst;
    }

    public void testBasicInitialization() {
        IToggleButtonRidget checkMandatory = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "checkMandatory");
        MarkerSubModuleControllerTest.assertFalse((boolean)checkMandatory.isSelected());
        IToggleButtonRidget checkError = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "checkError");
        MarkerSubModuleControllerTest.assertFalse((boolean)checkError.isSelected());
        IToggleButtonRidget checkDisabled = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "checkDisabled");
        MarkerSubModuleControllerTest.assertFalse((boolean)checkDisabled.isSelected());
        IToggleButtonRidget checkOutput = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "checkOutput");
        MarkerSubModuleControllerTest.assertFalse((boolean)checkOutput.isSelected());
        IToggleButtonRidget checkHidden = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "checkHidden");
        MarkerSubModuleControllerTest.assertFalse((boolean)checkHidden.isSelected());
        IToggleButtonRidget checkHiddenParent = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "checkHiddenParent");
        MarkerSubModuleControllerTest.assertFalse((boolean)checkHiddenParent.isSelected());
        ITextRidget textName = (ITextRidget)((MarkerSubModuleController)this.getController()).getRidget(ITextRidget.class, "textName");
        MarkerSubModuleControllerTest.assertEquals((String)"Chateau Schaedelbrummer", (String)textName.getText());
        IDecimalTextRidget textPrice = (IDecimalTextRidget)((MarkerSubModuleController)this.getController()).getRidget(IDecimalTextRidget.class, "textPrice");
        MarkerSubModuleControllerTest.assertEquals((String)TestUtils.getLocalizedNumber((String)"-29,99"), (String)textPrice.getText());
        INumericTextRidget textAmount = (INumericTextRidget)((MarkerSubModuleController)this.getController()).getRidget(INumericTextRidget.class, "textAmount");
        MarkerSubModuleControllerTest.assertEquals((String)TestUtils.getLocalizedNumber((String)"1.001"), (String)textAmount.getText());
        IDateTextRidget textDate = (IDateTextRidget)((MarkerSubModuleController)this.getController()).getRidget(IDateTextRidget.class, "textDate");
        MarkerSubModuleControllerTest.assertEquals((String)"04.12.2008", (String)textDate.getText());
        IDateTimeRidget dtDate = (IDateTimeRidget)((MarkerSubModuleController)this.getController()).getRidget(IDateTimeRidget.class, "dtDate");
        if ("US".equals(Locale.getDefault().getCountry())) {
            MarkerSubModuleControllerTest.assertEquals((String)"12/4/08 12:00 AM", (String)dtDate.getText());
        } else {
            MarkerSubModuleControllerTest.assertEquals((String)"04.12.08 00:00", (String)dtDate.getText());
        }
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2008, 11, 4);
        MarkerSubModuleControllerTest.assertEquals((Object)cal.getTime(), (Object)dtDate.getDate());
        IComboRidget comboAge = (IComboRidget)((MarkerSubModuleController)this.getController()).getRidget(IComboRidget.class, "comboAge");
        MarkerSubModuleControllerTest.assertEquals((Object)"young", (Object)comboAge.getSelection());
        ISingleChoiceRidget choiceType = (ISingleChoiceRidget)((MarkerSubModuleController)this.getController()).getRidget(ISingleChoiceRidget.class, "choiceType");
        MarkerSubModuleControllerTest.assertEquals((Object)"red", (Object)choiceType.getSelection());
        IMultipleChoiceRidget choiceFlavor = (IMultipleChoiceRidget)((MarkerSubModuleController)this.getController()).getRidget(IMultipleChoiceRidget.class, "choiceFlavor");
        MarkerSubModuleControllerTest.assertNotNull((Object)choiceFlavor.getSelection());
        MarkerSubModuleControllerTest.assertEquals((int)1, (int)choiceFlavor.getSelection().size());
        MarkerSubModuleControllerTest.assertEquals((Object)"dry", choiceFlavor.getSelection().get(0));
        IToggleButtonRidget buttonToggle = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "buttonToggle");
        MarkerSubModuleControllerTest.assertTrue((boolean)buttonToggle.isSelected());
        IToggleButtonRidget buttonRadioA = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "buttonRadioA");
        MarkerSubModuleControllerTest.assertFalse((boolean)buttonRadioA.isSelected());
        IToggleButtonRidget buttonRadioB = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "buttonRadioB");
        MarkerSubModuleControllerTest.assertFalse((boolean)buttonRadioB.isSelected());
        IToggleButtonRidget buttonCheck = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "buttonCheck");
        MarkerSubModuleControllerTest.assertFalse((boolean)buttonCheck.isSelected());
    }

    public void testMandatoryMarkerOptions() {
        ITreeRidget treePersons = (ITreeRidget)((MarkerSubModuleController)this.getController()).getRidget(ITreeRidget.class, "treePersons");
        treePersons.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        TestSingleSelectionBean singleSelectionBean = new TestSingleSelectionBean();
        treePersons.bindSingleSelectionToModel((Object)singleSelectionBean, "selection");
        treePersons.updateFromModel();
        IToggleButtonRidget mandatoryToggle = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "checkMandatory");
        MarkerSubModuleControllerTest.assertFalse((boolean)mandatoryToggle.isSelected());
        for (IMarkableRidget ridget : this.getAllMarkableRidgets()) {
            MarkerSubModuleControllerTest.assertFalse((boolean)ridget.isMandatory());
        }
        mandatoryToggle.setSelected(true);
        MarkerSubModuleControllerTest.assertTrue((boolean)mandatoryToggle.isSelected());
        for (IMarkableRidget ridget : this.getAllMarkableRidgets()) {
            MarkerSubModuleControllerTest.assertTrue((boolean)ridget.isMandatory());
        }
    }

    public void testErrorMarkerOptions() {
        IToggleButtonRidget errorToggle = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "checkError");
        MarkerSubModuleControllerTest.assertFalse((boolean)errorToggle.isSelected());
        for (IMarkableRidget ridget : this.getAllMarkableRidgets()) {
            MarkerSubModuleControllerTest.assertFalse((boolean)ridget.isErrorMarked());
        }
        errorToggle.setSelected(true);
        MarkerSubModuleControllerTest.assertTrue((boolean)errorToggle.isSelected());
        for (IMarkableRidget ridget : this.getAllMarkableRidgets()) {
            MarkerSubModuleControllerTest.assertTrue((boolean)ridget.isErrorMarked());
        }
    }

    public void testDisabledMarkerOptions() {
        IToggleButtonRidget disabledToggle = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "checkDisabled");
        MarkerSubModuleControllerTest.assertFalse((boolean)disabledToggle.isSelected());
        for (IMarkableRidget ridget : this.getAllMarkableRidgets()) {
            MarkerSubModuleControllerTest.assertTrue((boolean)ridget.isEnabled());
        }
        disabledToggle.setSelected(true);
        MarkerSubModuleControllerTest.assertTrue((boolean)disabledToggle.isSelected());
        for (IMarkableRidget ridget : this.getAllMarkableRidgets()) {
            MarkerSubModuleControllerTest.assertFalse((boolean)ridget.isEnabled());
        }
        MarkerSubModuleControllerTest.assertFalse((boolean)((IActionRidget)((MarkerSubModuleController)this.getController()).getRidget(IActionRidget.class, "buttonPush")).isEnabled());
    }

    public void testOutputMarkerOptions() {
        IToggleButtonRidget outputToggle = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "checkOutput");
        MarkerSubModuleControllerTest.assertFalse((boolean)outputToggle.isSelected());
        for (IMarkableRidget ridget : this.getAllMarkableRidgets()) {
            MarkerSubModuleControllerTest.assertFalse((boolean)ridget.isOutputOnly());
        }
        outputToggle.setSelected(true);
        MarkerSubModuleControllerTest.assertTrue((boolean)outputToggle.isSelected());
        for (IMarkableRidget ridget : this.getAllMarkableRidgets()) {
            MarkerSubModuleControllerTest.assertTrue((boolean)ridget.isOutputOnly());
        }
    }

    public void testHiddenMarkerOptions() {
        IToggleButtonRidget hiddenToggle = (IToggleButtonRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "checkHidden");
        MarkerSubModuleControllerTest.assertFalse((boolean)hiddenToggle.isSelected());
        for (IMarkableRidget ridget : this.getAllMarkableRidgets()) {
            MarkerSubModuleControllerTest.assertTrue((boolean)ridget.isVisible());
        }
        hiddenToggle.setSelected(true);
        MarkerSubModuleControllerTest.assertTrue((boolean)hiddenToggle.isSelected());
        for (IMarkableRidget ridget : this.getAllMarkableRidgets()) {
            MarkerSubModuleControllerTest.assertFalse((boolean)ridget.isVisible());
        }
        MarkerSubModuleControllerTest.assertFalse((boolean)((IActionRidget)((MarkerSubModuleController)this.getController()).getRidget(IActionRidget.class, "buttonPush")).isVisible());
    }

    public void testList() {
        Person expected = null;
        Person actual = null;
        IListRidget listPersons = (IListRidget)((MarkerSubModuleController)this.getController()).getRidget(IListRidget.class, "listPersons");
        MarkerSubModuleControllerTest.assertEquals((int)this.personList.size(), (int)listPersons.getOptionCount());
        MarkerSubModuleControllerTest.assertEquals((int)-1, (int)listPersons.getSelectionIndex());
        MarkerSubModuleControllerTest.assertEquals((int)0, (int)listPersons.getSelection().size());
        int i = 0;
        while (i < listPersons.getOptionCount()) {
            expected = this.personList.get(i);
            actual = (Person)listPersons.getOption(i);
            MarkerSubModuleControllerTest.assertEquals((String)expected.getFirstname(), (String)actual.getFirstname());
            MarkerSubModuleControllerTest.assertEquals((String)expected.getLastname(), (String)actual.getLastname());
            ++i;
        }
        listPersons.setSelection(1);
        MarkerSubModuleControllerTest.assertEquals((int)1, (int)listPersons.getSelection().size());
        expected = this.personList.get(1);
        actual = (Person)listPersons.getSelection().get(0);
        MarkerSubModuleControllerTest.assertEquals((String)expected.getFirstname(), (String)actual.getFirstname());
        MarkerSubModuleControllerTest.assertEquals((String)expected.getLastname(), (String)actual.getLastname());
    }

    public void testTable() {
        Person expected = null;
        Person actual = null;
        ITableRidget tablePersons = (ITableRidget)((MarkerSubModuleController)this.getController()).getRidget(ITableRidget.class, "tablePersons");
        MarkerSubModuleControllerTest.assertEquals((int)this.personList.size(), (int)tablePersons.getOptionCount());
        MarkerSubModuleControllerTest.assertEquals((int)-1, (int)tablePersons.getSelectionIndex());
        MarkerSubModuleControllerTest.assertEquals((int)0, (int)tablePersons.getSelection().size());
        int i = 0;
        while (i < tablePersons.getOptionCount()) {
            expected = this.personList.get(i);
            actual = (Person)tablePersons.getOption(i);
            MarkerSubModuleControllerTest.assertEquals((String)expected.getFirstname(), (String)actual.getFirstname());
            MarkerSubModuleControllerTest.assertEquals((String)expected.getLastname(), (String)actual.getLastname());
            ++i;
        }
        tablePersons.setSelection(1);
        MarkerSubModuleControllerTest.assertEquals((int)1, (int)tablePersons.getSelection().size());
        expected = this.personList.get(1);
        actual = (Person)tablePersons.getSelection().get(0);
        MarkerSubModuleControllerTest.assertEquals((String)expected.getFirstname(), (String)actual.getFirstname());
        MarkerSubModuleControllerTest.assertEquals((String)expected.getLastname(), (String)actual.getLastname());
    }

    public void testCompositeTable() {
        Person expected = null;
        Person actual = null;
        ICompositeTableRidget compTable = (ICompositeTableRidget)((MarkerSubModuleController)this.getController()).getRidget(ICompositeTableRidget.class, "compTable");
        MarkerSubModuleControllerTest.assertEquals((int)this.personList.size(), (int)compTable.getOptionCount());
        MarkerSubModuleControllerTest.assertEquals((int)-1, (int)compTable.getSelectionIndex());
        MarkerSubModuleControllerTest.assertEquals((int)0, (int)compTable.getSelection().size());
        int i = 0;
        while (i < compTable.getOptionCount()) {
            expected = this.personList.get(i);
            actual = (Person)compTable.getOption(i);
            MarkerSubModuleControllerTest.assertEquals((String)expected.getFirstname(), (String)actual.getFirstname());
            MarkerSubModuleControllerTest.assertEquals((String)expected.getLastname(), (String)actual.getLastname());
            ++i;
        }
        compTable.setSelection(1);
        MarkerSubModuleControllerTest.assertEquals((int)1, (int)compTable.getSelectionIndex());
        MarkerSubModuleControllerTest.assertEquals((int)1, (int)compTable.getSelection().size());
        expected = this.personList.get(1);
        actual = (Person)compTable.getSelection().get(0);
        MarkerSubModuleControllerTest.assertEquals((String)expected.getFirstname(), (String)actual.getFirstname());
        MarkerSubModuleControllerTest.assertEquals((String)expected.getLastname(), (String)actual.getLastname());
    }

    public void testTree() {
        ITreeRidget treePersons = (ITreeRidget)((MarkerSubModuleController)this.getController()).getRidget(ITreeRidget.class, "treePersons");
        MarkerSubModuleControllerTest.assertTrue((boolean)treePersons.getSelection().isEmpty());
    }

    public void testTreeTable() {
        IGroupedTreeTableRidget treeWCols = (IGroupedTreeTableRidget)((MarkerSubModuleController)this.getController()).getRidget(IGroupedTreeTableRidget.class, "treeWCols");
        MarkerSubModuleControllerTest.assertTrue((boolean)treeWCols.getSelection().isEmpty());
    }

    public void testMarkers() {
        this.basicTestMarkers((ITextRidget)((MarkerSubModuleController)this.getController()).getRidget(ITextRidget.class, "textName"), "testString");
        this.basicTestMarkers((ITextRidget)((MarkerSubModuleController)this.getController()).getRidget(IDecimalTextRidget.class, "textPrice"), "123");
        this.basicTestMarkers((ITextRidget)((MarkerSubModuleController)this.getController()).getRidget(INumericTextRidget.class, "textAmount"), "123");
        this.basicTestMarkers((ITextRidget)((MarkerSubModuleController)this.getController()).getRidget(IDateTextRidget.class, "textDate"), "01.01.1980");
        this.basicTestMarkers((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(IDateTimeRidget.class, "dtDate"));
        this.basicTestMarkers((IComboRidget)((MarkerSubModuleController)this.getController()).getRidget(IComboRidget.class, "comboAge"));
        this.basicTestMarkers((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(ISingleChoiceRidget.class, "choiceType"));
        this.basicTestMarkers((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(IMultipleChoiceRidget.class, "choiceFlavor"));
    }

    private void basicTestMarkers(ITextRidget textRidget, String value) {
        this.basicTestMarkers((IMarkableRidget)textRidget);
        textRidget.setText(null);
        textRidget.setMandatory(true);
        MarkerSubModuleControllerTest.assertFalse((boolean)textRidget.isDisableMandatoryMarker());
        textRidget.setText(value);
        MarkerSubModuleControllerTest.assertTrue((boolean)textRidget.isDisableMandatoryMarker());
        textRidget.setText(null);
        MarkerSubModuleControllerTest.assertFalse((boolean)textRidget.isDisableMandatoryMarker());
        textRidget.setMandatory(false);
    }

    private void basicTestMarkers(IComboRidget comboRidget) {
        this.basicTestMarkers((IMarkableRidget)comboRidget);
        comboRidget.setMandatory(true);
        comboRidget.setSelection(null);
        MarkerSubModuleControllerTest.assertFalse((boolean)comboRidget.isDisableMandatoryMarker());
        if (comboRidget.getEmptySelectionItem() == null) {
            comboRidget.setSelection(0);
        } else {
            comboRidget.setSelection(1);
        }
        MarkerSubModuleControllerTest.assertTrue((boolean)comboRidget.isDisableMandatoryMarker());
        comboRidget.setSelection(-1);
        MarkerSubModuleControllerTest.assertFalse((boolean)comboRidget.isDisableMandatoryMarker());
        if (comboRidget.getEmptySelectionItem() == null) {
            comboRidget.setSelection(0);
        } else {
            comboRidget.setSelection(1);
        }
        MarkerSubModuleControllerTest.assertTrue((boolean)comboRidget.isDisableMandatoryMarker());
        comboRidget.setSelection(comboRidget.getEmptySelectionItem());
        MarkerSubModuleControllerTest.assertFalse((boolean)comboRidget.isDisableMandatoryMarker());
        comboRidget.setMandatory(false);
    }

    private void basicTestMarkers(IMarkableRidget ridget) {
        this.basicTestMandatory(ridget);
        this.basicTestErrorMarked(ridget);
        this.basicTestOutputOnly(ridget);
        this.basicTestEnabled(ridget);
        this.basicTestVisible(ridget);
    }

    private void basicTestMandatory(IMarkableRidget ridget) {
        MarkerSubModuleControllerTest.assertFalse((boolean)ridget.isMandatory());
        ridget.setMandatory(true);
        MarkerSubModuleControllerTest.assertTrue((boolean)ridget.isMandatory());
        ridget.setMandatory(false);
        MarkerSubModuleControllerTest.assertFalse((boolean)ridget.isMandatory());
    }

    private void basicTestErrorMarked(IMarkableRidget ridget) {
        MarkerSubModuleControllerTest.assertFalse((boolean)ridget.isErrorMarked());
        ridget.setErrorMarked(true);
        MarkerSubModuleControllerTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.setErrorMarked(false);
        MarkerSubModuleControllerTest.assertFalse((boolean)ridget.isErrorMarked());
    }

    private void basicTestOutputOnly(IMarkableRidget ridget) {
        MarkerSubModuleControllerTest.assertFalse((boolean)ridget.isOutputOnly());
        ridget.setOutputOnly(true);
        MarkerSubModuleControllerTest.assertTrue((boolean)ridget.isOutputOnly());
        ridget.setOutputOnly(false);
        MarkerSubModuleControllerTest.assertFalse((boolean)ridget.isOutputOnly());
    }

    private void basicTestEnabled(IMarkableRidget ridget) {
        MarkerSubModuleControllerTest.assertTrue((boolean)ridget.isEnabled());
        ridget.setEnabled(false);
        MarkerSubModuleControllerTest.assertFalse((boolean)ridget.isEnabled());
        ridget.setEnabled(true);
        MarkerSubModuleControllerTest.assertTrue((boolean)ridget.isEnabled());
    }

    private void basicTestVisible(IMarkableRidget ridget) {
        MarkerSubModuleControllerTest.assertTrue((boolean)ridget.isVisible());
        ridget.setVisible(false);
        MarkerSubModuleControllerTest.assertFalse((boolean)ridget.isVisible());
        ridget.setVisible(true);
        MarkerSubModuleControllerTest.assertTrue((boolean)ridget.isVisible());
    }

    private List<IMarkableRidget> getAllMarkableRidgets() {
        ArrayList<IMarkableRidget> markableRidgets = new ArrayList<IMarkableRidget>();
        markableRidgets.add((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(ITextRidget.class, "textName"));
        markableRidgets.add((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(IDecimalTextRidget.class, "textPrice"));
        markableRidgets.add((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(INumericTextRidget.class, "textAmount"));
        markableRidgets.add((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(IDateTextRidget.class, "textDate"));
        markableRidgets.add((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(IDateTimeRidget.class, "dtDate"));
        markableRidgets.add((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(IComboRidget.class, "comboAge"));
        markableRidgets.add((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(ISingleChoiceRidget.class, "choiceType"));
        markableRidgets.add((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(IMultipleChoiceRidget.class, "choiceFlavor"));
        markableRidgets.add((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "buttonToggle"));
        markableRidgets.add((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "buttonRadioA"));
        markableRidgets.add((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "buttonRadioB"));
        markableRidgets.add((IMarkableRidget)((MarkerSubModuleController)this.getController()).getRidget(IToggleButtonRidget.class, "buttonCheck"));
        return markableRidgets;
    }
}

