/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core;

import org.easymock.EasyMock;
import org.eclipse.riena.communication.core.RemoteServiceDescription;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.tests.Activator;
import org.osgi.framework.ServiceReference;

@NonUITestCase
public class RemoteServiceDescriptionTest
extends RienaTestCase {
    public void testDefaultCreation() {
        RemoteServiceDescription rsd = new RemoteServiceDescription();
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getBundleName());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getPath());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getProperty(""));
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getProtocol());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getService());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getServiceInterfaceClassName());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getURL());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getVersion());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getServiceInterfaceClass());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getServiceRef());
        RemoteServiceDescriptionTest.assertEquals((Object)RemoteServiceDescription.State.REGISTERED, (Object)rsd.getState());
    }

    public void testNonDefaultCreationObjectClass() {
        ServiceReference ref = (ServiceReference)EasyMock.createMock(ServiceReference.class);
        EasyMock.expect((Object)ref.getPropertyKeys()).andReturn((Object)new String[]{"objectClass"});
        EasyMock.expect((Object)ref.getBundle()).andReturn((Object)Activator.getDefault().getBundle());
        EasyMock.replay((Object[])new Object[]{ref});
        String service = "Service";
        RemoteServiceDescription rsd = new RemoteServiceDescription(ref, (Object)service, String.class);
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getProperty(""));
        RemoteServiceDescriptionTest.assertNotNull((Object)rsd.getBundleName());
        RemoteServiceDescriptionTest.assertEquals((String)Activator.getDefault().getBundle().getSymbolicName(), (String)rsd.getBundleName());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getPath());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getProtocol());
        RemoteServiceDescriptionTest.assertTrue((service == rsd.getService() ? 1 : 0) != 0);
        RemoteServiceDescriptionTest.assertEquals((String)String.class.getName(), (String)rsd.getServiceInterfaceClassName());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getURL());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getVersion());
        RemoteServiceDescriptionTest.assertEquals(String.class, (Object)rsd.getServiceInterfaceClass());
        RemoteServiceDescriptionTest.assertNotNull((Object)rsd.getServiceRef());
        RemoteServiceDescriptionTest.assertEquals((Object)RemoteServiceDescription.State.REGISTERED, (Object)rsd.getState());
    }

    public void testNonDefaultCreationPropRemoteProtocol() {
        ServiceReference ref = (ServiceReference)EasyMock.createMock(ServiceReference.class);
        EasyMock.expect((Object)ref.getPropertyKeys()).andReturn((Object)new String[]{"riena.remote.protocol"});
        EasyMock.expect((Object)ref.getProperty("riena.remote.protocol")).andReturn((Object)"https");
        EasyMock.expect((Object)ref.getBundle()).andReturn((Object)Activator.getDefault().getBundle());
        EasyMock.replay((Object[])new Object[]{ref});
        String service = "Service";
        RemoteServiceDescription rsd = new RemoteServiceDescription(ref, (Object)service, String.class);
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getProperty(""));
        RemoteServiceDescriptionTest.assertNotNull((Object)rsd.getBundleName());
        RemoteServiceDescriptionTest.assertEquals((String)Activator.getDefault().getBundle().getSymbolicName(), (String)rsd.getBundleName());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getPath());
        RemoteServiceDescriptionTest.assertEquals((String)"https", (String)rsd.getProtocol());
        RemoteServiceDescriptionTest.assertTrue((service == rsd.getService() ? 1 : 0) != 0);
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getServiceInterfaceClassName());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getURL());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getVersion());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getServiceInterfaceClass());
        RemoteServiceDescriptionTest.assertNotNull((Object)rsd.getServiceRef());
        RemoteServiceDescriptionTest.assertEquals((Object)RemoteServiceDescription.State.REGISTERED, (Object)rsd.getState());
    }

    public void testNonDefaultCreationPropRemotePath() {
        ServiceReference ref = (ServiceReference)EasyMock.createMock(ServiceReference.class);
        EasyMock.expect((Object)ref.getPropertyKeys()).andReturn((Object)new String[]{"riena.remote.path"});
        EasyMock.expect((Object)ref.getProperty("riena.remote.path")).andReturn((Object)"/server/here");
        EasyMock.expect((Object)ref.getBundle()).andReturn((Object)Activator.getDefault().getBundle());
        EasyMock.replay((Object[])new Object[]{ref});
        String service = "Service";
        RemoteServiceDescription rsd = new RemoteServiceDescription(ref, (Object)service, String.class);
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getProperty(""));
        RemoteServiceDescriptionTest.assertNotNull((Object)rsd.getBundleName());
        RemoteServiceDescriptionTest.assertEquals((String)Activator.getDefault().getBundle().getSymbolicName(), (String)rsd.getBundleName());
        RemoteServiceDescriptionTest.assertEquals((String)"/server/here", (String)rsd.getPath());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getProtocol());
        RemoteServiceDescriptionTest.assertTrue((service == rsd.getService() ? 1 : 0) != 0);
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getServiceInterfaceClassName());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getURL());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getVersion());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getServiceInterfaceClass());
        RemoteServiceDescriptionTest.assertNotNull((Object)rsd.getServiceRef());
        RemoteServiceDescriptionTest.assertEquals((Object)RemoteServiceDescription.State.REGISTERED, (Object)rsd.getState());
    }

    public void testNonDefaultCreationPropConfigId() {
        ServiceReference ref = (ServiceReference)EasyMock.createMock(ServiceReference.class);
        EasyMock.expect((Object)ref.getPropertyKeys()).andReturn((Object)new String[]{"riena.config.id"});
        EasyMock.expect((Object)ref.getProperty("riena.config.id")).andReturn((Object)"org.eclipse.riena.configid");
        EasyMock.expect((Object)ref.getBundle()).andReturn((Object)Activator.getDefault().getBundle());
        EasyMock.replay((Object[])new Object[]{ref});
        String service = "Service";
        RemoteServiceDescription rsd = new RemoteServiceDescription(ref, (Object)service, String.class);
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getProperty(""));
        RemoteServiceDescriptionTest.assertNotNull((Object)rsd.getBundleName());
        RemoteServiceDescriptionTest.assertEquals((String)Activator.getDefault().getBundle().getSymbolicName(), (String)rsd.getBundleName());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getPath());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getProtocol());
        RemoteServiceDescriptionTest.assertTrue((service == rsd.getService() ? 1 : 0) != 0);
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getServiceInterfaceClassName());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getURL());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getVersion());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getServiceInterfaceClass());
        RemoteServiceDescriptionTest.assertNotNull((Object)rsd.getServiceRef());
        RemoteServiceDescriptionTest.assertEquals((Object)RemoteServiceDescription.State.REGISTERED, (Object)rsd.getState());
    }

    public void testNonDefaultCreationPropElse() {
        ServiceReference ref = (ServiceReference)EasyMock.createMock(ServiceReference.class);
        EasyMock.expect((Object)ref.getPropertyKeys()).andReturn((Object)new String[]{"the Answer to Life, the Universe, and Everything"});
        EasyMock.expect((Object)ref.getProperty("the Answer to Life, the Universe, and Everything")).andReturn((Object)"42");
        EasyMock.expect((Object)ref.getBundle()).andReturn((Object)Activator.getDefault().getBundle());
        EasyMock.replay((Object[])new Object[]{ref});
        String service = "Service";
        RemoteServiceDescription rsd = new RemoteServiceDescription(ref, (Object)service, String.class);
        RemoteServiceDescriptionTest.assertEquals((Object)"42", (Object)rsd.getProperty("the Answer to Life, the Universe, and Everything"));
        RemoteServiceDescriptionTest.assertNotNull((Object)rsd.getBundleName());
        RemoteServiceDescriptionTest.assertEquals((String)Activator.getDefault().getBundle().getSymbolicName(), (String)rsd.getBundleName());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getPath());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getProtocol());
        RemoteServiceDescriptionTest.assertTrue((service == rsd.getService() ? 1 : 0) != 0);
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getServiceInterfaceClassName());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getURL());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getVersion());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getServiceInterfaceClass());
        RemoteServiceDescriptionTest.assertNotNull((Object)rsd.getServiceRef());
        RemoteServiceDescriptionTest.assertEquals((Object)RemoteServiceDescription.State.REGISTERED, (Object)rsd.getState());
    }

    public void testNonDefaultCreationAllTheStuff() {
        ServiceReference ref = (ServiceReference)EasyMock.createMock(ServiceReference.class);
        EasyMock.expect((Object)ref.getPropertyKeys()).andReturn((Object)new String[]{"objectClass", "riena.remote.path", "riena.remote.protocol", "riena.config.id", "the Answer to Life, the Universe, and Everything"});
        EasyMock.expect((Object)ref.getProperty("objectClass")).andReturn(String.class);
        EasyMock.expect((Object)ref.getProperty("the Answer to Life, the Universe, and Everything")).andReturn((Object)"42");
        EasyMock.expect((Object)ref.getProperty("riena.remote.protocol")).andReturn((Object)"https");
        EasyMock.expect((Object)ref.getProperty("riena.remote.path")).andReturn((Object)"/server/here");
        EasyMock.expect((Object)ref.getProperty("riena.config.id")).andReturn((Object)"org.eclipse.riena.configid");
        EasyMock.expect((Object)ref.getBundle()).andReturn((Object)Activator.getDefault().getBundle());
        EasyMock.replay((Object[])new Object[]{ref});
        String service = "Service";
        RemoteServiceDescription rsd = new RemoteServiceDescription(ref, (Object)service, String.class);
        RemoteServiceDescriptionTest.assertEquals((Object)"42", (Object)rsd.getProperty("the Answer to Life, the Universe, and Everything"));
        RemoteServiceDescriptionTest.assertNotNull((Object)rsd.getBundleName());
        RemoteServiceDescriptionTest.assertEquals((String)Activator.getDefault().getBundle().getSymbolicName(), (String)rsd.getBundleName());
        RemoteServiceDescriptionTest.assertEquals((String)"/server/here", (String)rsd.getPath());
        RemoteServiceDescriptionTest.assertEquals((String)"https", (String)rsd.getProtocol());
        RemoteServiceDescriptionTest.assertTrue((service == rsd.getService() ? 1 : 0) != 0);
        RemoteServiceDescriptionTest.assertEquals((String)String.class.getName(), (String)rsd.getServiceInterfaceClassName());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getURL());
        RemoteServiceDescriptionTest.assertNull((Object)rsd.getVersion());
        RemoteServiceDescriptionTest.assertEquals(String.class, (Object)rsd.getServiceInterfaceClass());
        RemoteServiceDescriptionTest.assertNotNull((Object)rsd.getServiceRef());
        RemoteServiceDescriptionTest.assertEquals((Object)RemoteServiceDescription.State.REGISTERED, (Object)rsd.getState());
    }
}

