/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.attachment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.easymock.EasyMock;
import org.eclipse.riena.communication.core.attachment.ByteArrayDataSource;
import org.eclipse.riena.communication.core.attachment.IDataSource;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class ByteArrayDataSourceTest
extends RienaTestCase {
    private IDataSource dataSourceMock;
    private static final String NAME = "Test";

    protected void setUp() throws Exception {
        super.setUp();
    }

    private void setUpDataSourceMock(int length) throws Exception {
        this.dataSourceMock = (IDataSource)EasyMock.createMock(IDataSource.class);
        EasyMock.expect((Object)this.dataSourceMock.getName()).andReturn((Object)NAME);
        EasyMock.expect((Object)this.dataSourceMock.getInputStream()).andReturn((Object)this.getInputStream(length));
        EasyMock.replay((Object[])new Object[]{this.dataSourceMock});
    }

    private InputStream getInputStream(int length) {
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < length) {
            bytes[i] = (byte)i;
            ++i;
        }
        return new ByteArrayInputStream(bytes);
    }

    protected void tearDown() throws Exception {
        if (this.dataSourceMock != null) {
            EasyMock.verify((Object[])new Object[]{this.dataSourceMock});
        }
        super.tearDown();
    }

    public void testCreationEmpty() throws Exception {
        this.checkDataSource(0);
    }

    public void testCreationLong() throws Exception {
        this.checkDataSource(10240);
    }

    public void testCreationVeryLong() throws Exception {
        this.checkDataSource(0x100000);
    }

    public void testCreationVeryVeryLong() throws Exception {
        this.checkDataSource(0xA00000);
    }

    public void testNullDataSource() throws Exception {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(null);
        ByteArrayDataSourceTest.assertNull((Object)dataSource.getName());
        ByteArrayDataSourceTest.assertNull((Object)dataSource.getInputStream());
    }

    private void checkDataSource(int length) throws Exception {
        this.setUpDataSourceMock(length);
        long before = System.currentTimeMillis();
        ByteArrayDataSource dataSource = new ByteArrayDataSource(this.dataSourceMock);
        this.println("Run with " + length + " bytes took " + (System.currentTimeMillis() - before) + " ms.");
        this.assertEquals(this.getInputStream(length), dataSource.getInputStream());
        ByteArrayDataSourceTest.assertEquals((String)NAME, (String)dataSource.getName());
    }

    private void assertEquals(InputStream inputStream1, InputStream inputStream2) {
        int byte1 = 0;
        int byte2 = 0;
        while (byte1 != -1 && byte2 != -1) {
            try {
                byte1 = inputStream1.read();
                byte2 = inputStream2.read();
                ByteArrayDataSourceTest.assertEquals((int)byte1, (int)byte2);
            }
            catch (IOException ioe) {
                ByteArrayDataSourceTest.fail((String)ioe.getMessage());
            }
        }
    }
}

