/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.injector.extension.ConfigurableThingModify;
import org.eclipse.riena.core.injector.extension.ConfigurableThingModifyInterfaceOff;
import org.eclipse.riena.core.injector.extension.ConfigurableThingModifyMethodOff;
import org.eclipse.riena.core.injector.extension.ConfigurableThingMultipleData;
import org.eclipse.riena.core.injector.extension.ConfigurableThingMultipleDataSpecific;
import org.eclipse.riena.core.injector.extension.ConfigurableThingSingleData;
import org.eclipse.riena.core.injector.extension.ConfigurableThingSingleData8;
import org.eclipse.riena.core.injector.extension.ExtensionInjector;
import org.eclipse.riena.core.injector.extension.IData;
import org.eclipse.riena.core.injector.extension.IData2;
import org.eclipse.riena.core.injector.extension.IData3;
import org.eclipse.riena.core.injector.extension.IExtData;
import org.eclipse.riena.core.injector.extension.ILazyThing;
import org.eclipse.riena.core.injector.extension.ISubData;
import org.eclipse.riena.core.injector.extension.LazyThing;
import org.eclipse.riena.core.injector.extension.Thing259478;
import org.eclipse.riena.core.util.VariableManagerUtil;
import org.eclipse.riena.internal.core.test.ExtensionRegistryAnalyzer;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.tests.Activator;

@NonUITestCase
public class ExtensionInjectorTest
extends RienaTestCase {
    public void testConstructorConstraints() {
        this.printTestName();
        try {
            Inject.extension(null);
            ExtensionInjectorTest.fail((String)"Exception expected");
        }
        catch (RuntimeException runtimeException) {
            this.ok("Exception expected");
        }
    }

    public void testUseTypeConstraints() {
        this.printTestName();
        try {
            Inject.extension((String)"id").useType(null);
            ExtensionInjectorTest.fail((String)"Exception expected");
        }
        catch (RuntimeException runtimeException) {
            this.ok("Exception expected");
        }
        try {
            Inject.extension((String)"id").useType(IData.class).useType(IData.class);
            ExtensionInjectorTest.fail((String)"Exception expected");
        }
        catch (RuntimeException runtimeException) {
            this.ok("Exception expected");
        }
        try {
            Inject.extension((String)"id").useType(String.class);
            ExtensionInjectorTest.fail((String)"Exception expected");
        }
        catch (RuntimeException runtimeException) {
            this.ok("Exception expected");
        }
    }

    public void testExpectingConstraints() {
        this.printTestName();
        try {
            Inject.extension((String)"id").expectingMinMax(2, 1);
            ExtensionInjectorTest.fail((String)"Exception expected");
        }
        catch (RuntimeException runtimeException) {
            this.ok("Exception expected");
        }
        try {
            Inject.extension((String)"id").expectingMinMax(-1, 0);
            ExtensionInjectorTest.fail((String)"Exception expected");
        }
        catch (RuntimeException runtimeException) {
            this.ok("Exception expected");
        }
        try {
            Inject.extension((String)"id").expectingMinMax(0, 0);
            ExtensionInjectorTest.fail((String)"Exception expected");
        }
        catch (RuntimeException runtimeException) {
            this.ok("Exception expected");
        }
    }

    public void testInjectIntoConstraints() {
        this.printTestName();
        try {
            Inject.extension((String)"id").into(null);
            ExtensionInjectorTest.fail((String)"Exception expected");
        }
        catch (RuntimeException runtimeException) {
            this.ok("Exception expected");
        }
    }

    public void testWithKnownTypeAndMultipleData() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext1.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext2.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext3.xml");
        try {
            ConfigurableThingMultipleData target = new ConfigurableThingMultipleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").useType(IData.class).into((Object)target).andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertEquals((int)3, (int)target.getData().length);
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id1");
            this.removeExtension("core.test.extpoint.id2");
            this.removeExtension("core.test.extpoint.id3");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testWithUnknownTypeAndMultipleData() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext1.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext2.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext3.xml");
        try {
            ConfigurableThingMultipleData target = new ConfigurableThingMultipleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").into((Object)target).andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertEquals((int)3, (int)target.getData().length);
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id1");
            this.removeExtension("core.test.extpoint.id2");
            this.removeExtension("core.test.extpoint.id3");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testWithKnownTypeAndSingleData() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext1.xml");
        try {
            ConfigurableThingSingleData target = new ConfigurableThingSingleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").useType(IData.class).expectingExactly(1).into((Object)target).update("configure").andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                ExtensionInjectorTest.assertTrue((boolean)target.getData().getValue().contains("And Now for Something Completely Different!"));
                ExtensionInjectorTest.assertTrue((boolean)target.getData().getRequired());
                ExtensionInjectorTest.assertTrue((boolean)target.getData().isRequired());
                ExtensionInjectorTest.assertEquals((String)"test1", (String)target.getData().getText());
                ExtensionInjectorTest.assertEquals(String.class, target.getData().createObjectType().getClass());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id1");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testNonCachingOfCreateWithKnownTypeAndSingleData() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext1.xml");
        try {
            ConfigurableThingSingleData target = new ConfigurableThingSingleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").useType(IData.class).expectingExactly(1).into((Object)target).update("configure").andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                String created1 = (String)target.getData().createObjectType();
                String created2 = (String)target.getData().createObjectType();
                ExtensionInjectorTest.assertNotSame((Object)created1, (Object)created2);
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id1");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testWithUnknownTypeAndSingleData() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext2.xml");
        try {
            ConfigurableThingSingleData target = new ConfigurableThingSingleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").expectingExactly(1).into((Object)target).update("configure").andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                ExtensionInjectorTest.assertFalse((boolean)target.getData().getRequired());
                ExtensionInjectorTest.assertFalse((boolean)target.getData().isRequired());
                ExtensionInjectorTest.assertEquals((String)"test2", (String)target.getData().getText());
                ExtensionInjectorTest.assertEquals(HashMap.class, target.getData().createObjectType().getClass());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id2");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testCoerceWithUnknownTypeAndSingleData() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext4.xml");
        try {
            ConfigurableThingSingleData target = new ConfigurableThingSingleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").expectingExactly(1).into((Object)target).update("configure").andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                ExtensionInjectorTest.assertTrue((boolean)target.getData().getRequired());
                ExtensionInjectorTest.assertEquals((String)"test4", (String)target.getData().getText());
                ExtensionInjectorTest.assertEquals(ArrayList.class, target.getData().createObjectType().getClass());
                ExtensionInjectorTest.assertEquals((int)42, (int)target.getData().getJustAByte());
                ExtensionInjectorTest.assertEquals((Object)Math.E, (Object)target.getData().getDoubleNumber());
                ExtensionInjectorTest.assertEquals((Object)Float.valueOf(3.14159f), (Object)Float.valueOf(target.getData().getFloatNumber()));
                ExtensionInjectorTest.assertEquals((int)123, (int)target.getData().getIntegerNumber());
                ExtensionInjectorTest.assertEquals((long)1234567890L, (long)target.getData().getLongNumber());
                ExtensionInjectorTest.assertEquals((int)1, (int)target.getData().getShortNumber());
                ExtensionInjectorTest.assertEquals((char)'#', (char)target.getData().getDelimCharacter());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id4");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void XXX_testTrackingWithKnownTypeAndMultipleData() throws InterruptedException {
        System.out.println("ExtensionInjectorTest.testTrackingWithKnownTypeAndMultipleData()");
        this.printTestName();
        ExtensionRegistryAnalyzer.dumpRegistry((String)"core.test.extpoint");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml", 500);
        ExtensionRegistryAnalyzer.dumpRegistry((String)"core.test.extpoint");
        try {
            ConfigurableThingMultipleData target = new ConfigurableThingMultipleData();
            target.setTrace(true);
            ExtensionInjector injector = null;
            try {
                this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext1.xml", 500);
                ExtensionRegistryAnalyzer.dumpRegistry((String)"core.test.extpoint");
                injector = Inject.extension((String)"core.test.extpoint").useType(IData.class).into((Object)target).andStart(this.getContext());
                try {
                    ExtensionInjectorTest.assertEquals((int)1, (int)target.getData().length);
                    this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext2.xml", 500);
                    ExtensionRegistryAnalyzer.dumpRegistry((String)"core.test.extpoint");
                    try {
                        ExtensionInjectorTest.assertEquals((int)2, (int)target.getData().length);
                        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext3.xml", 500);
                        ExtensionRegistryAnalyzer.dumpRegistry((String)"core.test.extpoint");
                        try {
                            ExtensionInjectorTest.assertEquals((int)3, (int)target.getData().length);
                        }
                        finally {
                            this.removeExtension("core.test.extpoint.id3", 500);
                        }
                        ExtensionInjectorTest.assertEquals((int)2, (int)target.getData().length);
                    }
                    finally {
                        this.removeExtension("core.test.extpoint.id2", 500);
                    }
                    ExtensionInjectorTest.assertEquals((int)1, (int)target.getData().length);
                }
                finally {
                    this.removeExtension("core.test.extpoint.id1", 500);
                }
                ExtensionInjectorTest.assertEquals((int)0, (int)target.getData().length);
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtensionPoint("core.test.extpoint");
            ExtensionRegistryAnalyzer.dumpRegistry((String)"core.test.extpoint");
        }
    }

    public void testModifyWithUnknownTypeAndSingleData() throws CoreException {
        this.printTestName();
        VariableManagerUtil.addVariable((String)"true", (String)"true");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext5.xml");
        try {
            ConfigurableThingSingleData target = new ConfigurableThingSingleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").expectingExactly(1).into((Object)target).update("configure").andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                ExtensionInjectorTest.assertTrue((boolean)target.getData().getRequired());
                ExtensionInjectorTest.assertEquals((String)"test5", (String)target.getData().getText());
                ExtensionInjectorTest.assertEquals(String.class, target.getData().createObjectType().getClass());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id5");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testWithUnknownTypeAndSingleDataAndOneNestedSingleElementAndTwoNestedMultipleElements() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext6.xml");
        try {
            ConfigurableThingSingleData target = new ConfigurableThingSingleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").expectingExactly(1).into((Object)target).update("configure").andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                ExtensionInjectorTest.assertFalse((boolean)target.getData().getRequired());
                ExtensionInjectorTest.assertFalse((boolean)target.getData().isRequired());
                ExtensionInjectorTest.assertEquals((String)"test6", (String)target.getData().getText());
                ExtensionInjectorTest.assertEquals(String.class, target.getData().createObjectType().getClass());
                IData2 data2 = target.getData().getNews();
                ExtensionInjectorTest.assertNotNull((Object)data2);
                ExtensionInjectorTest.assertEquals((String)"rmation", (String)data2.getInfo());
                IData3[] data3 = target.getData().getMoreData();
                ExtensionInjectorTest.assertNotNull((Object)data3);
                ExtensionInjectorTest.assertEquals((int)2, (int)data3.length);
                ExtensionInjectorTest.assertEquals((String)"more-one", (String)data3[0].getId());
                ExtensionInjectorTest.assertEquals((String)"Hugo", (String)data3[0].getName());
                ExtensionInjectorTest.assertEquals((String)"more-two", (String)data3[1].getId());
                ExtensionInjectorTest.assertEquals((String)"Hella", (String)data3[1].getName());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id6");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testWithUnknownTypeDefaultValues() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext8.xml");
        try {
            ConfigurableThingSingleData8 target = new ConfigurableThingSingleData8();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").expectingExactly(1).into((Object)target).update("configure").andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                ExtensionInjectorTest.assertTrue((boolean)target.getData().isRequired());
                ExtensionInjectorTest.assertEquals((String)"not empty", (String)target.getData().getText());
                ExtensionInjectorTest.assertNull((Object)target.getData().getMoreText());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id8");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testCachingWithUnknownTypeAndSingleDataAndOneNestedSingleElementAndTwoNestedMultipleElements() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext6.xml");
        try {
            ConfigurableThingSingleData target = new ConfigurableThingSingleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").expectingExactly(1).into((Object)target).update("configure").andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                ExtensionInjectorTest.assertFalse((boolean)target.getData().getRequired());
                ExtensionInjectorTest.assertFalse((boolean)target.getData().isRequired());
                ExtensionInjectorTest.assertEquals((String)"test6", (String)target.getData().getText());
                ExtensionInjectorTest.assertEquals(String.class, target.getData().createObjectType().getClass());
                IData2 data21 = target.getData().getNews();
                IData2 data22 = target.getData().getNews();
                ExtensionInjectorTest.assertSame((Object)data21, (Object)data22);
                IData3[] data31 = target.getData().getMoreData();
                IData3[] data32 = target.getData().getMoreData();
                ExtensionInjectorTest.assertSame((Object)data31, (Object)data32);
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id6");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testBug240766WithMultipleData() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext1-sub.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext2.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext3.xml");
        try {
            ConfigurableThingMultipleData target = new ConfigurableThingMultipleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").useType(ISubData.class).into((Object)target).andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertEquals((int)3, (int)target.getData().length);
                ExtensionInjectorTest.assertTrue((boolean)ISubData.class.isInstance(target.getData()[0]));
                ExtensionInjectorTest.assertEquals((String)"This check relies on the order that extensions are added to the extension registry!", (String)"SubSub", (String)((ISubData)target.getData()[0]).getSubText());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id1");
            this.removeExtension("core.test.extpoint.id2");
            this.removeExtension("core.test.extpoint.id3");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testBug240766WithSingleData() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext1-sub.xml");
        try {
            ConfigurableThingSingleData target = new ConfigurableThingSingleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").useType(ISubData.class).expectingExactly(1).into((Object)target).update("configure").andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                ExtensionInjectorTest.assertEquals((String)("Dynamic proxy for " + ISubData.class.getName() + ":subText=SubSub,required=true,objectType=java.lang.String,text=test1"), (String)target.getData().toString());
                ExtensionInjectorTest.assertTrue((boolean)ISubData.class.isInstance(target.getData()));
                ExtensionInjectorTest.assertEquals((String)"SubSub", (String)((ISubData)target.getData()).getSubText());
                ExtensionInjectorTest.assertTrue((boolean)target.getData().getValue().contains("And Now for Something Completely Different!"));
                ExtensionInjectorTest.assertTrue((boolean)target.getData().getRequired());
                ExtensionInjectorTest.assertTrue((boolean)target.getData().isRequired());
                ExtensionInjectorTest.assertEquals((String)"test1", (String)target.getData().getText());
                ExtensionInjectorTest.assertEquals(String.class, target.getData().createObjectType().getClass());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id1");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testBug259478WithSingleData() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext259478.xml");
        try {
            ConfigurableThingSingleData target = new ConfigurableThingSingleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").useType(IData.class).expectingExactly(1).into((Object)target).update("configure").andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                Object obj = target.getData().createObjectType();
                ExtensionInjectorTest.assertTrue((boolean)(obj instanceof Thing259478));
                Map<String, String> properties = ((Thing259478)obj).properties;
                ExtensionInjectorTest.assertEquals((String)"1", (String)properties.get("eins"));
                ExtensionInjectorTest.assertEquals((String)"2", (String)properties.get("zwei"));
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id8");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testEqualsAndHashCode() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext1.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext2.xml");
        try {
            ConfigurableThingMultipleData target = new ConfigurableThingMultipleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").useType(IData.class).into((Object)target).andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertEquals((int)2, (int)target.getData().length);
                ExtensionInjectorTest.assertEquals((Object)target.getData()[0], (Object)target.getData()[0]);
                ExtensionInjectorTest.assertEquals((Object)target.getData()[1], (Object)target.getData()[1]);
                ExtensionInjectorTest.assertFalse((boolean)target.getData()[0].equals(target.getData()[1]));
                ExtensionInjectorTest.assertFalse((boolean)target.getData()[0].equals("no"));
                ExtensionInjectorTest.assertTrue((String)"This test is based on the fact that the hashCode for IConfigurationElement is based on a handle which is a different int for every element.", (target.getData()[0].hashCode() != target.getData()[1].hashCode() ? 1 : 0) != 0);
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id1");
            this.removeExtension("core.test.extpoint.id2");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testGetContributor() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext1.xml");
        try {
            ConfigurableThingMultipleData target = new ConfigurableThingMultipleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").useType(IData.class).into((Object)target).andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertEquals((int)1, (int)target.getData().length);
                ExtensionInjectorTest.assertEquals((Object)Activator.getDefault().getBundle(), (Object)target.getData()[0].getContributingBundle());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id1");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testGetConfigurationElement() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext1.xml");
        try {
            ConfigurableThingMultipleData target = new ConfigurableThingMultipleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").useType(IData.class).into((Object)target).andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertEquals((int)1, (int)target.getData().length);
                IConfigurationElement conf = target.getData()[0].getConfigurationElement();
                ExtensionInjectorTest.assertEquals((String)"test1", (String)conf.getAttribute("text"));
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id1");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testGetClassType() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext7.xml");
        try {
            ConfigurableThingMultipleData target = new ConfigurableThingMultipleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").useType(IData.class).into((Object)target).andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertEquals((int)1, (int)target.getData().length);
                ExtensionInjectorTest.assertEquals(LazyThing.class, target.getData()[0].getLazyThingType());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id7");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testLazyCreate() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext7.xml");
        try {
            ConfigurableThingMultipleData target = new ConfigurableThingMultipleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").useType(IData.class).into((Object)target).andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertEquals((int)1, (int)target.getData().length);
                ExtensionInjectorTest.assertFalse((boolean)LazyThing.instantiated);
                ILazyThing lazyThing = target.getData()[0].createLazyThing();
                ExtensionInjectorTest.assertFalse((boolean)LazyThing.instantiated);
                lazyThing.doSomething();
                ExtensionInjectorTest.assertTrue((boolean)LazyThing.instantiated);
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id7");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testWithUnknownTypeAndMultipleDataSpecific() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext1.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext2.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext3.xml");
        try {
            ConfigurableThingMultipleDataSpecific target = new ConfigurableThingMultipleDataSpecific();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").into((Object)target).specific().andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertEquals((int)3, (int)target.getExtData().length);
                IExtData[] iExtDataArray = target.getExtData();
                int n = iExtDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtData data = iExtDataArray[n2];
                    if (data.getTest()[0].getText().equals("test1")) {
                        ExtensionInjectorTest.assertEquals((String)"java.lang.String", (String)data.getTest()[0].createObjectType().getClass().getName());
                    } else if (data.getTest()[0].getText().equals("test2")) {
                        ExtensionInjectorTest.assertEquals((String)"java.util.HashMap", (String)data.getTest()[0].createObjectType().getClass().getName());
                    } else if (data.getTest()[0].getText().equals("test3")) {
                        ExtensionInjectorTest.assertEquals((String)"java.util.ArrayList", (String)data.getTest()[0].createObjectType().getClass().getName());
                    } else {
                        ExtensionInjectorTest.fail((String)"Argh!");
                    }
                    ++n2;
                }
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id1");
            this.removeExtension("core.test.extpoint.id2");
            this.removeExtension("core.test.extpoint.id3");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testWithUnknownTypeAndMultipleDataSpecific2() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext-a.xml");
        try {
            ConfigurableThingMultipleDataSpecific target = new ConfigurableThingMultipleDataSpecific();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").into((Object)target).specific().andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertEquals((int)1, (int)target.getExtData().length);
                IExtData[] iExtDataArray = target.getExtData();
                int n = iExtDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtData extData = iExtDataArray[n2];
                    ExtensionInjectorTest.assertEquals((int)2, (int)extData.getTest().length);
                    IData[] iDataArray = extData.getTest();
                    int n3 = iDataArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IData data = iDataArray[n4];
                        if (data.getText().equals("test-a1")) {
                            ExtensionInjectorTest.assertEquals((String)"java.lang.String", (String)data.createObjectType().getClass().getName());
                        } else if (data.getText().equals("test-a2")) {
                            ExtensionInjectorTest.assertEquals((String)"java.lang.StringBuffer", (String)data.createObjectType().getClass().getName());
                        } else {
                            ExtensionInjectorTest.fail((String)"Argh!");
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id-a");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    public void testModifyGlobalOn() throws CoreException {
        this.printTestName();
        VariableManagerUtil.addVariable((String)"value", (String)"true");
        VariableManagerUtil.addVariable((String)"text", (String)"Hallo!");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext-modify.xml");
        try {
            ConfigurableThingModify target = new ConfigurableThingModify();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").expectingExactly(1).into((Object)target).andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                ExtensionInjectorTest.assertTrue((boolean)target.getData().isRequired());
                ExtensionInjectorTest.assertEquals((String)"Hallo!", (String)target.getData().getText());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id.modify");
            this.removeExtensionPoint("core.test.extpoint");
            VariableManagerUtil.removeVariable((String)"value");
            VariableManagerUtil.removeVariable((String)"text");
        }
    }

    public void testModifyGlobalOff() throws CoreException {
        this.printTestName();
        VariableManagerUtil.addVariable((String)"value", (String)"true");
        VariableManagerUtil.addVariable((String)"text", (String)"Hallo!");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext-modify.xml");
        try {
            ConfigurableThingModify target = new ConfigurableThingModify();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").expectingExactly(1).into((Object)target).doNotReplaceSymbols().andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                ExtensionInjectorTest.assertEquals((String)"${value}", (String)target.getData().getRequired());
                ExtensionInjectorTest.assertEquals((String)"${text}", (String)target.getData().getText());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id.modify");
            this.removeExtensionPoint("core.test.extpoint");
            VariableManagerUtil.removeVariable((String)"value");
            VariableManagerUtil.removeVariable((String)"text");
        }
    }

    public void testModifyInterfaceOff() throws CoreException {
        this.printTestName();
        VariableManagerUtil.addVariable((String)"value", (String)"true");
        VariableManagerUtil.addVariable((String)"text", (String)"Hallo!");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext-modify.xml");
        try {
            ConfigurableThingModifyInterfaceOff target = new ConfigurableThingModifyInterfaceOff();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").expectingExactly(1).into((Object)target).andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                ExtensionInjectorTest.assertEquals((String)"${value}", (String)target.getData().getRequired());
                ExtensionInjectorTest.assertEquals((String)"${text}", (String)target.getData().getText());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id.modify");
            this.removeExtensionPoint("core.test.extpoint");
            VariableManagerUtil.removeVariable((String)"value");
            VariableManagerUtil.removeVariable((String)"text");
        }
    }

    public void testModifyMethodOff() throws CoreException {
        this.printTestName();
        VariableManagerUtil.addVariable((String)"value", (String)"true");
        VariableManagerUtil.addVariable((String)"text", (String)"Hallo!");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorTest.class, "plugin_ext-modify.xml");
        try {
            ConfigurableThingModifyMethodOff target = new ConfigurableThingModifyMethodOff();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").expectingExactly(1).into((Object)target).andStart(this.getContext());
            try {
                ExtensionInjectorTest.assertNotNull((Object)target.getData());
                ExtensionInjectorTest.assertEquals((String)"true", (String)target.getData().getRequired());
                ExtensionInjectorTest.assertEquals((String)"${text}", (String)target.getData().getText());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id.modify");
            this.removeExtensionPoint("core.test.extpoint");
            VariableManagerUtil.removeVariable((String)"value");
            VariableManagerUtil.removeVariable((String)"text");
        }
    }
}

