/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.service;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.injector.InjectionFailure;
import org.eclipse.riena.core.injector.service.DepOne;
import org.eclipse.riena.core.injector.service.DepTwo;
import org.eclipse.riena.core.injector.service.IRanking;
import org.eclipse.riena.core.injector.service.RankingOne;
import org.eclipse.riena.core.injector.service.RankingTwo;
import org.eclipse.riena.core.injector.service.ServiceInjector;
import org.eclipse.riena.core.injector.service.Target;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.osgi.framework.ServiceRegistration;

@NonUITestCase
public class ServiceInjectorTest
extends RienaTestCase {
    public void testInjectDepOneObviousBindUnbindError() {
        this.printTestName();
        Target target = new Target();
        DepOne depOne = new DepOne();
        ServiceRegistration reg = this.getContext().registerService(DepOne.class.getName(), (Object)depOne, null);
        try {
            try {
                Inject.service((String)DepOne.class.getName()).into((Object)target).bind("baind").andStart(this.getContext());
                ServiceInjectorTest.fail((String)"Well, that should not have happended");
            }
            catch (InjectionFailure injectionFailure) {
                ServiceInjectorTest.assertTrue((boolean)true);
                reg.unregister();
            }
        }
        finally {
            reg.unregister();
        }
    }

    public void testInjectDepOneNotSoObviousBindUnbindError() {
        this.printTestName();
        Target target = new Target();
        DepTwo depTwo = new DepTwo();
        ServiceRegistration reg = this.getContext().registerService(DepTwo.class.getName(), (Object)depTwo, null);
        try {
            try {
                Inject.service((String)DepOne.class.getName()).into((Object)target).bind("binde").unbind("entbinde").andStart(this.getContext());
                ServiceInjectorTest.assertEquals((int)0, (int)target.count("binde", DepOne.class));
            }
            catch (InjectionFailure injectionFailure) {
                ServiceInjectorTest.assertTrue((boolean)false);
                reg.unregister();
            }
        }
        finally {
            reg.unregister();
        }
    }

    public void testInjectDepOneDefaultBindUnbind() {
        this.printTestName();
        Target target = new Target();
        DepOne depOne = new DepOne();
        ServiceRegistration reg = this.getContext().registerService(DepOne.class.getName(), (Object)depOne, null);
        ServiceInjector shot = Inject.service((String)DepOne.class.getName()).into((Object)target).andStart(this.getContext());
        ServiceInjectorTest.assertEquals((int)1, (int)target.count("bind", DepOne.class));
        shot.stop();
        ServiceInjectorTest.assertEquals((int)0, (int)target.count("bind", DepOne.class));
        reg.unregister();
    }

    public void testInjectDepOneDefaultBindUnbindUseClassInsteadOfClassname() {
        this.printTestName();
        Target target = new Target();
        DepOne depOne = new DepOne();
        ServiceRegistration reg = this.getContext().registerService(DepOne.class.getName(), (Object)depOne, null);
        ServiceInjector shot = Inject.service(DepOne.class).into((Object)target).andStart(this.getContext());
        ServiceInjectorTest.assertEquals((int)1, (int)target.count("bind", DepOne.class));
        shot.stop();
        ServiceInjectorTest.assertEquals((int)0, (int)target.count("bind", DepOne.class));
        reg.unregister();
    }

    public void testInjectDepOneAndDepTwoDefaultBindUnbind() {
        this.printTestName();
        Target target = new Target();
        DepOne depOne = new DepOne();
        ServiceRegistration reg1 = this.getContext().registerService(DepOne.class.getName(), (Object)depOne, null);
        ServiceInjector shot1 = Inject.service((String)DepOne.class.getName()).into((Object)target).andStart(this.getContext());
        ServiceInjectorTest.assertEquals((int)1, (int)target.count("bind", DepOne.class));
        ServiceInjector shot2 = Inject.service((String)DepTwo.class.getName()).into((Object)target).andStart(this.getContext());
        DepTwo depTwo = new DepTwo();
        ServiceRegistration reg2 = this.getContext().registerService(DepTwo.class.getName(), (Object)depTwo, null);
        ServiceInjectorTest.assertEquals((int)1, (int)target.count("bind", DepTwo.class));
        shot1.stop();
        ServiceInjectorTest.assertEquals((int)0, (int)target.count("bind", DepOne.class));
        shot2.stop();
        ServiceInjectorTest.assertEquals((int)0, (int)target.count("bind", DepTwo.class));
        reg1.unregister();
        reg2.unregister();
    }

    public void testInjectDepOneBindeEntbinde() {
        this.printTestName();
        Target target = new Target();
        DepOne depOne = new DepOne();
        ServiceRegistration reg = this.getContext().registerService(DepOne.class.getName(), (Object)depOne, null);
        ServiceInjector shot = Inject.service((String)DepOne.class.getName()).into((Object)target).bind("binde").unbind("entbinde").andStart(this.getContext());
        ServiceInjectorTest.assertEquals((int)1, (int)target.count("binde", DepOne.class));
        shot.stop();
        ServiceInjectorTest.assertEquals((int)0, (int)target.count("binde", DepOne.class));
        reg.unregister();
    }

    public void testInjectRankedServicesServicesRegisteredBefore() {
        this.printTestName();
        Target target = new Target();
        RankingOne rank1 = new RankingOne(0);
        ServiceRegistration reg1 = this.getContext().registerService(IRanking.class.getName(), (Object)rank1, null);
        RankingTwo rank2 = new RankingTwo(100);
        Hashtable<String, Integer> dict = new Hashtable<String, Integer>();
        ((Dictionary)dict).put("service.ranking", 100);
        ServiceRegistration reg2 = this.getContext().registerService(IRanking.class.getName(), (Object)rank2, dict);
        ServiceInjector shot = Inject.service((String)IRanking.class.getName()).useRanking().into((Object)target).andStart(this.getContext());
        ServiceInjectorTest.assertEquals((int)1, (int)target.count("bind", IRanking.class));
        ServiceInjectorTest.assertEquals((int)100, (int)target.getDepRanking());
        shot.stop();
        ServiceInjectorTest.assertEquals((int)0, (int)target.count("bind", IRanking.class));
        reg1.unregister();
        reg2.unregister();
    }

    public void testInjectRankedServicesServicesRegisteredOnTheRun() {
        this.printTestName();
        Target target = new Target();
        RankingOne rank1 = new RankingOne(0);
        ServiceRegistration reg1 = this.getContext().registerService(IRanking.class.getName(), (Object)rank1, null);
        ServiceInjector shot = Inject.service((String)IRanking.class.getName()).useRanking().into((Object)target).andStart(this.getContext());
        ServiceInjectorTest.assertEquals((int)1, (int)target.count("bind", IRanking.class));
        ServiceInjectorTest.assertEquals((int)0, (int)target.getDepRanking());
        RankingTwo rank2 = new RankingTwo(100);
        Hashtable<String, Integer> dict = new Hashtable<String, Integer>();
        ((Dictionary)dict).put("service.ranking", 100);
        ServiceRegistration reg2 = this.getContext().registerService(IRanking.class.getName(), (Object)rank2, dict);
        ServiceInjectorTest.assertEquals((int)1, (int)target.count("bind", IRanking.class));
        ServiceInjectorTest.assertEquals((int)100, (int)target.getDepRanking());
        reg2.unregister();
        ServiceInjectorTest.assertEquals((int)1, (int)target.count("bind", IRanking.class));
        ServiceInjectorTest.assertEquals((int)0, (int)target.getDepRanking());
        ServiceRegistration reg3 = this.getContext().registerService(IRanking.class.getName(), (Object)rank2, dict);
        ServiceInjectorTest.assertEquals((int)1, (int)target.count("bind", IRanking.class));
        ServiceInjectorTest.assertEquals((int)100, (int)target.getDepRanking());
        shot.stop();
        ServiceInjectorTest.assertEquals((int)0, (int)target.count("bind", IRanking.class));
        reg1.unregister();
        reg3.unregister();
    }

    public void testFilterTest() {
        this.printTestName();
        Target target = new Target();
        DepOne depOne = new DepOne();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("x", "y");
        ServiceRegistration reg = this.getContext().registerService(DepOne.class.getName(), (Object)depOne, props);
        ServiceInjector shot = Inject.service((String)DepOne.class.getName()).useFilter("(x=y)").into((Object)target).andStart(this.getContext());
        ServiceInjectorTest.assertEquals((int)1, (int)target.count("bind", DepOne.class));
        shot.stop();
        ServiceInjectorTest.assertEquals((int)0, (int)target.count("bind", DepOne.class));
        reg.unregister();
    }
}

