/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.ping;

import java.lang.reflect.Method;
import org.eclipse.riena.core.ping.DefaultPingable;
import org.eclipse.riena.core.ping.IPingable;
import org.eclipse.riena.core.ping.PingFingerprint;
import org.eclipse.riena.core.ping.PingMethodAdapter;
import org.eclipse.riena.core.ping.PingVisitor;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class PingMethodAdapterTest
extends RienaTestCase {
    protected PingableMock pingableMock = new PingableMock();

    public void testPingMethodAdapter() throws Exception {
        try {
            new PingMethodAdapter((IPingable)this.pingableMock, null);
            PingMethodAdapterTest.fail((String)"Expected precondition violation");
        }
        catch (Exception exception) {
            this.ok();
        }
        try {
            new PingMethodAdapter(null, this.pingableMock.getPingDiesUndDasMethod());
            PingMethodAdapterTest.fail((String)"Expected precondition violation");
        }
        catch (Exception exception) {
            this.ok();
        }
        new PingMethodAdapter((IPingable)this.pingableMock, this.pingableMock.getPingDiesUndDasMethod());
    }

    public void testPing() throws Exception {
        PingMethodAdapter adapter = new PingMethodAdapter((IPingable)this.pingableMock, this.pingableMock.getPingDiesUndDasMethod());
        adapter.ping(new PingVisitor());
        this.pingableMock.verify();
    }

    public void testGetPingFingerprint() throws Exception {
        PingMethodAdapter adapter = new PingMethodAdapter((IPingable)this.pingableMock, this.pingableMock.getPingDiesUndDasMethod());
        PingMethodAdapterTest.assertEquals((Object)new PingFingerprint((IPingable)this.pingableMock, this.pingableMock.getPingDiesUndDasMethod().getName()), (Object)adapter.getPingFingerprint());
    }

    public void testEqualsAndHash() throws Exception {
        PingMethodAdapter adapter = new PingMethodAdapter((IPingable)this.pingableMock, this.pingableMock.getPingDiesUndDasMethod());
        this.checkEqualsAndHashCode(true, adapter, adapter);
        this.checkEqualsAndHashCode(true, adapter, new PingMethodAdapter((IPingable)this.pingableMock, this.pingableMock.getPingDiesUndDasMethod()));
        this.checkEqualsAndHashCode(true, adapter, new PingMethodAdapter((IPingable)this.pingableMock, this.pingableMock.getPingDiesUndDasMethod()));
        this.checkEqualsAndHashCode(false, adapter, new PingMethodAdapter((IPingable)this.pingableMock, this.pingableMock.getNonePingMethod()));
        PingableMock otherPingableMock = new PingableMock();
        this.checkEqualsAndHashCode(false, adapter, new PingMethodAdapter((IPingable)otherPingableMock, otherPingableMock.getPingDiesUndDasMethod()));
        this.checkEqualsAndHashCode(false, adapter, new PingMethodAdapter((IPingable)otherPingableMock, this.pingableMock.getPingDiesUndDasMethod()));
        this.checkEqualsAndHashCode(false, adapter, 3);
        this.checkEqualsAndHashCode(false, adapter, null);
    }

    private void checkEqualsAndHashCode(boolean equalityExpected, Object first, Object second) {
        if (first == null) {
            PingMethodAdapterTest.assertEquals((boolean)equalityExpected, (first == second ? 1 : 0) != 0);
            return;
        }
        PingMethodAdapterTest.assertEquals((boolean)equalityExpected, (boolean)first.equals(second));
        if (second != null) {
            PingMethodAdapterTest.assertEquals((boolean)equalityExpected, (first.hashCode() == second.hashCode() ? 1 : 0) != 0);
        }
    }

    public void testToString() throws Exception {
        PingMethodAdapter adapter = new PingMethodAdapter((IPingable)this.pingableMock, this.pingableMock.getPingDiesUndDasMethod());
        PingMethodAdapterTest.assertEquals((String)("PingMethodAdapter[pingable=" + (Object)((Object)this.pingableMock) + ", method=" + this.pingableMock.getPingDiesUndDasMethod().getName() + "]"), (String)adapter.toString());
    }

    protected static class PingableMock
    extends DefaultPingable {
        private boolean pingMethodCalled;

        protected PingableMock() {
        }

        public void pingDiesUndDas() {
            this.pingMethodCalled = true;
        }

        public void reset() {
            this.pingMethodCalled = false;
        }

        public void verify() {
            PingMethodAdapterTest.assertEquals((boolean)true, (boolean)this.pingMethodCalled);
        }

        public Method getPingDiesUndDasMethod() throws Exception {
            return ((Object)((Object)this)).getClass().getMethod("pingDiesUndDas", new Class[0]);
        }

        public Method getNonePingMethod() throws Exception {
            return ((Object)((Object)this)).getClass().getMethod("dummyMethod", new Class[0]);
        }

        public void dummyMethod() {
        }
    }
}

