/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.eclipse.core.internal.variables.StringVariableManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.riena.core.util.VariableManagerUtil;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class VariableManagerUtilTest
extends RienaTestCase {
    private static Field fgManager;
    private static final String WWW_ECLIPSE_ORG = "www.eclipse.org";

    static {
        try {
            fgManager = StringVariableManager.class.getDeclaredField("fgManager");
            fgManager.setAccessible(true);
        }
        catch (Throwable throwable) {
            VariableManagerUtilTest.fail((String)"Could not access field \u00b4fgManager\u00b4 from StringVariableManager!");
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        fgManager.set(null, null);
    }

    public void testUpdatedWrongKey() throws CoreException {
        VariableManagerUtil.addVariable((String)"host", (String)"${host");
        VariableManagerUtilTest.assertEquals((String)"${host", (String)VariableManagerUtil.substitute((String)"${host}"));
    }

    public void testUpdatedRecursiveKeyDirectly() {
        try {
            VariableManagerUtil.addVariable((String)"host", (String)"${host}");
            VariableManagerUtil.substitute((String)"${host}");
            VariableManagerUtilTest.fail();
        }
        catch (CoreException e) {
            VariableManagerUtilTest.assertTrue((boolean)e.getMessage().contains("host"));
        }
    }

    public void testUpdatedRecursiveKeyIndirectly1() {
        try {
            VariableManagerUtil.addVariable((String)"a", (String)"${b}");
            VariableManagerUtil.addVariable((String)"b", (String)"${a}");
            VariableManagerUtil.substitute((String)"${a}");
            VariableManagerUtilTest.fail();
        }
        catch (CoreException e) {
            String problemVariableList = e.getMessage().substring(e.getMessage().indexOf(",") - 1, e.getMessage().indexOf(",") + 3);
            VariableManagerUtilTest.assertTrue((boolean)problemVariableList.contains("a"));
            VariableManagerUtilTest.assertTrue((boolean)problemVariableList.contains("b"));
        }
    }

    public void testUpdatedRecursiveKeyIndirectly2() {
        try {
            VariableManagerUtil.addVariable((String)"a", (String)"${b}");
            VariableManagerUtil.addVariable((String)"b", (String)"${c}");
            VariableManagerUtil.addVariable((String)"c", (String)"${a}");
            VariableManagerUtil.substitute((String)"${a}");
            VariableManagerUtilTest.fail();
        }
        catch (CoreException e) {
            String problemVariableList = e.getMessage().substring(e.getMessage().indexOf(",") - 1, e.getMessage().indexOf(",") + 6);
            VariableManagerUtilTest.assertTrue((boolean)problemVariableList.contains("a"));
            VariableManagerUtilTest.assertTrue((boolean)problemVariableList.contains("b"));
            VariableManagerUtilTest.assertTrue((boolean)problemVariableList.contains("c"));
        }
    }

    public void testModifyWrongKey() throws CoreException {
        VariableManagerUtil.addVariable((String)"host", (String)WWW_ECLIPSE_ORG);
        VariableManagerUtilTest.assertEquals((String)"${host", (String)VariableManagerUtil.substitute((String)"${host"));
    }

    public void testModifyEmptyKey() throws CoreException {
        VariableManagerUtil.addVariable((String)"", (String)WWW_ECLIPSE_ORG);
        VariableManagerUtilTest.assertEquals((String)WWW_ECLIPSE_ORG, (String)VariableManagerUtil.substitute((String)"${}"));
    }

    public void testModifySingle() throws CoreException {
        VariableManagerUtil.addVariable((String)"host", (String)WWW_ECLIPSE_ORG);
        VariableManagerUtilTest.assertEquals((String)WWW_ECLIPSE_ORG, (String)VariableManagerUtil.substitute((String)"${host}"));
    }

    public void testModifyDoubleSequentialy() throws CoreException {
        VariableManagerUtil.addVariable((String)"host", (String)WWW_ECLIPSE_ORG);
        VariableManagerUtilTest.assertEquals((String)"www.eclipse.orgwww.eclipse.org", (String)VariableManagerUtil.substitute((String)"${host}${host}"));
    }

    public void testModifyDoubleNested() throws CoreException {
        VariableManagerUtil.addVariable((String)"url", (String)"http://${host}/path");
        VariableManagerUtil.addVariable((String)"host", (String)WWW_ECLIPSE_ORG);
        VariableManagerUtilTest.assertEquals((String)"http://www.eclipse.org/path", (String)VariableManagerUtil.substitute((String)"${url}"));
    }

    public void testRemoveVariable() throws CoreException {
        VariableManagerUtil.addVariable((String)"a", (String)"1");
        VariableManagerUtilTest.assertEquals((String)"1", (String)VariableManagerUtil.substitute((String)"${a}"));
        VariableManagerUtil.removeVariable((String)"a");
        try {
            VariableManagerUtil.substitute((String)"${a}");
            VariableManagerUtilTest.fail();
        }
        catch (CoreException coreException) {
            this.ok();
        }
    }

    public void testAddMultipleVariables() throws CoreException {
        HashMap<String, String> toAdd = new HashMap<String, String>();
        toAdd.put("a", "1");
        toAdd.put("b", "2");
        toAdd.put("c", "3");
        VariableManagerUtil.addVariables(toAdd);
        VariableManagerUtilTest.assertEquals((String)"123", (String)VariableManagerUtil.substitute((String)"${a}${b}${c}"));
    }

    public void testAddMultipleVariablesSomeTwiceButOkBecauseTheyAreEqual() throws CoreException {
        HashMap<String, String> toAdd = new HashMap<String, String>();
        toAdd.put("a", "1");
        toAdd.put("b", "2");
        toAdd.put("c", "3");
        VariableManagerUtil.addVariables(toAdd);
        VariableManagerUtilTest.assertEquals((String)"123", (String)VariableManagerUtil.substitute((String)"${a}${b}${c}"));
        toAdd = new HashMap();
        toAdd.put("d", "4");
        toAdd.put("b", "2");
        toAdd.put("e", "5");
        VariableManagerUtil.addVariables(toAdd);
        VariableManagerUtilTest.assertEquals((String)"12345", (String)VariableManagerUtil.substitute((String)"${a}${b}${c}${d}${e}"));
    }

    public void testAddMultipleVariablesSomeTwiceButNotOkBecauseTheyAreNotEqualSoThatItShouldFail() throws CoreException {
        HashMap<String, String> toAdd = new HashMap<String, String>();
        toAdd.put("a", "1");
        toAdd.put("b", "2");
        toAdd.put("c", "3");
        VariableManagerUtil.addVariables(toAdd);
        VariableManagerUtilTest.assertEquals((String)"123", (String)VariableManagerUtil.substitute((String)"${a}${b}${c}"));
        toAdd = new HashMap();
        toAdd.put("d", "4");
        toAdd.put("b", "6");
        toAdd.put("e", "5");
        try {
            VariableManagerUtil.addVariables(toAdd);
        }
        catch (CoreException coreException) {
            this.ok();
        }
    }
}

