/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import junit.framework.TestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractItemProperties;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractItemRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ToolItemRidget;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class AbstractItemPropertiesTest
extends TestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testItemProperties() {
        ToolItemRidget ridget = new ToolItemRidget();
        ToolBar toolbar = new ToolBar((Composite)this.shell, 2048);
        ToolItem item = new ToolItem(toolbar, 8);
        ridget.setUIControl((Object)item);
        ItemProperties itemProperties = new ItemProperties((AbstractItemRidget)ridget);
        int style = itemProperties.getStyle();
        AbstractItemPropertiesTest.assertEquals((int)8, (int)style);
        AbstractItemRidget retRidget = itemProperties.getRidget();
        AbstractItemPropertiesTest.assertSame((Object)ridget, (Object)retRidget);
    }

    public void testSetAllProperties() {
        ToolItemRidget ridget = new ToolItemRidget();
        ToolBar toolbar = new ToolBar((Composite)this.shell, 2048);
        ToolItem item = new ToolItem(toolbar, 8);
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        String id = "id4711";
        locator.setBindingProperty((Object)item, id);
        item.setText("Text4711");
        item.setData(new Object());
        SelectionListener selListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
            }
        };
        item.addSelectionListener(selListener);
        ridget.setUIControl((Object)item);
        ItemProperties itemProperties = new ItemProperties((AbstractItemRidget)ridget);
        ToolItem item2 = new ToolItem(toolbar, 8);
        itemProperties.setAllProperties((Item)item2, true);
        String retId = locator.locateBindingProperty((Object)item2);
        AbstractItemPropertiesTest.assertEquals((String)id, (String)retId);
        AbstractItemPropertiesTest.assertEquals((String)item.getText(), (String)item2.getText());
        AbstractItemPropertiesTest.assertSame((Object)item.getData(), (Object)item2.getData());
        Listener[] listeners = item.getListeners(13);
        boolean listenerAdded = false;
        Listener[] listenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            if (listener instanceof TypedListener && ((TypedListener)listener).getEventListener() == selListener) {
                listenerAdded = true;
            }
            ++n2;
        }
        AbstractItemPropertiesTest.assertTrue((boolean)listenerAdded);
    }

    private static class ItemProperties
    extends AbstractItemProperties {
        public ItemProperties(AbstractItemRidget ridget) {
            super(ridget);
        }

        Item createItem() {
            return null;
        }

        public void setAllProperties(Item item, boolean addListeners) {
            super.setAllProperties(item, addListeners);
        }

        public int getStyle() {
            return super.getStyle();
        }

        public AbstractItemRidget getRidget() {
            return super.getRidget();
        }
    }
}

