/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.beans.common.TestBean;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLabelRidgetTest
extends AbstractSWTRidgetTest {
    private static final String PLUGIN_ID = "org.eclipse.riena.tests:";
    private static final String ICON_ECLIPSE = "org.eclipse.riena.tests:/icons/eclipse.gif";
    private static final String LABEL = "testlabel";
    private static final String LABEL2 = "testlabel2";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.getRidget().setText(LABEL);
    }

    protected ILabelRidget getRidget() {
        return (ILabelRidget)super.getRidget();
    }

    protected abstract ILabelRidget createRidget();

    protected abstract String getText(Object var1);

    protected abstract void setText(Object var1, String var2);

    protected abstract Image getImage(Object var1);

    protected abstract void setImage(Object var1, Image var2);

    protected abstract Class<? extends ILabelRidget> getRidgetClass();

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        AbstractLabelRidgetTest.assertSame(this.getRidgetClass(), (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public final void testSetIcon() {
        ILabelRidget ridget = this.getRidget();
        ridget.setIcon(ICON_ECLIPSE);
        AbstractLabelRidgetTest.assertEquals((String)ICON_ECLIPSE, (String)ridget.getIcon());
        AbstractLabelRidgetTest.assertNotNull((Object)this.getImage(this.getWidget()));
        ridget.setIcon(null);
        AbstractLabelRidgetTest.assertNull((Object)ridget.getIcon());
        AbstractLabelRidgetTest.assertNull((Object)this.getImage(this.getWidget()));
        Widget label = this.createWidget((Composite)this.getShell());
        Image labelImage = label.getDisplay().getSystemImage(2);
        this.setImage(label, labelImage);
        ILabelRidget labelRidget = this.createRidget();
        labelRidget.setUIControl((Object)label);
        AbstractLabelRidgetTest.assertSame((Object)labelImage, (Object)this.getImage(label));
        labelRidget.setIcon(null);
        AbstractLabelRidgetTest.assertNull((Object)labelRidget.getIcon());
        AbstractLabelRidgetTest.assertNull((Object)this.getImage(label));
        labelRidget.setIcon(ICON_ECLIPSE);
        AbstractLabelRidgetTest.assertEquals((String)ICON_ECLIPSE, (String)labelRidget.getIcon());
        AbstractLabelRidgetTest.assertNotNull((Object)this.getImage(label));
        AbstractLabelRidgetTest.assertNotSame((Object)labelImage, (Object)this.getImage(label));
        label = this.createWidget((Composite)this.getShell());
        this.setImage(label, labelImage);
        labelRidget = this.createRidget();
        labelRidget.setIcon(ICON_ECLIPSE);
        labelRidget.setUIControl((Object)label);
        AbstractLabelRidgetTest.assertNotNull((Object)this.getImage(label));
        AbstractLabelRidgetTest.assertNotSame((Object)labelImage, (Object)this.getImage(label));
    }

    public final void testSetText() throws Exception {
        ILabelRidget ridget = this.getRidget();
        Object widget = ridget.getUIControl();
        ridget.setText(LABEL2);
        AbstractLabelRidgetTest.assertEquals((String)LABEL2, (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)LABEL2, (String)this.getText(widget));
        ridget.setText("");
        AbstractLabelRidgetTest.assertEquals((String)"", (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)"", (String)this.getText(widget));
        try {
            ridget.setText(null);
            AbstractLabelRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
    }

    public void testUpdateFromModel() throws Exception {
        ILabelRidget ridget = this.getRidget();
        Object widget = ridget.getUIControl();
        TestBean bean = new TestBean();
        bean.setProperty((Object)"NewLabel");
        ridget.bindToModel((Object)bean, "property");
        AbstractLabelRidgetTest.assertEquals((Object)"NewLabel", (Object)bean.getProperty());
        AbstractLabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)LABEL, (String)this.getText(widget));
        ridget.updateFromModel();
        AbstractLabelRidgetTest.assertEquals((Object)"NewLabel", (Object)bean.getProperty());
        AbstractLabelRidgetTest.assertEquals((String)"NewLabel", (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)"NewLabel", (String)this.getText(widget));
    }

    public void testUpdateFromRidget() {
        ILabelRidget ridget = this.getRidget();
        Object widget = ridget.getUIControl();
        TestBean bean = new TestBean();
        bean.setProperty((Object)"NewLabel");
        ridget.bindToModel((Object)bean, "property");
        ridget.updateFromModel();
        AbstractLabelRidgetTest.assertEquals((Object)"NewLabel", (Object)bean.getProperty());
        AbstractLabelRidgetTest.assertEquals((String)"NewLabel", (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)"NewLabel", (String)this.getText(widget));
        ridget.setText(LABEL);
        AbstractLabelRidgetTest.assertEquals((Object)LABEL, (Object)bean.getProperty());
        AbstractLabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)LABEL, (String)this.getText(widget));
    }

    public void testUpdateFromControl() {
        ILabelRidget ridget = this.getRidget();
        Object widget = ridget.getUIControl();
        TestBean bean = new TestBean();
        bean.setProperty((Object)"NewLabel");
        ridget.bindToModel((Object)bean, "property");
        ridget.updateFromModel();
        AbstractLabelRidgetTest.assertEquals((Object)"NewLabel", (Object)bean.getProperty());
        AbstractLabelRidgetTest.assertEquals((String)"NewLabel", (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)"NewLabel", (String)this.getText(widget));
        this.setText(widget, LABEL);
        AbstractLabelRidgetTest.assertEquals((Object)"NewLabel", (Object)bean.getProperty());
        AbstractLabelRidgetTest.assertEquals((String)"NewLabel", (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)LABEL, (String)this.getText(widget));
    }

    public void testUpdateFromRidgetOnRebind() throws Exception {
        ILabelRidget ridget = this.getRidget();
        Object widget = ridget.getUIControl();
        TestBean bean = new TestBean();
        bean.setProperty((Object)"NewLabel");
        ridget.bindToModel((Object)bean, "property");
        ridget.updateFromModel();
        AbstractLabelRidgetTest.assertEquals((String)"NewLabel", (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)"NewLabel", (String)this.getText(widget));
        ridget.setUIControl(null);
        AbstractLabelRidgetTest.assertEquals((String)"NewLabel", (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)"NewLabel", (String)this.getText(widget));
        ridget.setText(LABEL);
        AbstractLabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)"NewLabel", (String)this.getText(widget));
        widget = this.createWidget((Composite)this.getShell());
        ridget.setUIControl(widget);
        AbstractLabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)LABEL, (String)this.getText(widget));
    }

    public void testDontReadValueInConstructor() throws Exception {
        ILabelRidget ridget = this.getRidget();
        AbstractObservableValue observableValue = new AbstractObservableValue(){

            protected Object doGetValue() {
                return "TestText";
            }

            public Object getValueType() {
                return String.class;
            }
        };
        ridget.bindToModel((IObservableValue)observableValue);
        AbstractLabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        ridget.updateFromModel();
        AbstractLabelRidgetTest.assertEquals((String)"TestText", (String)ridget.getText());
    }

    public void testSetIconLocation() throws Exception {
        ILabelRidget ridget = this.getRidget();
        Object widget = ridget.getUIControl();
        AbstractLabelRidgetTest.assertNull((Object)ridget.getIconLocation());
        AbstractLabelRidgetTest.assertNull((Object)this.getImage(widget));
        URL url = new URL("http://www.compeople.de/assets/compeople-logo.gif");
        ridget.setIconLocation(url);
        AbstractLabelRidgetTest.assertEquals((Object)url, (Object)ridget.getIconLocation());
        AbstractLabelRidgetTest.assertNotNull((Object)this.getImage(widget));
        ridget.setIconLocation(null);
        AbstractLabelRidgetTest.assertNull((Object)ridget.getIconLocation());
        AbstractLabelRidgetTest.assertNull((Object)this.getImage(widget));
    }

    public void testSetUIControl() throws Exception {
        ILabelRidget ridget = this.getRidget();
        AbstractLabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)LABEL, (String)this.getText(this.getWidget()));
        ridget.setUIControl(null);
        AbstractLabelRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)LABEL, (String)this.getText(this.getWidget()));
        ridget.setText(LABEL2);
        ridget.setUIControl((Object)this.getWidget());
        AbstractLabelRidgetTest.assertEquals((String)LABEL2, (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)LABEL2, (String)this.getText(this.getWidget()));
    }

    public void testInitText() {
        ILabelRidget ridget = this.getRidget();
        Object widget = ridget.getUIControl();
        ReflectionUtils.setHidden((Object)ridget, (String)"textAlreadyInitialized", (Object)false);
        ReflectionUtils.setHidden((Object)ridget, (String)"text", null);
        this.setText(widget, "Hello!");
        ReflectionUtils.invokeHidden((Object)ridget, (String)"initText", (Object[])new Object[0]);
        AbstractLabelRidgetTest.assertEquals((String)"Hello!", (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)"Hello!", (String)this.getText(widget));
        AbstractLabelRidgetTest.assertTrue((boolean)((Boolean)ReflectionUtils.getHidden((Object)ridget, (String)"textAlreadyInitialized")));
        this.setText(widget, "World");
        ReflectionUtils.invokeHidden((Object)ridget, (String)"initText", (Object[])new Object[0]);
        AbstractLabelRidgetTest.assertEquals((String)"Hello!", (String)ridget.getText());
        AbstractLabelRidgetTest.assertEquals((String)"World", (String)this.getText(widget));
    }

    public void testHasChanged() throws MalformedURLException {
        ILabelRidget ridget = this.getRidget();
        URL url1 = new URL("file:/a");
        URL url2 = new URL("file:/b");
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)ridget, (String)"hasChanged", (Object[])new Object[]{url1, url2});
        AbstractLabelRidgetTest.assertTrue((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)ridget, (String)"hasChanged", (Object[])new Object[]{url1, url1});
        AbstractLabelRidgetTest.assertFalse((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)ridget, (String)"hasChanged", (Object[])new Object[]{url1, null});
        AbstractLabelRidgetTest.assertTrue((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)ridget, (String)"hasChanged", (Object[])new Object[]{null, url2});
        AbstractLabelRidgetTest.assertTrue((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)ridget, (String)"hasChanged", (Object[])new Object[]{null, null});
        AbstractLabelRidgetTest.assertFalse((boolean)ret);
    }

    public void testUnsupportedMarkersIgnored() {
        this.assertMarkerIgnored((IMarker)new ErrorMarker());
        this.assertMarkerIgnored((IMarker)new MandatoryMarker());
        this.assertMarkerIgnored((IMarker)new OutputMarker());
        this.assertMarkerIgnored((IMarker)new NegativeMarker());
    }
}

