/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import org.easymock.EasyMock;
import org.eclipse.riena.beans.common.TypedBean;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.FTActionListener;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.ITraverseRidget;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTraverseRidgetTest
extends AbstractSWTRidgetTest {
    protected ITraverseRidget getRidget() {
        return (ITraverseRidget)super.getRidget();
    }

    protected Control getWidget() {
        return (Control)super.getWidget();
    }

    protected abstract int getValue(Control var1);

    protected abstract int getIncrement(Control var1);

    protected abstract int getPageIncrement(Control var1);

    protected abstract int getMinimum(Control var1);

    protected abstract int getMaximum(Control var1);

    protected abstract void setValue(Control var1, int var2);

    public void testSetup() {
        ITraverseRidget ridget = this.getRidget();
        Control control = this.getWidget();
        this.assertPropertiesEqual(ridget, control);
    }

    protected void assertPropertiesEqual(ITraverseRidget ridget, Control control) {
        AbstractTraverseRidgetTest.assertEquals((int)this.getValue(control), (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)this.getIncrement(control), (int)ridget.getIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)this.getMaximum(control), (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)this.getMinimum(control), (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)this.getPageIncrement(control), (int)ridget.getPageIncrement());
    }

    public void testSetValue() {
        ITraverseRidget ridget = this.getRidget();
        Control control = this.getWidget();
        ridget.setMaximum(30);
        ridget.setMinimum(0);
        ridget.setValue(10);
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)this.getValue(control));
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)this.getMaximum(control));
        AbstractTraverseRidgetTest.assertEquals((int)0, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)0, (int)this.getMinimum(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMaximum(30);
        ridget.setMinimum(10);
        ridget.setValue(-1);
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)this.getValue(control));
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)this.getMaximum(control));
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)this.getMinimum(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMaximum(30);
        ridget.setMinimum(10);
        ridget.setValue(1);
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)this.getValue(control));
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)this.getMaximum(control));
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)this.getMinimum(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMaximum(29);
        ridget.setMinimum(11);
        ridget.setValue(10);
        AbstractTraverseRidgetTest.assertEquals((int)11, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)11, (int)this.getValue(control));
        AbstractTraverseRidgetTest.assertEquals((int)29, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)29, (int)this.getMaximum(control));
        AbstractTraverseRidgetTest.assertEquals((int)11, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)11, (int)this.getMinimum(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMinimum(11);
        AbstractTraverseRidgetTest.assertEquals((int)11, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)11, (int)this.getValue(control));
        AbstractTraverseRidgetTest.assertEquals((int)29, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)29, (int)this.getMaximum(control));
        AbstractTraverseRidgetTest.assertEquals((int)11, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)11, (int)this.getMinimum(control));
        this.assertPropertiesEqual(ridget, control);
    }

    public void testSetValueRidgetBased() {
        Control control = this.getWidget();
        ITraverseRidget ridget = this.getRidget();
        ridget.setMaximum(30);
        ridget.setMinimum(10);
        ridget.setValue(40);
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)this.getValue(control));
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)this.getMaximum(control));
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)this.getMinimum(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setValue(20);
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)this.getValue(control));
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)this.getMaximum(control));
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)this.getMinimum(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMaximum(29);
        ridget.setValue(29);
        AbstractTraverseRidgetTest.assertEquals((int)29, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)29, (int)this.getValue(control));
        AbstractTraverseRidgetTest.assertEquals((int)29, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)29, (int)this.getMaximum(control));
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)this.getMinimum(control));
        this.assertPropertiesEqual(ridget, control);
    }

    public void testSetValueFiresEvents() {
        ITraverseRidget ridget = this.getRidget();
        ridget.setMaximum(20);
        ridget.setValue(0);
        this.expectPropertyChangeEvent("value", 0, 10);
        ridget.setValue(10);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setValue(10);
        this.verifyPropertyChangeEvents();
    }

    public void testSetValueFiresEventsRidgetBased() {
        ITraverseRidget ridget = this.getRidget();
        ridget.setMaximum(20);
        ridget.setValue(0);
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)0, (int)ridget.getValue());
        this.expectPropertyChangeEvent("value", 0, 20);
        ridget.setValue(30);
        this.verifyPropertyChangeEvents();
        this.resetEasyMock();
        ridget.setMinimum(10);
        this.expectPropertyChangeEvent("value", 20, 10);
        ridget.setValue(1);
        this.verifyPropertyChangeEvents();
    }

    public void testSetIncrement() {
        ITraverseRidget ridget = this.getRidget();
        Control control = this.getWidget();
        ridget.setMinimum(0);
        ridget.setMaximum(100);
        ridget.setIncrement(2);
        AbstractTraverseRidgetTest.assertEquals((int)2, (int)ridget.getIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)2, (int)this.getIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setIncrement(-1);
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)ridget.getIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)this.getIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setIncrement(0);
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)ridget.getIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)this.getIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMaximum(20);
        ridget.setMinimum(0);
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)0, (int)ridget.getMinimum());
        ridget.setIncrement(10);
        ridget.setPageIncrement(5);
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)this.getIncrement(control));
        AbstractTraverseRidgetTest.assertEquals((int)5, (int)ridget.getPageIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)5, (int)this.getPageIncrement(control));
        this.assertPropertiesEqual(ridget, control);
    }

    public void testSetIncrementRidgetBased() {
        ITraverseRidget ridget = this.getRidget();
        Control control = this.getWidget();
        int deltaMaxMin = 3;
        ridget.setMinimum(7);
        ridget.setMaximum(10);
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)7, (int)ridget.getMinimum());
        ridget.setIncrement(deltaMaxMin + 3);
        AbstractTraverseRidgetTest.assertEquals((int)deltaMaxMin, (int)ridget.getIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)deltaMaxMin, (int)this.getIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setIncrement(deltaMaxMin);
        AbstractTraverseRidgetTest.assertEquals((int)deltaMaxMin, (int)ridget.getIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)deltaMaxMin, (int)this.getIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setIncrement(deltaMaxMin - 1);
        AbstractTraverseRidgetTest.assertEquals((int)(deltaMaxMin - 1), (int)ridget.getIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)(deltaMaxMin - 1), (int)this.getIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMaximum(20);
        ridget.setMinimum(0);
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)0, (int)ridget.getMinimum());
        ridget.setIncrement(20);
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)this.getIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMaximum(10);
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)this.getIncrement(control));
        this.assertPropertiesEqual(ridget, control);
    }

    public void testSetIncrementFiresEvents() {
        ITraverseRidget ridget = this.getRidget();
        ridget.setIncrement(1);
        this.expectPropertyChangeEvent("increment", 1, 2);
        ridget.setIncrement(2);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setIncrement(2);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("increment", 2, 1);
        ridget.setIncrement(-1);
        this.verifyPropertyChangeEvents();
    }

    public void testSetIncrementFiresEventsRidgetBased() {
        ITraverseRidget ridget = this.getRidget();
        ridget.setIncrement(1);
        this.resetEasyMock();
        ridget.setMaximum(20);
        ridget.setMinimum(10);
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        int deltaMaxMin = 10;
        this.expectPropertyChangeEvent("increment", 1, deltaMaxMin);
        ridget.setIncrement(20);
        this.verifyPropertyChangeEvents();
    }

    public void testSetMaximumRidgetBased() {
        Control control = this.getWidget();
        ITraverseRidget ridget = this.getRidget();
        ridget.setMaximum(40);
        ridget.setMinimum(5);
        ridget.setValue(21);
        this.assertPropertiesEqual(ridget, control);
        AbstractTraverseRidgetTest.assertEquals((int)40, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)40, (int)this.getMaximum(control));
        AbstractTraverseRidgetTest.assertEquals((int)21, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)21, (int)this.getValue(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMaximum(20);
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)this.getMaximum(control));
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)this.getValue(control));
        this.assertPropertiesEqual(ridget, control);
        try {
            ridget.setMaximum(4);
            AbstractTraverseRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMaximum());
        this.assertPropertiesEqual(ridget, control);
        try {
            ridget.setMaximum(5);
            AbstractTraverseRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMaximum());
        this.assertPropertiesEqual(ridget, control);
        try {
            ridget.setMaximum(-1);
            AbstractTraverseRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMaximum());
        this.assertPropertiesEqual(ridget, control);
        ridget.setMinimum(0);
        ridget.setMaximum(1);
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)this.getMaximum(control));
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)this.getValue(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMinimum(0);
        int maxIncrement = 19;
        ridget.setMaximum(20);
        ridget.setMinimum(1);
        ridget.setIncrement(20);
        AbstractTraverseRidgetTest.assertEquals((int)maxIncrement, (int)ridget.getIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)maxIncrement, (int)this.getIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        maxIncrement = 9;
        ridget.setMaximum(10);
        AbstractTraverseRidgetTest.assertEquals((int)maxIncrement, (int)ridget.getIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)maxIncrement, (int)this.getIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        int maxPageIncrement = 19;
        ridget.setMaximum(20);
        ridget.setMinimum(1);
        ridget.setPageIncrement(20);
        AbstractTraverseRidgetTest.assertEquals((int)maxPageIncrement, (int)ridget.getPageIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)maxPageIncrement, (int)this.getPageIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        maxPageIncrement = 9;
        ridget.setMaximum(10);
        AbstractTraverseRidgetTest.assertEquals((int)maxPageIncrement, (int)ridget.getPageIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)maxPageIncrement, (int)this.getPageIncrement(control));
        this.assertPropertiesEqual(ridget, control);
    }

    public void testSetMaximumFiresEvents() {
        int max = 30;
        int min = 5;
        ITraverseRidget ridget = this.getRidget();
        ridget.setMaximum(max);
        ridget.setMinimum(min);
        ridget.setIncrement(1);
        ridget.setPageIncrement(1);
        AbstractTraverseRidgetTest.assertEquals((int)max, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)min, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)ridget.getPageIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)ridget.getIncrement());
        this.expectPropertyChangeEvent("maximum", max, 50);
        ridget.setMaximum(50);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        max = 50;
        ridget.setMaximum(max);
        this.verifyPropertyChangeEvents();
        try {
            this.expectNoPropertyChangeEvent();
            ridget.setMaximum(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.verifyPropertyChangeEvents();
        }
        try {
            this.expectNoPropertyChangeEvent();
            ridget.setMaximum(ridget.getMinimum() - 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.verifyPropertyChangeEvents();
        }
        try {
            this.resetEasyMock();
            ridget.setMinimum(0);
            this.expectNoPropertyChangeEvent();
            ridget.setMaximum(-1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.verifyPropertyChangeEvents();
        }
    }

    public void testSetMaximumFiresEventsRidgetBased() {
        ITraverseRidget ridget = this.getRidget();
        this.resetEasyMock();
        int max = 20;
        int min = 10;
        ridget.setMaximum(max);
        ridget.setMinimum(min);
        AbstractTraverseRidgetTest.assertEquals((int)max, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)min, (int)ridget.getMinimum());
        int deltaMaxMin = max - min;
        ridget.setIncrement(deltaMaxMin);
        ridget.setPageIncrement(deltaMaxMin);
        int oldPageIncrement = ridget.getPageIncrement();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "increment", deltaMaxMin, deltaMaxMin - 1), new PropertyChangeEvent(ridget, "pageIncrement", oldPageIncrement, deltaMaxMin - 1), new PropertyChangeEvent(ridget, "maximum", max, max - 1));
        ridget.setMaximum(max - 1);
        this.verifyPropertyChangeEvents();
        int newMax = 30;
        this.resetEasyMock();
        ridget.setMaximum(50);
        ridget.setValue(40);
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "value", 40, newMax), new PropertyChangeEvent(ridget, "maximum", 50, newMax));
        ridget.setMaximum(newMax);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setMaximum(newMax);
        this.verifyPropertyChangeEvents();
    }

    protected void resetEasyMock() {
        EasyMock.reset((Object[])new Object[]{this.propertyChangeListenerMock});
    }

    public void testSetMinimum() {
        ITraverseRidget ridget = this.getRidget();
        Control control = this.getWidget();
        ridget.setMaximum(50);
        ridget.setMinimum(0);
        ridget.setValue(5);
        AbstractTraverseRidgetTest.assertEquals((int)0, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)0, (int)this.getMinimum(control));
        AbstractTraverseRidgetTest.assertEquals((int)5, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)5, (int)this.getValue(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMinimum(20);
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)this.getMinimum(control));
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)this.getValue(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMinimum(20);
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)this.getMinimum(control));
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)this.getValue(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMinimum(10);
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)this.getMinimum(control));
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)this.getValue(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMinimum(20);
        try {
            ridget.setMinimum(100);
            AbstractTraverseRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMinimum());
        this.assertPropertiesEqual(ridget, control);
        try {
            ridget.setMinimum(50);
            AbstractTraverseRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMinimum());
        this.assertPropertiesEqual(ridget, control);
        try {
            ridget.setMinimum(-10);
            AbstractTraverseRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMinimum());
        this.assertPropertiesEqual(ridget, control);
    }

    public void testSetMinimumFiresEvents() {
        ITraverseRidget ridget = this.getRidget();
        ridget.setMaximum(30);
        ridget.setMinimum(0);
        ridget.setValue(10);
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "minimum", 0, 5));
        ridget.setMinimum(5);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setMinimum(5);
        this.verifyPropertyChangeEvents();
        this.resetEasyMock();
        ridget.setMinimum(0);
        ridget.setValue(0);
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "value", 0, 5), new PropertyChangeEvent(ridget, "minimum", 0, 5));
        ridget.setMinimum(5);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setMinimum(5);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "minimum", 5, 0));
        ridget.setMinimum(0);
        this.verifyPropertyChangeEvents();
        try {
            this.resetEasyMock();
            this.expectNoPropertyChangeEvent();
            ridget.setMinimum(-1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.verifyPropertyChangeEvents();
        }
    }

    public void testSetMinimumFiresEventsRidgetBased() {
        ITraverseRidget ridget = this.getRidget();
        int max = 20;
        int min = 10;
        this.resetEasyMock();
        ridget.setMaximum(max);
        ridget.setMinimum(min);
        ridget.setValue(min);
        AbstractTraverseRidgetTest.assertEquals((int)max, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)min, (int)ridget.getMinimum());
        AbstractTraverseRidgetTest.assertEquals((int)min, (int)ridget.getValue());
        int deltaMaxMin = max - min;
        int newMin = min + 1;
        ridget.setIncrement(deltaMaxMin);
        ridget.setPageIncrement(deltaMaxMin);
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "value", min, newMin), new PropertyChangeEvent(ridget, "increment", deltaMaxMin, deltaMaxMin - 1), new PropertyChangeEvent(ridget, "pageIncrement", deltaMaxMin, deltaMaxMin - 1), new PropertyChangeEvent(ridget, "minimum", min, min + 1));
        ridget.setMinimum(newMin);
        this.verifyPropertyChangeEvents();
    }

    public void testSetPageIncrement() {
        ITraverseRidget ridget = (ITraverseRidget)this.createRidget();
        Control control = this.getWidget();
        ridget.setUIControl((Object)control);
        ridget.setMinimum(1);
        ridget.setMaximum(100);
        ridget.setPageIncrement(5);
        AbstractTraverseRidgetTest.assertEquals((int)5, (int)ridget.getPageIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)5, (int)this.getPageIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setPageIncrement(0);
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)ridget.getPageIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)this.getPageIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setPageIncrement(-1);
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)ridget.getPageIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)this.getPageIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMaximum(100);
        ridget.setMinimum(1);
        ridget.setIncrement(9);
        ridget.setPageIncrement(5);
        AbstractTraverseRidgetTest.assertEquals((int)9, (int)ridget.getIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)9, (int)this.getIncrement(control));
        AbstractTraverseRidgetTest.assertEquals((int)5, (int)ridget.getPageIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)5, (int)this.getPageIncrement(control));
        this.assertPropertiesEqual(ridget, control);
    }

    public void testSetPageIncrementRidgetBased() {
        ITraverseRidget ridget = this.getRidget();
        Control control = this.getWidget();
        int deltaMaxMin = 3;
        ridget.setMinimum(7);
        ridget.setMaximum(10);
        ridget.setPageIncrement(deltaMaxMin + 3);
        AbstractTraverseRidgetTest.assertEquals((int)deltaMaxMin, (int)ridget.getPageIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)deltaMaxMin, (int)this.getPageIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setPageIncrement(deltaMaxMin);
        AbstractTraverseRidgetTest.assertEquals((int)deltaMaxMin, (int)ridget.getPageIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)deltaMaxMin, (int)this.getPageIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setPageIncrement(deltaMaxMin - 1);
        AbstractTraverseRidgetTest.assertEquals((int)(deltaMaxMin - 1), (int)ridget.getPageIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)(deltaMaxMin - 1), (int)this.getPageIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMaximum(20);
        ridget.setMinimum(0);
        ridget.setPageIncrement(20);
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getPageIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)this.getPageIncrement(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setMaximum(10);
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getPageIncrement());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)this.getPageIncrement(control));
        this.assertPropertiesEqual(ridget, control);
    }

    public void testSetPageIncrementFiresEvents() {
        ITraverseRidget ridget = this.getRidget();
        ridget.setPageIncrement(1);
        this.expectPropertyChangeEvent("pageIncrement", 1, 2);
        ridget.setPageIncrement(2);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setPageIncrement(2);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("pageIncrement", 2, 1);
        ridget.setPageIncrement(-1);
        this.verifyPropertyChangeEvents();
    }

    public void testSetPageIncrementFiresEventsRidgetBased() {
        ITraverseRidget ridget = this.getRidget();
        ridget.setPageIncrement(1);
        this.resetEasyMock();
        ridget.setMaximum(20);
        ridget.setMinimum(10);
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getMaximum());
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        int deltaMaxMin = 10;
        this.expectPropertyChangeEvent("pageIncrement", 1, deltaMaxMin);
        ridget.setPageIncrement(20);
        this.verifyPropertyChangeEvents();
    }

    public void testSetToolTip() {
        ITraverseRidget ridget = this.getRidget();
        Control control = this.getWidget();
        ridget.setMinimum(0);
        ridget.setMaximum(100);
        ridget.setValue(5);
        ridget.setToolTipText("tooltip");
        AbstractTraverseRidgetTest.assertEquals((String)"tooltip", (String)ridget.getToolTipText());
        AbstractTraverseRidgetTest.assertEquals((String)"tooltip", (String)control.getToolTipText());
        String pat1 = "my value is: [VALUE]";
        ridget.setToolTipText(pat1);
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 5", (String)ridget.getToolTipText());
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 5", (String)control.getToolTipText());
        ridget.setValue(6);
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 6", (String)ridget.getToolTipText());
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 6", (String)control.getToolTipText());
        ridget.setToolTipText("my value is: 6");
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 6", (String)ridget.getToolTipText());
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 6", (String)control.getToolTipText());
        ridget.setValue(7);
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 7", (String)ridget.getToolTipText());
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 7", (String)control.getToolTipText());
        ridget.setToolTipText("my value is: 9");
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 9", (String)ridget.getToolTipText());
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 9", (String)control.getToolTipText());
        ridget.setValue(1);
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 9", (String)control.getToolTipText());
        ridget.setToolTipText("");
        AbstractTraverseRidgetTest.assertEquals((String)"", (String)ridget.getToolTipText());
        AbstractTraverseRidgetTest.assertEquals((String)"", (String)control.getToolTipText());
        ridget.setToolTipText("abc");
        ridget.setToolTipText(null);
        AbstractTraverseRidgetTest.assertEquals(null, (String)ridget.getToolTipText());
        AbstractTraverseRidgetTest.assertEquals(null, (String)control.getToolTipText());
        this.setValue(control, 5);
        UITestHelper.fireSelectionEvent((Widget)control);
        pat1 = "my value is: [VALUE]";
        ridget.setToolTipText(pat1);
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 5", (String)ridget.getToolTipText());
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 5", (String)control.getToolTipText());
        this.setValue(control, 6);
        UITestHelper.fireSelectionEvent((Widget)control);
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 6", (String)ridget.getToolTipText());
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 6", (String)control.getToolTipText());
        ridget.setToolTipText("my value is: 6");
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 6", (String)ridget.getToolTipText());
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 6", (String)control.getToolTipText());
        this.setValue(control, 7);
        UITestHelper.fireSelectionEvent((Widget)control);
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 7", (String)ridget.getToolTipText());
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 7", (String)control.getToolTipText());
        ridget.setToolTipText("my value is: 9");
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 9", (String)ridget.getToolTipText());
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 9", (String)control.getToolTipText());
        this.setValue(control, 1);
        UITestHelper.fireSelectionEvent((Widget)control);
        AbstractTraverseRidgetTest.assertEquals((String)"my value is: 9", (String)control.getToolTipText());
    }

    public void testApplySettingsOnBind() {
        ITraverseRidget ridget = this.getRidget();
        ridget.setMaximum(30);
        ridget.setMinimum(10);
        ridget.setValue(15);
        ridget.setIncrement(2);
        ridget.setPageIncrement(4);
        ridget.setToolTipText("aaa");
        Control control = (Control)this.createWidget((Composite)this.getShell());
        AbstractTraverseRidgetTest.assertNotSame((Object)control, (Object)this.getWidget());
        ridget.setUIControl((Object)control);
        AbstractTraverseRidgetTest.assertEquals((int)10, (int)this.getMinimum(control));
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)this.getMaximum(control));
        AbstractTraverseRidgetTest.assertEquals((int)15, (int)this.getValue(control));
        AbstractTraverseRidgetTest.assertEquals((int)2, (int)this.getIncrement(control));
        AbstractTraverseRidgetTest.assertEquals((int)4, (int)this.getPageIncrement(control));
        AbstractTraverseRidgetTest.assertEquals((String)"aaa", (String)control.getToolTipText());
    }

    public void testBind() {
        ITraverseRidget ridget = this.getRidget();
        Control control = this.getWidget();
        ridget.setMinimum(0);
        ridget.setValue(0);
        ridget.setMaximum(100);
        TypedBean bean = new TypedBean((Object)20);
        ridget.bindToModel((Object)bean, "value");
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)((Integer)bean.getValue()));
        AbstractTraverseRidgetTest.assertEquals((int)0, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)0, (int)this.getValue(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.updateFromModel();
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)((Integer)bean.getValue()));
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)20, (int)this.getValue(control));
        this.assertPropertiesEqual(ridget, control);
        ridget.setValue(30);
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)((Integer)bean.getValue()));
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)30, (int)this.getValue(control));
        this.assertPropertiesEqual(ridget, control);
        this.setValue(control, 40);
        UITestHelper.fireSelectionEvent((Widget)control);
        AbstractTraverseRidgetTest.assertEquals((int)40, (int)((Integer)bean.getValue()));
        AbstractTraverseRidgetTest.assertEquals((int)40, (int)ridget.getValue());
        AbstractTraverseRidgetTest.assertEquals((int)40, (int)this.getValue(control));
        this.assertPropertiesEqual(ridget, control);
    }

    public void testAddListenerInvalid() {
        try {
            this.getRidget().addListener(null);
            AbstractTraverseRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testAddListener() {
        ITraverseRidget ridget = this.getRidget();
        Control control = this.getWidget();
        FTActionListener listener1 = new FTActionListener();
        FTActionListener listener2 = new FTActionListener();
        ridget.addListener((IActionListener)listener1);
        ridget.addListener((IActionListener)listener2);
        ridget.addListener((IActionListener)listener2);
        UITestHelper.fireSelectionEvent((Widget)control);
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ridget.removeListener((IActionListener)listener1);
        UITestHelper.fireSelectionEvent((Widget)control);
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        AbstractTraverseRidgetTest.assertEquals((int)2, (int)listener2.getCount());
        ridget.removeListener((IActionListener)listener2);
        UITestHelper.fireSelectionEvent((Widget)control);
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        AbstractTraverseRidgetTest.assertEquals((int)2, (int)listener2.getCount());
        ridget.removeListener((IActionListener)listener2);
        UITestHelper.fireSelectionEvent((Widget)control);
        AbstractTraverseRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        AbstractTraverseRidgetTest.assertEquals((int)2, (int)listener2.getCount());
    }
}

