/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.BrowserRidget;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.IBrowserRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class BrowserRidgetTest
extends AbstractSWTRidgetTest {
    protected Browser createWidget(Composite parent) {
        return new Browser(parent, 0);
    }

    protected IBrowserRidget createRidget() {
        return new BrowserRidget();
    }

    protected Browser getWidget() {
        return (Browser)super.getWidget();
    }

    protected IBrowserRidget getRidget() {
        return (IBrowserRidget)super.getRidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        BrowserRidgetTest.assertSame(BrowserRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testSetFocusable() {
        this.ok();
    }

    public void testRequestFocus() {
        this.ok();
    }

    public void testBindToModel() {
        IBrowserRidget ridget = this.getRidget();
        String url1 = "http://www.redview.org";
        String url2 = "http://www.eclipse.org";
        StringBean bean = new StringBean(url1);
        ridget.bindToModel((Object)bean, "value");
        BrowserRidgetTest.assertNull((Object)ridget.getUrl());
        ridget.updateFromModel();
        BrowserRidgetTest.assertEquals((String)url1, (String)bean.getValue());
        BrowserRidgetTest.assertEquals((String)url1, (String)ridget.getUrl());
        bean.setValue(url2);
        BrowserRidgetTest.assertEquals((String)url2, (String)bean.getValue());
        BrowserRidgetTest.assertEquals((String)url1, (String)ridget.getUrl());
        ridget.updateFromModel();
        BrowserRidgetTest.assertEquals((String)url2, (String)bean.getValue());
        BrowserRidgetTest.assertEquals((String)url2, (String)ridget.getUrl());
        ridget.setUrl(url1);
        BrowserRidgetTest.assertEquals((String)url1, (String)bean.getValue());
        BrowserRidgetTest.assertEquals((String)url1, (String)ridget.getUrl());
    }

    public void testSetText() {
        IBrowserRidget ridget = this.getRidget();
        ridget.setText("<html><body><h1>Riena</h1></body></html>");
        BrowserRidgetTest.assertEquals((String)"<html><body><h1>Riena</h1></body></html>", (String)ridget.getText());
        ridget.setText("");
        BrowserRidgetTest.assertEquals((String)"", (String)ridget.getText());
        ridget.setText(null);
        BrowserRidgetTest.assertEquals(null, (String)ridget.getText());
    }

    public void testSetTextClearsUrl() {
        IBrowserRidget ridget = this.getRidget();
        ridget.setUrl("http://eclipse.org");
        ridget.setText("<html><body><p>riena</p></body></html>");
        BrowserRidgetTest.assertEquals(null, (String)ridget.getUrl());
        BrowserRidgetTest.assertEquals((String)"<html><body><p>riena</p></body></html>", (String)ridget.getText());
    }

    public void testSetTextOnOutputOnly() {
        IBrowserRidget ridget = this.getRidget();
        Browser control = this.getWidget();
        BrowserRidgetTest.assertNull((Object)ridget.getText());
        ridget.setOutputOnly(true);
        ridget.setText("<hmtl><body><h2>Riena</h2></body></html>");
        UITestHelper.readAndDispatch((Widget)control);
        BrowserRidgetTest.assertEquals((String)"<hmtl><body><h2>Riena</h2></body></html>", (String)ridget.getText());
        BrowserRidgetTest.assertTrue((String)("control.text:" + control.getText()), (boolean)control.getText().contains("Riena"));
    }

    public void testSetUrl() {
        IBrowserRidget ridget = this.getRidget();
        ridget.setUrl("http://www.redview.org");
        BrowserRidgetTest.assertEquals((String)"http://www.redview.org", (String)ridget.getUrl());
        ridget.setUrl("b o g u s");
        BrowserRidgetTest.assertEquals((String)"b o g u s", (String)ridget.getUrl());
        ridget.setUrl("");
        BrowserRidgetTest.assertEquals((String)"", (String)ridget.getUrl());
        ridget.setUrl(null);
        BrowserRidgetTest.assertEquals(null, (String)ridget.getUrl());
        ridget.setUrl("about:blank");
        BrowserRidgetTest.assertEquals((String)"about:blank", (String)ridget.getUrl());
    }

    public void testSetUrlClearsText() {
        IBrowserRidget ridget = this.getRidget();
        ridget.setText("riena");
        ridget.setUrl("http://eclipse.org");
        BrowserRidgetTest.assertEquals((String)"http://eclipse.org", (String)ridget.getUrl());
        BrowserRidgetTest.assertEquals(null, (String)ridget.getText());
    }

    public void testSetUrlOnOutputOnly() {
        IBrowserRidget ridget = this.getRidget();
        BrowserRidgetTest.assertNull((Object)ridget.getUrl());
        ridget.setOutputOnly(true);
        ridget.setUrl("http://www.redview.org");
        BrowserRidgetTest.assertEquals((String)"http://www.redview.org", (String)ridget.getUrl());
    }

    public void testSettersFireUrlEvents() {
        IBrowserRidget ridget = this.getRidget();
        String oldValue = ridget.getUrl();
        BrowserRidgetTest.assertFalse((boolean)"http://www.redview.org".equals(ridget.getUrl()));
        this.expectPropertyChangeEvent("url", oldValue, "http://www.redview.org");
        ridget.setUrl("http://www.redview.org");
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setUrl("http://www.redview.org");
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("url", "http://www.redview.org", null);
        ridget.setText("<html><body><h1>h1</h1></body></html>");
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setText("<html><body><h1>h1</h1></body></html>");
        this.verifyPropertyChangeEvents();
    }

    public void testApplyTextOnRebind() {
        IBrowserRidget ridget = this.getRidget();
        Browser control1 = this.getWidget();
        ridget.setText("<html><body><h1>Riena</h1></body></html>");
        UITestHelper.readAndDispatch((Widget)control1);
        BrowserRidgetTest.assertTrue((String)("control1.text:" + control1.getText()), (boolean)control1.getText().contains("Riena"));
        Browser control2 = this.createWidget((Composite)this.getShell());
        ridget.setUIControl((Object)control2);
        UITestHelper.readAndDispatch((Widget)control2);
        BrowserRidgetTest.assertTrue((String)("control2.text:" + control2.getText()), (boolean)control2.getText().contains("Riena"));
    }
}

