/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTraverseRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.SliderRidget;
import org.eclipse.riena.ui.ridgets.ISliderRidget;
import org.eclipse.riena.ui.ridgets.ITraverseRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Widget;

public class SliderRidgetTest
extends AbstractTraverseRidgetTest {
    protected Widget createWidget(Composite parent) {
        return new Slider(parent, 0);
    }

    protected ISliderRidget createRidget() {
        return new SliderRidget();
    }

    protected Slider getWidget() {
        return (Slider)super.getWidget();
    }

    protected ISliderRidget getRidget() {
        return (ISliderRidget)super.getRidget();
    }

    protected int getIncrement(Control control) {
        return ((Slider)control).getIncrement();
    }

    protected int getMaximum(Control control) {
        return ((Slider)control).getMaximum();
    }

    protected int getMinimum(Control control) {
        return ((Slider)control).getMinimum();
    }

    protected int getPageIncrement(Control control) {
        return ((Slider)control).getPageIncrement();
    }

    protected int getValue(Control control) {
        return ((Slider)control).getSelection();
    }

    protected int getThumb(Control control) {
        return ((Slider)control).getThumb();
    }

    protected void setValue(Control control, int value) {
        ((Slider)control).setSelection(value);
    }

    protected void assertPropertiesEqual(ITraverseRidget ridget, Control control) {
        super.assertPropertiesEqual(ridget, control);
        SliderRidgetTest.assertEquals((int)this.getThumb(control), (int)((ISliderRidget)ridget).getThumb());
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        SliderRidgetTest.assertSame(SliderRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testSetValueRidgetBased() {
        Slider control = this.getWidget();
        ISliderRidget ridget = this.getRidget();
        ridget.setMaximum(30);
        ridget.setMinimum(10);
        ridget.setThumb(1);
        ridget.setValue(40);
        SliderRidgetTest.assertEquals((int)29, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)29, (int)this.getValue((Control)control));
        SliderRidgetTest.assertEquals((int)30, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)30, (int)this.getMaximum((Control)control));
        SliderRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        SliderRidgetTest.assertEquals((int)10, (int)this.getMinimum((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setValue(20);
        SliderRidgetTest.assertEquals((int)20, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)20, (int)this.getValue((Control)control));
        SliderRidgetTest.assertEquals((int)30, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)30, (int)this.getMaximum((Control)control));
        SliderRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        SliderRidgetTest.assertEquals((int)10, (int)this.getMinimum((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setValue(30);
        SliderRidgetTest.assertEquals((int)29, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)29, (int)this.getValue((Control)control));
        SliderRidgetTest.assertEquals((int)30, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)30, (int)this.getMaximum((Control)control));
        SliderRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        SliderRidgetTest.assertEquals((int)10, (int)this.getMinimum((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
    }

    public void testSetValueFiresEventsRidgetBased() {
        ISliderRidget ridget = this.getRidget();
        ridget.setMaximum(30);
        ridget.setValue(0);
        int maxValue = ridget.getMaximum() - ridget.getThumb();
        this.expectPropertyChangeEvent("value", 0, maxValue);
        ridget.setValue(30);
        this.verifyPropertyChangeEvents();
        this.resetEasyMock();
        ridget.setMinimum(10);
        this.expectPropertyChangeEvent("value", maxValue, 10);
        ridget.setValue(1);
        this.verifyPropertyChangeEvents();
        this.resetEasyMock();
        ridget.setMinimum(19);
        this.expectNoPropertyChangeEvent();
        ridget.setValue(1);
        this.verifyPropertyChangeEvents();
    }

    public void testSetMaximumRidgetBased() {
        Slider control = this.getWidget();
        ISliderRidget ridget = this.getRidget();
        int max = 40;
        int thumb = 1;
        int maxValue = max - thumb;
        ridget.setMinimum(0);
        ridget.setThumb(thumb);
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setMaximum(100);
        ridget.setValue(max);
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setMaximum(max);
        SliderRidgetTest.assertEquals((int)max, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)max, (int)this.getMaximum((Control)control));
        SliderRidgetTest.assertEquals((int)maxValue, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)maxValue, (int)this.getValue((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        max = 40;
        thumb = 10;
        maxValue = max - thumb;
        ridget.setMinimum(0);
        ridget.setMaximum(100);
        ridget.setThumb(thumb);
        ridget.setValue(max);
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setMaximum(max);
        SliderRidgetTest.assertEquals((int)max, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)max, (int)this.getMaximum((Control)control));
        SliderRidgetTest.assertEquals((int)maxValue, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)maxValue, (int)this.getValue((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        max = 20;
        thumb = 10;
        maxValue = max - thumb;
        ridget.setMaximum(100);
        ridget.setMinimum(10);
        ridget.setThumb(thumb);
        ridget.setValue(30);
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        try {
            ridget.setMaximum(max);
            SliderRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        SliderRidgetTest.assertEquals((int)100, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)100, (int)this.getMaximum((Control)control));
        SliderRidgetTest.assertEquals((int)30, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)30, (int)this.getValue((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        max = 19;
        thumb = 10;
        maxValue = max - thumb;
        ridget.setMaximum(100);
        ridget.setMinimum(10);
        ridget.setThumb(thumb);
        ridget.setValue(30);
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        try {
            ridget.setMaximum(max);
            SliderRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        SliderRidgetTest.assertEquals((int)100, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)100, (int)this.getMaximum((Control)control));
        SliderRidgetTest.assertEquals((int)30, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)30, (int)this.getValue((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        try {
            ridget.setMaximum(-1);
            SliderRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        SliderRidgetTest.assertEquals((int)100, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)100, (int)this.getMaximum((Control)control));
        SliderRidgetTest.assertEquals((int)30, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)30, (int)this.getValue((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        max = 21;
        thumb = 10;
        maxValue = max - thumb;
        ridget.setMaximum(100);
        ridget.setMinimum(10);
        ridget.setThumb(thumb);
        ridget.setValue(30);
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setMaximum(max);
        SliderRidgetTest.assertEquals((int)max, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)max, (int)this.getMaximum((Control)control));
        SliderRidgetTest.assertEquals((int)maxValue, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)maxValue, (int)this.getValue((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        max = 20;
        thumb = 10;
        maxValue = max - thumb;
        ridget.setMaximum(100);
        ridget.setMinimum(10);
        ridget.setThumb(thumb);
        ridget.setValue(30);
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        try {
            ridget.setMaximum(max);
            SliderRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        SliderRidgetTest.assertEquals((int)100, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)100, (int)this.getMaximum((Control)control));
        SliderRidgetTest.assertEquals((int)30, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)30, (int)this.getValue((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        max = 19;
        thumb = 10;
        maxValue = max - thumb;
        ridget.setMaximum(100);
        ridget.setMinimum(10);
        ridget.setThumb(thumb);
        ridget.setValue(30);
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        try {
            ridget.setMaximum(max);
            SliderRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        SliderRidgetTest.assertEquals((int)100, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)100, (int)this.getMaximum((Control)control));
        SliderRidgetTest.assertEquals((int)30, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)30, (int)this.getValue((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setMinimum(0);
        int maxIncrement = 17;
        ridget.setMaximum(20);
        ridget.setMinimum(1);
        ridget.setThumb(2);
        ridget.setIncrement(20);
        SliderRidgetTest.assertEquals((int)maxIncrement, (int)ridget.getIncrement());
        SliderRidgetTest.assertEquals((int)maxIncrement, (int)this.getIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        maxIncrement = 7;
        ridget.setMaximum(10);
        SliderRidgetTest.assertEquals((int)maxIncrement, (int)ridget.getIncrement());
        SliderRidgetTest.assertEquals((int)maxIncrement, (int)this.getIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        int maxPageIncrement = 17;
        ridget.setMaximum(20);
        ridget.setMinimum(1);
        ridget.setThumb(2);
        ridget.setPageIncrement(20);
        SliderRidgetTest.assertEquals((int)maxPageIncrement, (int)ridget.getPageIncrement());
        SliderRidgetTest.assertEquals((int)maxPageIncrement, (int)this.getPageIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        maxPageIncrement = 7;
        ridget.setMaximum(10);
        SliderRidgetTest.assertEquals((int)maxPageIncrement, (int)ridget.getPageIncrement());
        SliderRidgetTest.assertEquals((int)maxPageIncrement, (int)this.getPageIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
    }

    public void testSetMaximumFiresEventsRidgetBased() {
        ISliderRidget ridget = this.getRidget();
        this.resetEasyMock();
        int max = 20;
        int min = 10;
        int thumb = 1;
        ridget.setMaximum(max);
        ridget.setThumb(thumb);
        ridget.setMinimum(min);
        SliderRidgetTest.assertEquals((int)20, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        SliderRidgetTest.assertEquals((int)max, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)min, (int)ridget.getMinimum());
        SliderRidgetTest.assertEquals((int)thumb, (int)ridget.getThumb());
        int deltaMaxMin = max - thumb - min;
        ridget.setIncrement(deltaMaxMin);
        ridget.setPageIncrement(deltaMaxMin);
        int oldPageIncrement = ridget.getPageIncrement();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "increment", deltaMaxMin, deltaMaxMin - 1), new PropertyChangeEvent(ridget, "pageIncrement", oldPageIncrement, deltaMaxMin - 1), new PropertyChangeEvent(ridget, "maximum", max, max - 1));
        ridget.setMaximum(max - 1);
        this.verifyPropertyChangeEvents();
    }

    public void testSetMinimumRidgetBased() {
        ISliderRidget ridget = this.getRidget();
        Slider control = this.getWidget();
        int maxIncrement = 17;
        ridget.setMaximum(20);
        ridget.setMinimum(1);
        ridget.setThumb(2);
        ridget.setIncrement(20);
        SliderRidgetTest.assertEquals((int)maxIncrement, (int)ridget.getIncrement());
        SliderRidgetTest.assertEquals((int)maxIncrement, (int)this.getIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        maxIncrement = 13;
        ridget.setMinimum(5);
        SliderRidgetTest.assertEquals((int)maxIncrement, (int)ridget.getIncrement());
        SliderRidgetTest.assertEquals((int)maxIncrement, (int)this.getIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        int maxPageIncrement = 17;
        ridget.setMaximum(20);
        ridget.setMinimum(1);
        ridget.setThumb(2);
        ridget.setPageIncrement(20);
        SliderRidgetTest.assertEquals((int)maxPageIncrement, (int)ridget.getPageIncrement());
        SliderRidgetTest.assertEquals((int)maxPageIncrement, (int)this.getPageIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        maxPageIncrement = 13;
        ridget.setMinimum(5);
        SliderRidgetTest.assertEquals((int)maxPageIncrement, (int)ridget.getPageIncrement());
        SliderRidgetTest.assertEquals((int)maxPageIncrement, (int)this.getPageIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
    }

    public void testSetMinimumFiresEventsRidgetBased() {
        ISliderRidget ridget = this.getRidget();
        this.resetEasyMock();
        int max = 20;
        int min = 10;
        int thumb = 1;
        ridget.setMaximum(max);
        ridget.setThumb(thumb);
        ridget.setMinimum(min);
        SliderRidgetTest.assertEquals((int)max, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)min, (int)ridget.getMinimum());
        SliderRidgetTest.assertEquals((int)thumb, (int)ridget.getThumb());
        int deltaMaxMin = max - thumb - min;
        ridget.setIncrement(deltaMaxMin);
        ridget.setPageIncrement(deltaMaxMin);
        int oldPageIncrement = ridget.getPageIncrement();
        int oldValue = ridget.getValue();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "value", oldValue, min + 1), new PropertyChangeEvent(ridget, "increment", deltaMaxMin, deltaMaxMin - 1), new PropertyChangeEvent(ridget, "pageIncrement", oldPageIncrement, deltaMaxMin - 1), new PropertyChangeEvent(ridget, "minimum", min, min + 1));
        ridget.setMinimum(min + 1);
        this.verifyPropertyChangeEvents();
    }

    public void testSetIncrementRidgetBased() {
        ISliderRidget ridget = this.getRidget();
        Slider control = this.getWidget();
        int deltaMaxMin = 92;
        ridget.setMaximum(100);
        ridget.setMinimum(7);
        ridget.setThumb(1);
        ridget.setIncrement(deltaMaxMin + 3);
        SliderRidgetTest.assertEquals((int)deltaMaxMin, (int)ridget.getIncrement());
        SliderRidgetTest.assertEquals((int)deltaMaxMin, (int)this.getIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setIncrement(deltaMaxMin - 1);
        SliderRidgetTest.assertEquals((int)(deltaMaxMin - 1), (int)ridget.getIncrement());
        SliderRidgetTest.assertEquals((int)(deltaMaxMin - 1), (int)this.getIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setIncrement(deltaMaxMin);
        SliderRidgetTest.assertEquals((int)deltaMaxMin, (int)ridget.getIncrement());
        SliderRidgetTest.assertEquals((int)deltaMaxMin, (int)this.getIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
    }

    public void testSetIncrementFiresEventsRidgetBased() {
        ISliderRidget ridget = this.getRidget();
        ridget.setIncrement(1);
        this.resetEasyMock();
        int max = 20;
        int min = 10;
        int thumb = 1;
        ridget.setMaximum(max);
        ridget.setThumb(thumb);
        ridget.setMinimum(min);
        SliderRidgetTest.assertEquals((int)max, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)min, (int)ridget.getMinimum());
        SliderRidgetTest.assertEquals((int)thumb, (int)ridget.getThumb());
        int deltaMaxMin = max - thumb - min;
        this.expectPropertyChangeEvent("increment", 1, deltaMaxMin);
        ridget.setIncrement(max);
        this.verifyPropertyChangeEvents();
    }

    public void testSetPageIncrementRidgetBased() {
        ISliderRidget ridget = this.getRidget();
        Slider control = this.getWidget();
        int deltaMaxMin = 92;
        ridget.setMaximum(100);
        ridget.setMinimum(7);
        ridget.setThumb(1);
        ridget.setPageIncrement(deltaMaxMin + 3);
        SliderRidgetTest.assertEquals((int)deltaMaxMin, (int)ridget.getPageIncrement());
        SliderRidgetTest.assertEquals((int)deltaMaxMin, (int)this.getPageIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setPageIncrement(deltaMaxMin - 1);
        SliderRidgetTest.assertEquals((int)(deltaMaxMin - 1), (int)ridget.getPageIncrement());
        SliderRidgetTest.assertEquals((int)(deltaMaxMin - 1), (int)this.getPageIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setPageIncrement(deltaMaxMin);
        SliderRidgetTest.assertEquals((int)deltaMaxMin, (int)ridget.getPageIncrement());
        SliderRidgetTest.assertEquals((int)deltaMaxMin, (int)this.getPageIncrement((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
    }

    public void testSetPageIncrementFiresEventsRidgetBased() {
        ISliderRidget ridget = this.getRidget();
        ridget.setPageIncrement(1);
        this.resetEasyMock();
        ridget.setMaximum(20);
        ridget.setThumb(1);
        ridget.setMinimum(10);
        SliderRidgetTest.assertEquals((int)20, (int)ridget.getMaximum());
        SliderRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        int deltaMaxMin = 9;
        this.expectPropertyChangeEvent("pageIncrement", 1, deltaMaxMin);
        ridget.setPageIncrement(20);
        this.verifyPropertyChangeEvents();
    }

    public void testSetMinimum() {
        super.testSetMinimum();
        ISliderRidget ridget = this.getRidget();
        Slider control = this.getWidget();
        int max = 100;
        int min = 20;
        int thumb = 10;
        ridget.setMaximum(max);
        ridget.setMinimum(10);
        ridget.setThumb(thumb);
        ridget.setValue(20);
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setMinimum(min);
        SliderRidgetTest.assertEquals((int)min, (int)ridget.getMinimum());
        SliderRidgetTest.assertEquals((int)min, (int)this.getMinimum((Control)control));
        SliderRidgetTest.assertEquals((int)min, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)min, (int)this.getValue((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        max = 40;
        min = 30;
        thumb = 10;
        ridget.setMaximum(max);
        ridget.setMinimum(10);
        ridget.setThumb(thumb);
        ridget.setValue(20);
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        try {
            ridget.setMinimum(min);
            SliderRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        SliderRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        SliderRidgetTest.assertEquals((int)10, (int)this.getMinimum((Control)control));
        SliderRidgetTest.assertEquals((int)20, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)20, (int)this.getValue((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        max = 40;
        min = 31;
        thumb = 10;
        ridget.setMaximum(max);
        ridget.setMinimum(10);
        ridget.setThumb(thumb);
        ridget.setValue(20);
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        try {
            ridget.setMinimum(min);
            SliderRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        SliderRidgetTest.assertEquals((int)10, (int)ridget.getMinimum());
        SliderRidgetTest.assertEquals((int)10, (int)this.getMinimum((Control)control));
        SliderRidgetTest.assertEquals((int)20, (int)ridget.getValue());
        SliderRidgetTest.assertEquals((int)20, (int)this.getValue((Control)control));
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
    }

    public void testSetThumb() {
        ISliderRidget ridget = this.getRidget();
        Slider control = this.getWidget();
        ridget.setMaximum(100);
        ridget.setMinimum(10);
        ridget.setThumb(20);
        SliderRidgetTest.assertEquals((int)20, (int)ridget.getThumb());
        SliderRidgetTest.assertEquals((int)20, (int)control.getThumb());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        try {
            ridget.setThumb(0);
            SliderRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        try {
            ridget.setThumb(500);
            SliderRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        try {
            ridget.setThumb(90);
            SliderRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setThumb(89);
        SliderRidgetTest.assertEquals((int)89, (int)ridget.getThumb());
        SliderRidgetTest.assertEquals((int)89, (int)control.getThumb());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
    }

    public void testSetThumbFiresEvents() {
        ISliderRidget ridget = this.getRidget();
        ridget.setMinimum(0);
        ridget.setMaximum(100);
        ridget.setThumb(25);
        this.expectPropertyChangeEvent("thumb", 25, 50);
        ridget.setThumb(50);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setThumb(50);
        this.verifyPropertyChangeEvents();
    }

    public void testApplyThumbOnBind() {
        ISliderRidget ridget = this.getRidget();
        Slider control = (Slider)this.createWidget((Composite)this.getShell());
        ridget.setMinimum(0);
        ridget.setMaximum(100);
        ridget.setThumb(25);
        ridget.setUIControl((Object)control);
        SliderRidgetTest.assertEquals((int)25, (int)control.getThumb());
    }
}

