/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetLabelProvider;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.ColumnFormatter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

@NonUITestCase
public class TableRidgetLabelProviderTest
extends TestCase {
    private WordNode elementA;
    private WordNode elementB;
    private Color colorA;
    private Color colorB;
    private Font fontA;
    private Font fontB;
    private IObservableMap[] attrMaps;
    private IColumnFormatter[] formatters;
    private IColumnFormatter[] noFormatters;

    protected void setUp() throws Exception {
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        this.colorA = display.getSystemColor(3);
        this.colorB = display.getSystemColor(5);
        this.fontA = new Font((Device)display, "Arial", 12, 0);
        this.fontB = new Font((Device)display, "Courier", 12, 0);
        IObservableSet elements = this.createElements();
        String[] columnProperties = new String[]{"word", "upperCase"};
        this.attrMaps = BeansObservables.observeMaps((IObservableSet)elements, WordNode.class, (String[])columnProperties);
        IColumnFormatter[] iColumnFormatterArray = new IColumnFormatter[2];
        iColumnFormatterArray[1] = new TestColumnFormatter();
        this.formatters = iColumnFormatterArray;
        this.noFormatters = new IColumnFormatter[this.attrMaps.length];
    }

    protected void tearDown() throws Exception {
        this.fontA.dispose();
        this.fontB.dispose();
    }

    public void testGetText() {
        TableRidgetLabelProvider labelProvider = new TableRidgetLabelProvider(this.attrMaps, this.noFormatters);
        TableRidgetLabelProviderTest.assertEquals((String)"Alpha", (String)labelProvider.getText((Object)this.elementA));
        TableRidgetLabelProviderTest.assertEquals((String)"BRAVO", (String)labelProvider.getText((Object)this.elementB));
    }

    public void testGetColumnText() {
        TableRidgetLabelProvider labelProvider = new TableRidgetLabelProvider(this.attrMaps, this.noFormatters);
        TableRidgetLabelProviderTest.assertEquals((String)"Alpha", (String)labelProvider.getColumnText((Object)this.elementA, 0));
        TableRidgetLabelProviderTest.assertEquals((String)"BRAVO", (String)labelProvider.getColumnText((Object)this.elementB, 0));
        TableRidgetLabelProviderTest.assertEquals((String)"false", (String)labelProvider.getColumnText((Object)this.elementA, 1));
        TableRidgetLabelProviderTest.assertEquals((String)"true", (String)labelProvider.getColumnText((Object)this.elementB, 1));
        TableRidgetLabelProviderTest.assertEquals(null, (String)labelProvider.getColumnText((Object)this.elementA, 99));
    }

    public void testGetImage() {
        TableRidgetLabelProvider labelProvider = new TableRidgetLabelProvider(this.attrMaps, this.noFormatters);
        TableRidgetLabelProviderTest.assertNull((Object)labelProvider.getImage((Object)this.elementA));
        TableRidgetLabelProviderTest.assertNull((Object)labelProvider.getImage((Object)this.elementB));
        IObservableSet elements = this.createElements();
        String[] columnProperties = new String[]{"upperCase"};
        IObservableMap[] attrMap = BeansObservables.observeMaps((IObservableSet)elements, WordNode.class, (String[])columnProperties);
        labelProvider = new TableRidgetLabelProvider(attrMap, new IColumnFormatter[1]);
        Image siUnchecked = Activator.getSharedImage((String)"IMG_UNCHECKED");
        TableRidgetLabelProviderTest.assertNotNull((Object)siUnchecked);
        TableRidgetLabelProviderTest.assertEquals((Object)siUnchecked, (Object)labelProvider.getImage((Object)this.elementA));
        Image siChecked = Activator.getSharedImage((String)"IMG_CHECKED");
        TableRidgetLabelProviderTest.assertNotNull((Object)siChecked);
        TableRidgetLabelProviderTest.assertEquals((Object)siChecked, (Object)labelProvider.getImage((Object)this.elementB));
        TableRidgetLabelProviderTest.assertNotSame((Object)siChecked, (Object)siUnchecked);
    }

    public void testGetColumnImage() {
        TableRidgetLabelProvider labelProvider = new TableRidgetLabelProvider(this.attrMaps, this.noFormatters);
        TableRidgetLabelProviderTest.assertNull((Object)labelProvider.getColumnImage((Object)this.elementA, 0));
        TableRidgetLabelProviderTest.assertNull((Object)labelProvider.getColumnImage((Object)this.elementB, 0));
        Image siUnchecked = Activator.getSharedImage((String)"IMG_UNCHECKED");
        TableRidgetLabelProviderTest.assertNotNull((Object)siUnchecked);
        TableRidgetLabelProviderTest.assertEquals((Object)siUnchecked, (Object)labelProvider.getColumnImage((Object)this.elementA, 1));
        Image siChecked = Activator.getSharedImage((String)"IMG_CHECKED");
        TableRidgetLabelProviderTest.assertNotNull((Object)siChecked);
        TableRidgetLabelProviderTest.assertEquals((Object)siChecked, (Object)labelProvider.getColumnImage((Object)this.elementB, 1));
        TableRidgetLabelProviderTest.assertNotSame((Object)siChecked, (Object)siUnchecked);
        TableRidgetLabelProviderTest.assertEquals(null, (Object)labelProvider.getColumnImage((Object)this.elementA, 99));
    }

    public void testSetFormatters() {
        TableRidgetLabelProvider labelProvider = new TableRidgetLabelProvider(this.attrMaps, this.formatters);
        TableRidgetLabelProviderTest.assertEquals((String)"no", (String)labelProvider.getColumnText((Object)this.elementA, 1));
        TableRidgetLabelProviderTest.assertEquals((String)"yes", (String)labelProvider.getColumnText((Object)this.elementB, 1));
        IColumnFormatter[] arg2 = new IColumnFormatter[2];
        ReflectionUtils.invokeHidden((Object)labelProvider, (String)"setFormatters", (Object[])new Object[]{arg2});
        TableRidgetLabelProviderTest.assertEquals((String)"false", (String)labelProvider.getColumnText((Object)this.elementA, 1));
        TableRidgetLabelProviderTest.assertEquals((String)"true", (String)labelProvider.getColumnText((Object)this.elementB, 1));
        try {
            IColumnFormatter[] arg3 = new IColumnFormatter[3];
            ReflectionUtils.invokeHidden((Object)labelProvider, (String)"setFormatters", (Object[])new Object[]{arg3});
            TableRidgetLabelProviderTest.fail();
        }
        catch (RuntimeException runtimeException) {
            Nop.reason((String)"ok");
        }
    }

    public void testGetColumnTextWithFormatter() {
        TableRidgetLabelProvider labelProvider = new TableRidgetLabelProvider(this.attrMaps, this.formatters);
        TableRidgetLabelProviderTest.assertEquals((String)"Alpha", (String)labelProvider.getColumnText((Object)this.elementA, 0));
        TableRidgetLabelProviderTest.assertEquals((String)"BRAVO", (String)labelProvider.getColumnText((Object)this.elementB, 0));
        TableRidgetLabelProviderTest.assertEquals((String)"no", (String)labelProvider.getColumnText((Object)this.elementA, 1));
        TableRidgetLabelProviderTest.assertEquals((String)"yes", (String)labelProvider.getColumnText((Object)this.elementB, 1));
        TableRidgetLabelProviderTest.assertEquals(null, (String)labelProvider.getColumnText((Object)this.elementA, 99));
    }

    public void testGetColumnImageWithFormatter() {
        TableRidgetLabelProvider labelProvider = new TableRidgetLabelProvider(this.attrMaps, this.formatters);
        TableRidgetLabelProviderTest.assertNull((Object)labelProvider.getColumnImage((Object)this.elementA, 0));
        TableRidgetLabelProviderTest.assertNull((Object)labelProvider.getColumnImage((Object)this.elementB, 0));
        Image siCollaped = Activator.getSharedImage((String)"IMG_NODE_COLLAPSED");
        TableRidgetLabelProviderTest.assertNotNull((Object)siCollaped);
        TableRidgetLabelProviderTest.assertEquals((Object)siCollaped, (Object)labelProvider.getColumnImage((Object)this.elementA, 1));
        Image siExpanded = Activator.getSharedImage((String)"IMG_NODE_EXPANDED");
        TableRidgetLabelProviderTest.assertNotNull((Object)siExpanded);
        TableRidgetLabelProviderTest.assertEquals((Object)siExpanded, (Object)labelProvider.getColumnImage((Object)this.elementB, 1));
        TableRidgetLabelProviderTest.assertNotSame((Object)siExpanded, (Object)siCollaped);
        TableRidgetLabelProviderTest.assertEquals(null, (Object)labelProvider.getColumnImage((Object)this.elementA, 99));
    }

    public void testGetForegroundWithFormatter() {
        TableRidgetLabelProvider labelProvider = new TableRidgetLabelProvider(this.attrMaps, this.formatters);
        TableRidgetLabelProviderTest.assertNull((Object)labelProvider.getForeground((Object)this.elementA, 0));
        TableRidgetLabelProviderTest.assertNull((Object)labelProvider.getForeground((Object)this.elementB, 0));
        TableRidgetLabelProviderTest.assertSame((Object)this.colorA, (Object)labelProvider.getForeground((Object)this.elementA, 1));
        TableRidgetLabelProviderTest.assertSame((Object)this.colorB, (Object)labelProvider.getForeground((Object)this.elementB, 1));
        TableRidgetLabelProviderTest.assertEquals(null, (Object)labelProvider.getForeground((Object)this.elementA, 99));
    }

    public void testGetBackgroundWithFormatter() {
        TableRidgetLabelProvider labelProvider = new TableRidgetLabelProvider(this.attrMaps, this.formatters);
        TableRidgetLabelProviderTest.assertNull((Object)labelProvider.getBackground((Object)this.elementA, 0));
        TableRidgetLabelProviderTest.assertNull((Object)labelProvider.getBackground((Object)this.elementB, 0));
        TableRidgetLabelProviderTest.assertSame((Object)this.colorA, (Object)labelProvider.getBackground((Object)this.elementA, 1));
        TableRidgetLabelProviderTest.assertSame((Object)this.colorB, (Object)labelProvider.getBackground((Object)this.elementB, 1));
        TableRidgetLabelProviderTest.assertEquals(null, (Object)labelProvider.getBackground((Object)this.elementA, 99));
    }

    public void testGetFontWithFormatter() {
        TableRidgetLabelProvider labelProvider = new TableRidgetLabelProvider(this.attrMaps, this.formatters);
        TableRidgetLabelProviderTest.assertNull((Object)labelProvider.getFont((Object)this.elementA, 0));
        TableRidgetLabelProviderTest.assertNull((Object)labelProvider.getFont((Object)this.elementB, 0));
        TableRidgetLabelProviderTest.assertSame((Object)this.fontA, (Object)labelProvider.getFont((Object)this.elementA, 1));
        TableRidgetLabelProviderTest.assertSame((Object)this.fontB, (Object)labelProvider.getFont((Object)this.elementB, 1));
        TableRidgetLabelProviderTest.assertEquals(null, (Object)labelProvider.getFont((Object)this.elementA, 99));
    }

    private IObservableSet createElements() {
        ArrayList<WordNode> collection = new ArrayList<WordNode>();
        this.elementA = new WordNode("Alpha");
        this.elementB = new WordNode("Bravo");
        this.elementB.setUpperCase(true);
        collection.add(this.elementA);
        collection.add(this.elementB);
        WritableSet elements = new WritableSet(Realm.getDefault(), collection, WordNode.class);
        return elements;
    }

    private final class TestColumnFormatter
    extends ColumnFormatter {
        private TestColumnFormatter() {
        }

        public String getText(Object element) {
            WordNode wordNode = (WordNode)element;
            return wordNode.isUpperCase() ? "yes" : "no";
        }

        public Image getImage(Object element) {
            WordNode wordNode = (WordNode)element;
            String key = "alpha".equalsIgnoreCase(wordNode.getWord()) ? "IMG_NODE_COLLAPSED" : "IMG_NODE_EXPANDED";
            return Activator.getSharedImage((String)key);
        }

        public Color getForeground(Object element) {
            WordNode wordNode = (WordNode)element;
            return "alpha".equalsIgnoreCase(wordNode.getWord()) ? TableRidgetLabelProviderTest.this.colorA : TableRidgetLabelProviderTest.this.colorB;
        }

        public Color getBackground(Object element) {
            WordNode wordNode = (WordNode)element;
            return "alpha".equalsIgnoreCase(wordNode.getWord()) ? TableRidgetLabelProviderTest.this.colorA : TableRidgetLabelProviderTest.this.colorB;
        }

        public Font getFont(Object element) {
            WordNode wordNode = (WordNode)element;
            return "alpha".equalsIgnoreCase(wordNode.getWord()) ? TableRidgetLabelProviderTest.this.fontA : TableRidgetLabelProviderTest.this.fontB;
        }
    }
}

