/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@UITestCase
public class TextRidgetSharedViewTest
extends RienaTestCase {
    private Shell shell;
    private Text widget;
    private ITextRidget textRidget1;
    private ITextRidget textRidget2;

    protected void setUp() throws Exception {
        super.setUp();
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        TextRidgetSharedViewTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        this.shell = new Shell(147456);
        this.shell.setLayout((Layout)new RowLayout(512));
        this.widget = new Text((Composite)this.shell, 0);
        this.textRidget1 = new TextRidget();
        this.textRidget1.setUIControl((Object)this.widget);
        this.textRidget2 = new TextRidget();
        this.shell.setSize(130, 100);
        this.shell.setLocation(0, 0);
        this.shell.open();
    }

    protected void tearDown() throws Exception {
        this.textRidget1 = null;
        this.textRidget2 = null;
        this.widget = null;
        this.shell.dispose();
        this.shell = null;
        super.tearDown();
    }

    public void testMandatoryMarkersInSharedViews() throws Exception {
        Color normalBackground = this.widget.getBackground();
        this.textRidget1.setMandatory(true);
        this.textRidget2.setMandatory(true);
        Color mandatoryBackground = this.widget.getBackground();
        TextRidgetSharedViewTest.assertFalse((boolean)normalBackground.equals((Object)mandatoryBackground));
        TextRidgetSharedViewTest.assertEquals((Object)mandatoryBackground, (Object)this.widget.getBackground());
        this.textRidget1.setUIControl(null);
        this.textRidget2.setUIControl((Object)this.widget);
        TextRidgetSharedViewTest.assertEquals((Object)mandatoryBackground, (Object)this.widget.getBackground());
        this.textRidget2.setText("Text");
        TextRidgetSharedViewTest.assertEquals((Object)normalBackground, (Object)this.widget.getBackground());
        this.textRidget2.setUIControl(null);
        this.textRidget1.setUIControl((Object)this.widget);
        TextRidgetSharedViewTest.assertEquals((Object)mandatoryBackground, (Object)this.widget.getBackground());
        this.textRidget1.setText("Text");
        TextRidgetSharedViewTest.assertEquals((Object)normalBackground, (Object)this.widget.getBackground());
    }
}

