/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import junit.framework.TestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.NodePositioner;
import org.eclipse.riena.navigation.model.NavigationModelFailure;
import org.eclipse.riena.navigation.model.SubModuleNode;

@NonUITestCase
public class NodePositionerTest
extends TestCase {
    public void testAddChildToParentFixed() {
        SubModuleNode parent = new SubModuleNode(new NavigationNodeId("p"));
        SubModuleNode childA = new SubModuleNode(new NavigationNodeId("ca"));
        SubModuleNode childToAdd = new SubModuleNode(new NavigationNodeId("cta"));
        SubModuleNode childC = new SubModuleNode(new NavigationNodeId("cc"));
        NodePositionerTest.assertFalse((boolean)parent.getChildren().contains(childA));
        NodePositionerTest.assertFalse((boolean)parent.getChildren().contains(childToAdd));
        parent.addChild((INavigationNode)childA);
        NodePositioner.ADD_BEGINNING.addChildToParent((INavigationNode)parent, (INavigationNode)childToAdd);
        NodePositionerTest.assertEquals((Object)childToAdd, (Object)parent.getChild(0));
        parent.removeChild((INavigationNode)childToAdd);
        parent.addChild((INavigationNode)childC);
        NodePositioner.ADD_END.addChildToParent((INavigationNode)parent, (INavigationNode)childToAdd);
        NodePositionerTest.assertEquals((Object)childToAdd, (Object)parent.getChild(parent.getChildren().size() - 1));
        parent.removeChild((INavigationNode)childToAdd);
        NodePositioner.indexed((int)1).addChildToParent((INavigationNode)parent, (INavigationNode)childToAdd);
        NodePositionerTest.assertEquals((Object)childToAdd, (Object)parent.getChild(1));
        parent.removeChild((INavigationNode)childToAdd);
        boolean failureOccured = false;
        try {
            NodePositioner.indexed((int)-1).addChildToParent((INavigationNode)parent, (INavigationNode)childToAdd);
        }
        catch (NavigationModelFailure navigationModelFailure) {
            failureOccured = true;
        }
        NodePositionerTest.assertTrue((boolean)failureOccured);
        failureOccured = false;
        try {
            NodePositioner.ordinal((int)10).addChildToParent((INavigationNode)parent, (INavigationNode)new SubModuleNode(new NavigationNodeId("ordinal")));
        }
        catch (NavigationModelFailure navigationModelFailure) {
            failureOccured = true;
        }
        NodePositionerTest.assertTrue((boolean)failureOccured);
    }

    public void testAddChildToParentOrdinal() {
        SubModuleNode parent = new SubModuleNode(new NavigationNodeId("p"));
        SubModuleNode childA = new SubModuleNode(new NavigationNodeId("A"));
        SubModuleNode childB = new SubModuleNode(new NavigationNodeId("B"));
        SubModuleNode childC = new SubModuleNode(new NavigationNodeId("C"));
        SubModuleNode childD = new SubModuleNode(new NavigationNodeId("D"));
        NodePositionerTest.assertFalse((boolean)parent.getChildren().contains(childA));
        NodePositionerTest.assertFalse((boolean)parent.getChildren().contains(childB));
        NodePositioner.ordinal((int)10).addChildToParent((INavigationNode)parent, (INavigationNode)childA);
        NodePositionerTest.assertEquals((Object)childA, (Object)parent.getChild(0));
        NodePositioner.ordinal((int)5).addChildToParent((INavigationNode)parent, (INavigationNode)childB);
        NodePositionerTest.assertEquals((Object)childB, (Object)parent.getChild(0));
        NodePositionerTest.assertEquals((Object)childA, (Object)parent.getChild(1));
        NodePositioner.ordinal((int)15).addChildToParent((INavigationNode)parent, (INavigationNode)childC);
        NodePositionerTest.assertEquals((Object)childB, (Object)parent.getChild(0));
        NodePositionerTest.assertEquals((Object)childA, (Object)parent.getChild(1));
        NodePositionerTest.assertEquals((Object)childC, (Object)parent.getChild(2));
        boolean failureOccured = false;
        try {
            NodePositioner.indexed((int)1).addChildToParent((INavigationNode)parent, (INavigationNode)childD);
        }
        catch (NavigationModelFailure navigationModelFailure) {
            failureOccured = true;
        }
        NodePositionerTest.assertTrue((boolean)failureOccured);
    }
}

