/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.navigation.ui.swt.component.MenuCoolBarComposite;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class MenuCoolBarCompositeTest
extends TestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testMenuCoolBarComposite() {
        MenuCoolBarComposite composite = new MenuCoolBarComposite((Composite)this.shell, 0);
        ToolBar toolBar = (ToolBar)ReflectionUtils.getHidden((Object)composite, (String)"toolBar");
        MenuCoolBarCompositeTest.assertNotNull((Object)toolBar);
        Listener[] listeners = toolBar.getListeners(5);
        MenuCoolBarCompositeTest.assertEquals((int)1, (int)listeners.length);
        CoolBar coolBar = (CoolBar)toolBar.getParent();
        MenuCoolBarCompositeTest.assertEquals((int)1, (int)coolBar.getItemCount());
        CoolItem item = coolBar.getItem(0);
        MenuCoolBarCompositeTest.assertSame((Object)toolBar, (Object)item.getControl());
    }

    public void testCreateAndAddMenu() {
        MenuCoolBarComposite composite = new MenuCoolBarComposite((Composite)this.shell, 0);
        MenuManager manager = new MenuManager("TestMenu", "0815");
        ToolItem topItem = composite.createAndAddMenu(manager);
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        MenuCoolBarCompositeTest.assertEquals((String)"0815", (String)locator.locateBindingProperty((Object)topItem));
        MenuCoolBarCompositeTest.assertEquals((String)"TestMenu", (String)topItem.getText());
    }

    public void testGetTopLevelItems() {
        MenuCoolBarComposite composite = new MenuCoolBarComposite((Composite)this.shell, 0);
        MenuManager manager = new MenuManager("TestMenu", "0815");
        ToolItem topItem = composite.createAndAddMenu(manager);
        List items = composite.getTopLevelItems();
        MenuCoolBarCompositeTest.assertEquals((int)1, (int)items.size());
        MenuCoolBarCompositeTest.assertTrue((boolean)items.contains(topItem));
    }
}

