/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.easymock.EasyMock;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.navigation.ui.swt.IAdvisorHelper;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.swt.views.ApplicationViewAdvisor;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;

@UITestCase
public class ApplicationViewAdvisorTest
extends RienaTestCase {
    private ApplicationViewAdvisor advisor;
    private IWorkbenchWindowConfigurer winConfig;
    private ApplicationNode applicationNode;
    private ApplicationController controller;

    protected void setUp() throws Exception {
        this.winConfig = (IWorkbenchWindowConfigurer)EasyMock.createNiceMock(IWorkbenchWindowConfigurer.class);
        this.applicationNode = new ApplicationNode();
        this.controller = new ApplicationController((IApplicationNode)this.applicationNode);
        IAdvisorHelper factory = (IAdvisorHelper)EasyMock.createMock(IAdvisorHelper.class);
        this.advisor = new ApplicationViewAdvisor(this.winConfig, this.controller, factory);
        Wire.instance((Object)this.advisor).andStart(this.getContext());
    }

    protected void tearDown() throws Exception {
        this.applicationNode = null;
        this.controller = null;
        this.winConfig = null;
        this.advisor.dispose();
        this.advisor = null;
    }

    public void testInitShell() {
        Shell shell = new Shell();
        ApplicationViewAdvisorTest.assertNotSame((Object)2, (Object)shell.getBackgroundMode());
        Point defMinSize = shell.getMinimumSize();
        ReflectionUtils.invokeHidden((Object)this.advisor, (String)"initShell", (Object[])new Object[]{shell});
        ApplicationViewAdvisorTest.assertFalse((boolean)defMinSize.equals((Object)shell.getMinimumSize()));
        ApplicationViewAdvisorTest.assertNotNull((Object)shell.getData("binding_property"));
        SwtUtilities.disposeWidget((Widget)shell);
    }

    public void testInitApplicationSize() {
        System.setProperty("riena.application.width", "9000");
        System.setProperty("riena.application.height", "8000");
        EasyMock.reset((Object[])new Object[]{this.winConfig});
        this.winConfig.setInitialSize(new Point(9000, 8000));
        EasyMock.replay((Object[])new Object[]{this.winConfig});
        ReflectionUtils.invokeHidden((Object)this.advisor, (String)"initApplicationSize", (Object[])new Object[]{this.winConfig});
        EasyMock.verify((Object[])new Object[]{this.winConfig});
        System.setProperty("riena.application.width", "90");
        System.setProperty("riena.application.height", "80");
        EasyMock.reset((Object[])new Object[]{this.winConfig});
        this.winConfig.setInitialSize(new Point(800, 600));
        EasyMock.replay((Object[])new Object[]{this.winConfig});
        ReflectionUtils.invokeHidden((Object)this.advisor, (String)"initApplicationSize", (Object[])new Object[]{this.winConfig});
        EasyMock.verify((Object[])new Object[]{this.winConfig});
    }

    public void testInvokesAdvisorFactory() {
        IActionBarConfigurer actionConfig = (IActionBarConfigurer)EasyMock.createNiceMock(IActionBarConfigurer.class);
        ActionBarAdvisor actionAdvisor = new ActionBarAdvisor(actionConfig);
        IAdvisorHelper factory = (IAdvisorHelper)EasyMock.createMock(IAdvisorHelper.class);
        EasyMock.expect((Object)factory.createActionBarAdvisor(actionConfig)).andReturn((Object)actionAdvisor);
        EasyMock.replay((Object[])new Object[]{factory});
        this.advisor = new ApplicationViewAdvisor(this.winConfig, this.controller, factory);
        this.advisor.createActionBarAdvisor(actionConfig);
        EasyMock.verify((Object[])new Object[]{factory});
    }

    public void testPrepare() {
        ModuleGroupNode moduleGroup = new ModuleGroupNode(new NavigationNodeId("mg"));
        ModuleNode module = new ModuleNode(new NavigationNodeId("m"));
        moduleGroup.addChild((INavigationNode)module);
        SubModuleNode subModule1 = new SubModuleNode(new NavigationNodeId("sm1"));
        module.addChild((INavigationNode)subModule1);
        SubModuleNode subModule2 = new SubModuleNode(new NavigationNodeId("sm2"));
        module.addChild((INavigationNode)subModule2);
        IWorkareaDefinition def = WorkareaManager.getInstance().registerDefinition((INavigationNode)subModule1, (Object)"dummy1");
        def.setRequiredPreparation(false);
        def = WorkareaManager.getInstance().registerDefinition((INavigationNode)subModule2, (Object)"dummy2");
        def.setRequiredPreparation(true);
        ReflectionUtils.invokeHidden((Object)this.advisor, (String)"prepare", (Object[])new Object[]{module});
        ApplicationViewAdvisorTest.assertFalse((boolean)module.isPrepared());
        ApplicationViewAdvisorTest.assertFalse((boolean)subModule1.isPrepared());
        ApplicationViewAdvisorTest.assertFalse((boolean)subModule1.isActivated());
        ApplicationViewAdvisorTest.assertTrue((boolean)subModule2.isPrepared());
        def = WorkareaManager.getInstance().registerDefinition((INavigationNode)subModule1, (Object)"dummy1");
        def.setRequiredPreparation(true);
        subModule1.activate();
        ReflectionUtils.invokeHidden((Object)this.advisor, (String)"prepare", (Object[])new Object[]{module});
        ApplicationViewAdvisorTest.assertFalse((boolean)module.isPrepared());
        ApplicationViewAdvisorTest.assertFalse((boolean)subModule1.isPrepared());
        ApplicationViewAdvisorTest.assertTrue((boolean)subModule1.isActivated());
        ApplicationViewAdvisorTest.assertTrue((boolean)subModule2.isPrepared());
    }
}

