/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.authorizationservice;

import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.security.Permission;
import java.security.Permissions;
import java.security.Principal;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.security.authorizationservice.TestcasePermission;
import org.eclipse.riena.security.common.authentication.SimplePrincipal;
import org.eclipse.riena.security.simpleservices.authorizationservice.store.FilePermissionStore;
import org.xml.sax.SAXException;

@NonUITestCase
public class FilePermissionStoreTest
extends TestCase {
    public void testReadPermission() throws SAXException, IOException, ParserConfigurationException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("policy-def-test.xml");
        FilePermissionStore permStore = new FilePermissionStore(inputStream);
        Permissions perms = permStore.loadPermissions((Principal)new SimplePrincipal("christian"));
        FilePermissionStoreTest.assertTrue((perms != null ? 1 : 0) != 0);
        Enumeration<Permission> enumPerms = perms.elements();
        int count = 0;
        while (enumPerms.hasMoreElements()) {
            Permission p = enumPerms.nextElement();
            ++count;
            if (p instanceof FilePermission) {
                FilePermission fp = (FilePermission)p;
                FilePermissionStoreTest.assertEquals((String)"*.tmp", (String)fp.getName());
                FilePermissionStoreTest.assertTrue((boolean)fp.getActions().equals("read"));
                continue;
            }
            if (p instanceof TestcasePermission) {
                TestcasePermission tcp = (TestcasePermission)p;
                FilePermissionStoreTest.assertEquals((String)"testPerm", (String)tcp.getName());
                continue;
            }
            FilePermissionStoreTest.assertTrue((String)("unknown permission " + p), (boolean)false);
        }
        FilePermissionStoreTest.assertTrue((count == 2 ? 1 : 0) != 0);
    }
}

