/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.services.itest.authentication;

import java.security.Principal;
import javax.security.auth.Subject;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.RemoteFailure;
import org.eclipse.riena.communication.core.factory.Register;
import org.eclipse.riena.communication.core.hooks.ICallHook;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.IntegrationTestCase;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.sample.app.common.model.ICustomerSearch;
import org.eclipse.riena.security.common.BasicAuthenticationCallHook;
import org.eclipse.riena.security.common.ISubjectHolder;
import org.eclipse.riena.security.common.authentication.SimplePrincipal;
import org.osgi.framework.ServiceRegistration;

@IntegrationTestCase
public class BasicAuthenticationITest
extends RienaTestCase {
    private IRemoteServiceRegistration customerSearchRegistration;
    private static final String TESTURL = "http://localhost:8080/junit/protected";

    protected void setUp() throws Exception {
        super.setUp();
        this.startBundles("org\\.eclipse\\.equinox\\.cm.*", null);
        this.startBundles("org\\.eclipse\\.equinox\\.log.*", null);
        this.startBundles("org\\.eclipse\\.riena.communication.core", null);
        this.startBundles("org\\.eclipse\\.riena.communication.factory.hessian", null);
        this.stopBundles("org\\.eclipse\\.riena.example.client", null);
        this.customerSearchRegistration = Register.remoteProxy(ICustomerSearch.class).usingUrl(TESTURL).withProtocol("hessian").andStart(Activator.getDefault().getContext());
    }

    protected void tearDown() throws Exception {
        this.customerSearchRegistration.unregister();
        super.tearDown();
    }

    public void testNoCallHook() {
        try {
            ICustomerSearch customerSearch = (ICustomerSearch)this.getContext().getService(this.getContext().getServiceReference(ICustomerSearch.class.getName()));
            customerSearch.findCustomer(null);
            BasicAuthenticationITest.fail((String)"RemoteFailure HTTP=401 expected");
        }
        catch (RemoteFailure e) {
            BasicAuthenticationITest.assertTrue((boolean)e.getCause().getCause().getMessage().contains("401"));
        }
    }

    public void testWithCallHookNoAuthorization() {
        try {
            ICustomerSearch customerSearch = (ICustomerSearch)this.getContext().getService(this.getContext().getServiceReference(ICustomerSearch.class.getName()));
            ServiceRegistration serviceReg = this.getContext().registerService(ICallHook.class.getName(), (Object)new BasicAuthenticationCallHook(), null);
            customerSearch.findCustomer(null);
            serviceReg.unregister();
            BasicAuthenticationITest.fail((String)"RemoteFailure HTTP=401 expected");
        }
        catch (RemoteFailure e) {
            BasicAuthenticationITest.assertTrue((boolean)e.getCause().getCause().getMessage().contains("401"));
        }
    }

    public void testWithCallHookWithInvalidAuthorization() {
        try {
            ICustomerSearch customerSearch = (ICustomerSearch)this.getContext().getService(this.getContext().getServiceReference(ICustomerSearch.class.getName()));
            ServiceRegistration serviceReg = this.getContext().registerService(ICallHook.class.getName(), (Object)new BasicAuthenticationCallHook(), null);
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new SimplePrincipal("christian"));
            subject.getPrivateCredentials().add("password");
            ((ISubjectHolder)Service.get(ISubjectHolder.class)).setSubject(subject);
            customerSearch.findCustomer(null);
            serviceReg.unregister();
            BasicAuthenticationITest.fail((String)"RemoteFailure HTTP=401 expected");
        }
        catch (RemoteFailure e) {
            BasicAuthenticationITest.assertTrue((boolean)e.getCause().getCause().getMessage().contains("401"));
        }
    }

    public void testWithCallHookWithValidAuthorization() {
        try {
            ICustomerSearch customerSearch = (ICustomerSearch)Service.get(ICustomerSearch.class);
            ServiceRegistration serviceReg = this.getContext().registerService(ICallHook.class.getName(), (Object)new BasicAuthenticationCallHook(), null);
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new SimplePrincipal("scp"));
            subject.getPrivateCredentials().add("scptestpassword");
            ((ISubjectHolder)Service.get(ISubjectHolder.class)).setSubject(subject);
            customerSearch.findCustomer(null);
            serviceReg.unregister();
            BasicAuthenticationITest.fail((String)"RemoteFailure with Protocol Error expected");
        }
        catch (RemoteFailure e) {
            BasicAuthenticationITest.assertFalse((boolean)e.getCause().getCause().getMessage().contains("401"));
            BasicAuthenticationITest.assertTrue((String)e.getCause().getCause().getMessage(), (boolean)e.getCause().getCause().getMessage().contains("unexpected end of file"));
        }
    }

    public void testWithCallHookWithMultipleValidAuthorization() {
        ICustomerSearch customerSearch = (ICustomerSearch)this.getContext().getService(this.getContext().getServiceReference(ICustomerSearch.class.getName()));
        ServiceRegistration serviceReg = this.getContext().registerService(ICallHook.class.getName(), (Object)new BasicAuthenticationCallHook(), null);
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new SimplePrincipal("scp"));
        subject.getPrivateCredentials().add("scptestpassword");
        ((ISubjectHolder)Service.get(ISubjectHolder.class)).setSubject(subject);
        try {
            customerSearch.findCustomer(null);
            BasicAuthenticationITest.fail((String)"RemoteFailure with Protocol Error expected");
        }
        catch (RemoteFailure e) {
            BasicAuthenticationITest.assertFalse((boolean)e.getCause().getCause().getMessage().contains("401"));
            BasicAuthenticationITest.assertTrue((String)e.getCause().getCause().getMessage(), (boolean)e.getCause().getCause().getMessage().contains("unexpected end of file"));
        }
        try {
            customerSearch.findCustomer(null);
            BasicAuthenticationITest.fail((String)"RemoteFailure with Protocol Error expected");
        }
        catch (RemoteFailure e) {
            BasicAuthenticationITest.assertFalse((boolean)e.getCause().getCause().getMessage().contains("401"));
            BasicAuthenticationITest.assertTrue((String)e.getCause().getCause().getMessage(), (boolean)e.getCause().getCause().getMessage().contains("unexpected end of file"));
        }
        serviceReg.unregister();
    }
}

