/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.validation.ValidCharacters;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;

@NonUITestCase
public class ValidCharactersTest
extends RienaTestCase {
    public final void testValidChars() throws Exception {
        ValidCharacters rule = new ValidCharacters("0123456789.");
        ValidCharactersTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidCharactersTest.assertTrue((boolean)rule.validate((Object)"0").isOK());
        ValidCharactersTest.assertTrue((boolean)rule.validate((Object)"1").isOK());
        ValidCharactersTest.assertTrue((boolean)rule.validate((Object)"23456789.").isOK());
        ValidCharactersTest.assertFalse((boolean)rule.validate((Object)"A").isOK());
        ValidCharactersTest.assertFalse((boolean)rule.validate((Object)"A123").isOK());
        ValidCharactersTest.assertFalse((boolean)rule.validate((Object)"123A").isOK());
        ValidCharactersTest.assertFalse((boolean)rule.validate((Object)"123A321").isOK());
        ValidCharactersTest.assertFalse((boolean)rule.validate((Object)"abcdefghijklmnopqrstuvwxyz").isOK());
        ValidCharactersTest.assertFalse((boolean)rule.validate((Object)"ABCDEFGHIJKLMBNOPQRSTUVWXYZ").isOK());
        try {
            rule.validate(new Object());
            ValidCharactersTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
        ValidCharacters nullRule = new ValidCharacters(null);
        ValidCharactersTest.assertTrue((boolean)nullRule.validate(null).isOK());
        ValidCharactersTest.assertFalse((boolean)rule.validate((Object)"A").isOK());
        ValidCharactersTest.assertFalse((boolean)rule.validate((Object)"A123").isOK());
        ValidCharactersTest.assertFalse((boolean)rule.validate((Object)"123A").isOK());
        ValidCharactersTest.assertTrue((boolean)nullRule.validate((Object)"0").isOK());
        ValidCharactersTest.assertTrue((boolean)nullRule.validate((Object)"1").isOK());
        ValidCharactersTest.assertTrue((boolean)nullRule.validate((Object)"23456789.").isOK());
        ValidCharactersTest.assertTrue((boolean)nullRule.validate((Object)"123A321").isOK());
        ValidCharactersTest.assertTrue((boolean)nullRule.validate((Object)"abcdefghijklmnopqrstuvwxyz").isOK());
        ValidCharactersTest.assertTrue((boolean)nullRule.validate((Object)"ABCDEFGHIJKLMBNOPQRSTUVWXYZ").isOK());
        try {
            nullRule.validate(new Object());
            ValidCharactersTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
    }

    public final void testNoNullPointerException() throws Exception {
        ValidCharacters nullRule = new ValidCharacters("");
        nullRule.setAllowedChars(null);
        ValidCharactersTest.assertTrue((boolean)nullRule.validate((Object)"").isOK());
    }

    public void testSetInitializationData() throws Exception {
        ValidCharacters validator = new ValidCharacters();
        ValidCharactersTest.assertTrue((boolean)validator.validate((Object)"A").isOK());
        validator = new ValidCharacters();
        validator.setInitializationData(null, null, (Object)"a");
        ValidCharactersTest.assertTrue((boolean)validator.validate((Object)"a").isOK());
        ValidCharactersTest.assertFalse((boolean)validator.validate((Object)"A").isOK());
    }
}

