/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.ui.swt.Statusline;
import org.eclipse.riena.ui.swt.StatuslineDate;
import org.eclipse.riena.ui.swt.StatuslineNumber;
import org.eclipse.riena.ui.swt.StatuslineSpacer;
import org.eclipse.riena.ui.swt.StatuslineTime;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class StatuslineTest
extends TestCase {
    private Shell shell;
    private Statusline statusline;

    protected void setUp() throws Exception {
        this.shell = new Shell();
        this.statusline = new Statusline((Composite)this.shell, 0, StatuslineSpacer.class);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.disposeWidget((Widget)this.shell);
        SwtUtilities.disposeWidget((Widget)this.statusline);
    }

    public void testAddUIControl() {
        Label label = new Label((Composite)this.shell, 0);
        ReflectionUtils.invokeHidden((Object)this.statusline, (String)"addUIControl", (Object[])new Object[]{label, "labelName"});
        List controls = this.statusline.getUIControls();
        StatuslineTest.assertNotNull((Object)controls);
        StatuslineTest.assertFalse((boolean)controls.isEmpty());
        Label labelOfList = (Label)controls.get(controls.size() - 1);
        StatuslineTest.assertSame((Object)label, (Object)labelOfList);
        StatuslineTest.assertEquals((Object)"labelName", (Object)labelOfList.getData("binding_property"));
        SwtUtilities.disposeWidget((Widget)label);
    }

    public void testCreateContents() {
        Control[] controls = this.statusline.getChildren();
        boolean time = false;
        boolean date = false;
        boolean number = false;
        int i = 0;
        while (i < controls.length) {
            if (controls[i].getClass() == StatuslineTime.class) {
                if (time) {
                    StatuslineTest.fail((String)"More than of time control!");
                }
                time = true;
            }
            if (controls[i].getClass() == StatuslineDate.class) {
                if (date) {
                    StatuslineTest.fail((String)"More than of date control!");
                }
                date = true;
            }
            if (controls[i].getClass() == StatuslineNumber.class) {
                if (number) {
                    StatuslineTest.fail((String)"More than of number control!");
                }
                number = true;
            }
            ++i;
        }
        StatuslineTest.assertTrue((boolean)time);
        StatuslineTest.assertTrue((boolean)date);
        StatuslineTest.assertTrue((boolean)number);
        StatuslineTest.assertNotNull((Object)this.statusline.getMessageComposite());
        number = false;
        List uicontrols = this.statusline.getUIControls();
        for (Object uiControl : uicontrols) {
            if (uiControl.getClass() != StatuslineNumber.class) continue;
            if (number) {
                StatuslineTest.fail((String)"More than of number UI-control!");
            }
            number = true;
            StatuslineNumber statuslineNumber = (StatuslineNumber)uiControl;
            StatuslineTest.assertEquals((Object)"statuslineNumberRidget", (Object)statuslineNumber.getData("binding_property"));
        }
        StatuslineTest.assertTrue((boolean)number);
    }
}

