/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.synchronizer;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.easymock.EasyMock;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.ui.swt.uiprocess.SwtUISynchronizer;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

@UITestCase
public class SwtUISynchronizerTest
extends RienaTestCase {
    private AtomicBoolean provideDisplay;

    protected void setUp() throws Exception {
        super.setUp();
        this.provideDisplay = new AtomicBoolean(false);
    }

    public void testDelayedDisplayAsync() {
        if (!PlatformUI.isWorkbenchRunning()) {
            System.out.println("Skipping SwtUISynchronizerTest.testDelayedDisplayAsync() - requires PDEJUnit");
            return;
        }
        final MockDisplay mockDisplay = new MockDisplay();
        DummyJob job = new DummyJob();
        job.sleepTime = 4000L;
        this.provideDisplay.set(false);
        SwtUISynchronizer synchronizer = new SwtUISynchronizer(){

            public Display getDisplay() {
                return SwtUISynchronizerTest.this.provideDisplay.get() ? mockDisplay : null;
            }

            protected boolean hasDisplay() {
                return true;
            }
        };
        long start = System.currentTimeMillis();
        synchronizer.asyncExec((Runnable)job);
        long end = System.currentTimeMillis();
        SwtUISynchronizerTest.assertTrue((end - start < job.sleepTime ? 1 : 0) != 0);
        SwtUISynchronizerTest.assertFalse((boolean)job.done.get());
        Timer timer = new Timer();
        long taskDelay = 3000L;
        timer.schedule(new TimerTask(){

            public void run() {
                SwtUISynchronizerTest.this.provideDisplay.set(true);
            }
        }, taskDelay);
        start = System.currentTimeMillis();
        boolean assertCalls = false;
        try {
            assertCalls = job.latch.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        SwtUISynchronizerTest.assertTrue((boolean)assertCalls);
        SwtUISynchronizerTest.assertTrue((System.currentTimeMillis() - start >= job.sleepTime + taskDelay ? 1 : 0) != 0);
        SwtUISynchronizerTest.assertTrue((boolean)job.done.get());
        SwtUISynchronizerTest.assertEquals((int)1, (int)mockDisplay.asyncExecCalls);
    }

    public void testDelayedDisplaySync() {
        if (!PlatformUI.isWorkbenchRunning()) {
            System.out.println("Skipping SwtUISynchronizerTest.testDelayedDisplaySync() - requires PDEJunit");
            return;
        }
        final MockDisplay mockDisplay = new MockDisplay();
        DummyJob job = new DummyJob();
        job.sleepTime = 4000L;
        this.provideDisplay.set(false);
        SwtUISynchronizer synchronizer = new SwtUISynchronizer(){

            public Display getDisplay() {
                return SwtUISynchronizerTest.this.provideDisplay.get() ? mockDisplay : null;
            }

            protected boolean hasDisplay() {
                return true;
            }
        };
        job = new DummyJob();
        job.sleepTime = 4000L;
        this.provideDisplay.set(false);
        Timer timer = new Timer();
        long taskDelay = 5000L;
        timer.schedule(new TimerTask(){

            public void run() {
                SwtUISynchronizerTest.this.provideDisplay.set(true);
            }
        }, taskDelay);
        long start = System.currentTimeMillis();
        synchronizer.syncExec((Runnable)job);
        SwtUISynchronizerTest.assertTrue((System.currentTimeMillis() - start >= job.sleepTime + taskDelay ? 1 : 0) != 0);
        SwtUISynchronizerTest.assertTrue((boolean)job.done.get());
        SwtUISynchronizerTest.assertEquals((int)1, (int)mockDisplay.syncExecCalls);
    }

    public void testDelayedDisplayMultiple() {
        if (!PlatformUI.isWorkbenchRunning()) {
            System.out.println("Skipping SwtUISynchronizerTest.testDelayedDisplayMultiple() - requires PDEJunit");
            return;
        }
        final MockDisplay mockDisplay = new MockDisplay();
        this.provideDisplay.set(false);
        SwtUISynchronizer synchronizer = new SwtUISynchronizer(){

            public Display getDisplay() {
                return SwtUISynchronizerTest.this.provideDisplay.get() ? mockDisplay : null;
            }

            protected boolean hasDisplay() {
                return true;
            }
        };
        this.provideDisplay.set(false);
        Timer timer = new Timer();
        long taskDelay = 5000L;
        timer.schedule(new TimerTask(){

            public void run() {
                SwtUISynchronizerTest.this.provideDisplay.set(true);
            }
        }, taskDelay);
        ArrayList<DummyJob> jobs = new ArrayList<DummyJob>();
        DummyJob exceptionJob = new DummyJob(){

            public void run() {
                super.run();
                throw new RuntimeException();
            }
        };
        jobs.add(exceptionJob);
        synchronizer.asyncExec((Runnable)exceptionJob);
        mockDisplay.asyncExecCalls = 0;
        int i = 0;
        while (i < 25) {
            DummyJob jobI = new DummyJob();
            jobs.add(jobI);
            synchronizer.asyncExec((Runnable)jobI);
            try {
                Thread.sleep(80L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        SwtUISynchronizerTest.assertNotNull((Object)ReflectionUtils.getHidden((Object)synchronizer, (String)"displayObserver"));
        for (DummyJob dummyJob : jobs) {
            try {
                dummyJob.latch.await(2000L + taskDelay + 5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        SwtUISynchronizerTest.assertTrue((mockDisplay.asyncExecCalls > 1 ? 1 : 0) != 0);
        SwtUISynchronizerTest.assertNull((Object)ReflectionUtils.getHidden((Object)synchronizer, (String)"displayObserver"));
        for (DummyJob job : jobs) {
            SwtUISynchronizerTest.assertTrue((boolean)job.done.get());
        }
    }

    public void testSyncExec() {
        final MockDisplay mockDisplay = new MockDisplay();
        SwtUISynchronizer synchronizer = new SwtUISynchronizer(){

            public Display getDisplay() {
                return mockDisplay;
            }

            protected boolean hasDisplay() {
                return true;
            }
        };
        synchronizer.syncExec((Runnable)EasyMock.createNiceMock(Runnable.class));
        SwtUISynchronizerTest.assertEquals((int)1, (int)mockDisplay.syncExecCalls);
        SwtUISynchronizerTest.assertEquals((int)0, (int)mockDisplay.asyncExecCalls);
    }

    public void testAsyncExec() {
        final MockDisplay mockDisplay = new MockDisplay();
        SwtUISynchronizer synchronizer = new SwtUISynchronizer(){

            public Display getDisplay() {
                return mockDisplay;
            }

            protected boolean hasDisplay() {
                return true;
            }
        };
        synchronizer.asyncExec((Runnable)EasyMock.createNiceMock(Runnable.class));
        SwtUISynchronizerTest.assertEquals((int)0, (int)mockDisplay.syncExecCalls);
        SwtUISynchronizerTest.assertEquals((int)1, (int)mockDisplay.asyncExecCalls);
    }

    private static class DummyJob
    implements Runnable {
        private AtomicBoolean done = new AtomicBoolean(false);
        private long sleepTime = 0L;
        private CountDownLatch latch = new CountDownLatch(1);

        private DummyJob() {
        }

        public void run() {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.done.set(true);
            this.latch.countDown();
            System.out.println("Job done");
        }

        /* synthetic */ DummyJob(DummyJob dummyJob, DummyJob dummyJob2) {
            this();
        }
    }

    private static class MockDisplay
    extends Display {
        private int syncExecCalls = 0;
        private int asyncExecCalls = 0;

        private MockDisplay() {
        }

        public void syncExec(Runnable runnable) {
            try {
                runnable.run();
            }
            finally {
                ++this.syncExecCalls;
            }
        }

        public void asyncExec(Runnable runnable) {
            new Thread(runnable).start();
            ++this.asyncExecCalls;
        }

        protected void checkSubclass() {
        }

        protected void create(DeviceData data) {
        }

        protected void checkDevice() {
        }

        public boolean isDisposed() {
            return false;
        }
    }
}

