/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.NumericString;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.ridgets.INumericTextRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.ToStringConverterFactory;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericTextRidget
extends TextRidget
implements INumericTextRidget {
    protected static final char DECIMAL_SEPARATOR = new DecimalFormatSymbols().getDecimalSeparator();
    protected static final char GROUPING_SEPARATOR = new DecimalFormatSymbols().getGroupingSeparator();
    protected static final char MINUS_SIGN = new DecimalFormatSymbols().getMinusSign();
    protected static final char ZERO = '0';
    protected static final String ZERO_DEC = String.valueOf(String.valueOf('0')) + DECIMAL_SEPARATOR;
    private static final String MINUS_ZERO = String.valueOf(String.valueOf(MINUS_SIGN)) + '0';
    private static final String MINUS_DEC = String.valueOf(String.valueOf(MINUS_SIGN)) + DECIMAL_SEPARATOR;
    private final NumericVerifyListener verifyListener = new NumericVerifyListener();
    private final NumericModifyListener modifyListener = new NumericModifyListener();
    private final KeyListener keyListener = new NumericKeyListener();
    private final FocusListener focusListener = new NumericFocusListener();
    private boolean isSigned = true;
    private boolean isGrouping = true;
    private boolean isMarkNegative = true;
    private NegativeMarker negativeMarker;
    private int maxLength = -1;
    private int precision = -1;
    private boolean hasCustomConverter;

    public static String group(String input, boolean isGrouping, boolean isDecimal) {
        String result = input;
        int decIndex = input.indexOf(DECIMAL_SEPARATOR);
        if (isGrouping) {
            String left = decIndex == -1 ? input : input.substring(0, decIndex);
            String right = decIndex == -1 ? "" : input.substring(decIndex);
            result = String.valueOf(NumericTextRidget.group(left)) + right;
        }
        if (decIndex == -1 && isDecimal) {
            result = String.valueOf(result) + DECIMAL_SEPARATOR;
        }
        return result;
    }

    public static String ungroup(String input) {
        StringBuilder result = new StringBuilder(input.length());
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            if (ch != GROUPING_SEPARATOR) {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static String removeLeadingCruft(String input) {
        if (Pattern.matches("0+.", input) && input.endsWith(String.valueOf(DECIMAL_SEPARATOR))) {
            return ZERO_DEC;
        }
        if (MINUS_DEC.matches(input)) {
            return String.valueOf(DECIMAL_SEPARATOR);
        }
        if (Pattern.matches(String.valueOf(MINUS_SIGN) + "0+.", input) && input.endsWith(String.valueOf(DECIMAL_SEPARATOR))) {
            return ZERO_DEC;
        }
        if (String.valueOf(MINUS_SIGN).equals(input) || MINUS_ZERO.equals(input) || String.valueOf('0').equals(input)) {
            return String.valueOf('0');
        }
        StringBuilder result = new StringBuilder(input.length());
        int start = 0;
        if (input.indexOf(MINUS_SIGN) == 0) {
            result.append(MINUS_SIGN);
            ++start;
        }
        if (start < input.length() && '0' == input.charAt(start)) {
            int newStart = start + 1;
            while (newStart < input.length() && '0' == input.charAt(newStart)) {
                ++newStart;
            }
            if (newStart == input.length()) {
                result.append('0');
                if (MINUS_ZERO.equals(result.toString())) {
                    result.delete(0, 1);
                }
            } else {
                result.append(input.substring(newStart));
            }
        } else {
            result.append(input.substring(start));
        }
        return result.toString();
    }

    protected static String removeTrailingPadding(String text) {
        String result = text;
        int decSep = text.indexOf(DECIMAL_SEPARATOR);
        if (decSep != -1) {
            int index = text.length() - 1;
            char ch = result.charAt(index);
            while (index >= decSep && (ch == DECIMAL_SEPARATOR || ch == '0')) {
                result = result.substring(0, index);
                if (--index < decSep) continue;
                ch = result.charAt(index);
            }
        }
        return result;
    }

    private static String group(String input) {
        int numLength = input.length();
        boolean isNegative = input.indexOf(MINUS_SIGN) == 0;
        int groupSize = 3;
        int delta = isNegative ? -2 : -1;
        int groupCount = (numLength + delta) / groupSize;
        char[] result = new char[numLength + groupCount];
        Arrays.fill(result, '#');
        int availableChars = groupSize + 1;
        int i = result.length - 1;
        while (i > 0) {
            if (--availableChars == 0) {
                result[i] = GROUPING_SEPARATOR;
                availableChars = groupSize + 1;
            }
            --i;
        }
        i = 0;
        int j = 0;
        while (i < result.length) {
            if ('#' == result[i]) {
                result[i] = input.charAt(j);
                ++j;
            }
            ++i;
        }
        return String.valueOf(result);
    }

    public NumericTextRidget() {
        super("0");
        this.addPropertyChangeListener("text", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                NumericTextRidget.this.updateMarkNegative();
            }
        });
    }

    protected void checkNumber(String number) {
        if (!"".equals(number)) {
            BigInteger bigInteger = this.checkIsNumber(number);
            this.checkSigned(bigInteger);
            this.checkMaxLength(number);
        }
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        int style;
        super.checkUIControl(uiControl);
        AbstractSWTRidget.assertType(uiControl, Text.class);
        if (uiControl != null && ((style = ((Text)uiControl).getStyle()) & 4) == 0) {
            throw new BindingException("Text widget must be SWT.SINGLE");
        }
    }

    @Override
    protected final synchronized void addListeners(Text control) {
        control.addModifyListener((ModifyListener)this.modifyListener);
        control.addVerifyListener((VerifyListener)this.verifyListener);
        control.addKeyListener(this.keyListener);
        control.addFocusListener(this.focusListener);
        super.addListeners(control);
    }

    protected IConverter getConverter(Class<?> type, int precision) {
        if (this.hasCustomConverter) {
            return this.getValueBindingSupport().getModelToUIControlConverter();
        }
        return ToStringConverterFactory.createNumberConverter(type, precision);
    }

    protected synchronized int getPrecision() {
        return this.precision;
    }

    protected boolean isNegative(String text) {
        BigInteger value = new BigInteger(text);
        return value.compareTo(BigInteger.ZERO) < 0;
    }

    @Override
    protected final synchronized void removeListeners(Text control) {
        control.removeModifyListener((ModifyListener)this.modifyListener);
        control.removeVerifyListener((VerifyListener)this.verifyListener);
        control.removeFocusListener(this.focusListener);
        control.removeKeyListener(this.keyListener);
        super.removeListeners(control);
    }

    protected synchronized void setPrecision(int precision) {
        String newText;
        this.precision = precision;
        String oldText = this.getText();
        if (!oldText.equals(newText = this.formatFraction(oldText))) {
            this.setText(newText);
        }
    }

    @Override
    protected void setUIText(String text) {
        if (this.isDecimal() && text.length() > 0) {
            super.setUIText(this.beautifyText(text));
        } else {
            super.setUIText(text);
        }
    }

    @Override
    public void setUIControlToModelConverter(IConverter converter) {
        this.hasCustomConverter = converter != null;
        super.setUIControlToModelConverter(converter);
    }

    public final synchronized int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public synchronized String getText() {
        String result = super.getText();
        if (this.isDecimal()) {
            result = NumericTextRidget.removeTrailingPadding(result);
        }
        return result;
    }

    public synchronized boolean isGrouping() {
        return this.isGrouping;
    }

    public synchronized boolean isMarkNegative() {
        return this.isMarkNegative;
    }

    public synchronized boolean isSigned() {
        return this.isSigned;
    }

    public synchronized void setGrouping(boolean useGrouping) {
        if (this.isGrouping != useGrouping) {
            this.isGrouping = useGrouping;
            this.updateGrouping();
        }
    }

    public synchronized void setMarkNegative(boolean mustBeMarked) {
        if (this.isMarkNegative != mustBeMarked) {
            this.isMarkNegative = mustBeMarked;
            this.updateMarkNegative();
        }
    }

    public final synchronized void setMaxLength(int maxLength) {
        Assert.isLegal((maxLength > 0 ? 1 : 0) != 0, (String)("maxLength must be greater than zero: " + maxLength));
        int oldValue = this.maxLength;
        if (oldValue != maxLength) {
            this.maxLength = maxLength;
            this.firePropertyChange("maxLength", oldValue, maxLength);
        }
    }

    public final synchronized void setSigned(boolean signed) {
        if (this.isSigned != signed) {
            boolean oldValue = this.isSigned;
            this.isSigned = signed;
            this.firePropertyChange("signed", oldValue, this.isSigned);
        }
    }

    @Override
    public final synchronized void setText(String text) {
        String value = text != null ? text : "";
        this.checkNumber(value);
        super.setText(NumericTextRidget.group(NumericTextRidget.ungroup(value), this.isGrouping, this.isDecimal()));
    }

    @Override
    public synchronized void updateFromModel() {
        this.checkValue();
        super.updateFromModel();
    }

    private void beautifyText(Text control) {
        String oldText;
        String newText;
        if (control != null && !(newText = this.beautifyText(oldText = control.getText())).equals(oldText)) {
            Listener listener;
            Listener[] verifyListeners;
            Listener[] listenerArray = verifyListeners = control.getListeners(25);
            int n = verifyListeners.length;
            int n2 = 0;
            while (n2 < n) {
                listener = listenerArray[n2];
                control.removeListener(25, listener);
                ++n2;
            }
            this.stopModifyListener();
            control.setText(newText);
            control.setSelection(newText.length());
            this.startModifyListener();
            listenerArray = verifyListeners;
            n = verifyListeners.length;
            n2 = 0;
            while (n2 < n) {
                listener = listenerArray[n2];
                control.addListener(25, listener);
                ++n2;
            }
        }
    }

    private String beautifyText(String text) {
        if (String.valueOf(DECIMAL_SEPARATOR).equals(text)) {
            return text;
        }
        String newText = this.formatFraction(text);
        if (newText.length() > 1 && newText.charAt(0) == DECIMAL_SEPARATOR) {
            newText = "0" + newText;
        } else if (newText.startsWith(MINUS_DEC)) {
            boolean hasValue = false;
            int i = 0;
            while (!hasValue && i < newText.length()) {
                char ch = newText.charAt(i);
                hasValue = Character.isDigit(ch) && ch != '0';
                ++i;
            }
            newText = hasValue ? String.valueOf(newText.substring(0, 1)) + "0" + newText.substring(1) : "0" + newText.substring(1);
        }
        return newText;
    }

    private BigInteger checkIsNumber(String number) {
        try {
            return new BigInteger(NumericTextRidget.ungroup(number));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Not a valid number: " + number);
        }
    }

    private void checkMaxLength(String number) {
        if (this.maxLength == -1) {
            return;
        }
        int length = number.length() - StringUtils.count((String)number, (char)GROUPING_SEPARATOR);
        if (number.length() > 0 && number.charAt(0) == MINUS_SIGN) {
            --length;
        }
        if (this.maxLength < length) {
            String msg = String.format("Length (%d) exceeded: %s", this.maxLength, number);
            throw new NumberFormatException(msg);
        }
    }

    private void checkSigned(BigInteger value) {
        if (!this.isSigned() && value.compareTo(BigInteger.ZERO) == -1) {
            throw new NumberFormatException("Negative numbers not allowed: " + value);
        }
    }

    private void checkValue() {
        IObservableValue modelObservable = this.getValueBindingSupport().getModelObservable();
        if (modelObservable == null) {
            return;
        }
        Object value = modelObservable.getValue();
        Class type = (Class)modelObservable.getValueType();
        if (type == null) {
            return;
        }
        IConverter converter = this.getConverter(type, Integer.MAX_VALUE);
        if (converter != null) {
            this.checkNumber((String)converter.convert(value));
        }
    }

    private void startModifyListener() {
        this.modifyListener.setEnabled(true);
    }

    private void startVerifyListener() {
        this.verifyListener.setEnabled(true);
    }

    private synchronized String createPattern(String input) {
        String result;
        if (this.isDecimal()) {
            String decSep = DECIMAL_SEPARATOR == '.' ? "\\." : String.valueOf(DECIMAL_SEPARATOR);
            result = String.format("\\d{0,%d}%s\\d{0,%d}", this.getMaxLength(), decSep, this.getPrecision());
            if (this.isSigned) {
                result = String.valueOf(String.format("%c?", Character.valueOf(MINUS_SIGN))) + result;
            }
        } else {
            int length = this.getMaxLength() == -1 ? input.length() : this.getMaxLength();
            result = this.isSigned ? String.format("%c?\\d{0,%d}", Character.valueOf(MINUS_SIGN), length) : String.format("\\d{0,%d}", length);
        }
        return result;
    }

    private String formatFraction(String text) {
        String result = text;
        int decSep = text.indexOf(DECIMAL_SEPARATOR);
        if (decSep != -1) {
            int prec;
            int fractionDigits = text.substring(decSep).length() - 1;
            if (fractionDigits < (prec = this.getPrecision())) {
                int pad = Math.max(0, this.getPrecision() - fractionDigits);
                if (pad > 0) {
                    char[] zeroes = new char[pad];
                    Arrays.fill(zeroes, '0');
                    result = String.valueOf(text) + String.valueOf(zeroes);
                }
            } else if (fractionDigits > prec) {
                int diff = fractionDigits - prec;
                result = text.substring(0, text.length() - diff);
            }
        }
        return result;
    }

    private boolean isDecimal() {
        return this.getPrecision() != -1;
    }

    private void stopModifyListener() {
        this.modifyListener.setEnabled(false);
    }

    private void stopVerifyListener() {
        this.verifyListener.setEnabled(false);
    }

    private void updateGrouping() {
        this.setText(this.getText());
    }

    private void updateMarkNegative() {
        String text = NumericTextRidget.ungroup(this.getText());
        boolean needMarker = false;
        if (this.isMarkNegative()) {
            try {
                needMarker = this.isNegative(text);
            }
            catch (NumberFormatException numberFormatException) {
                needMarker = false;
            }
        }
        if (needMarker) {
            if (this.negativeMarker == null) {
                this.negativeMarker = new NegativeMarker();
            }
            this.addMarker((IMarker)this.negativeMarker);
        } else if (this.negativeMarker != null) {
            this.removeMarker((IMarker)this.negativeMarker);
        }
    }

    private final class NumericFocusListener
    extends FocusAdapter {
        private NumericFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            if (NumericTextRidget.this.isDecimal()) {
                Text control = (Text)e.widget;
                NumericTextRidget.this.beautifyText(control);
            }
        }
    }

    private final class NumericKeyListener
    extends KeyAdapter {
        private boolean shiftDown = false;

        private NumericKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (131072 == e.keyCode) {
                this.shiftDown = false;
            }
        }

        public void keyPressed(KeyEvent e) {
            String newText;
            Text control = (Text)e.widget;
            String text = control.getText();
            if (131072 == e.keyCode) {
                this.shiftDown = true;
            } else if (0x1000003 == e.keyCode && control.getSelectionCount() == 0) {
                int index = control.getCaretPosition() - 1;
                if (index > 1 && GROUPING_SEPARATOR == text.charAt(index) && !this.shiftDown) {
                    e.doit = false;
                    control.setSelection(index - 1);
                }
            } else if (0x1000004 == e.keyCode && control.getSelectionCount() == 0) {
                int index = control.getCaretPosition() + 1;
                if (index < text.length() - 1 && GROUPING_SEPARATOR == text.charAt(index) && !this.shiftDown) {
                    e.doit = false;
                    control.setSelection(index + 1);
                }
            } else if (DECIMAL_SEPARATOR == e.character) {
                e.doit = false;
                int index = control.getCaretPosition();
                if (index < text.length() && text.charAt(index) == DECIMAL_SEPARATOR) {
                    control.setSelection(index + 1);
                } else {
                    NumericTextRidget.this.flash();
                }
            } else if (MINUS_SIGN == e.character) {
                e.doit = false;
                if (NumericTextRidget.this.isSigned()) {
                    Event event = new Event();
                    event.type = 25;
                    event.character = MINUS_SIGN;
                    event.start = 0;
                    event.end = 0;
                    event.widget = control;
                    event.text = String.valueOf(MINUS_SIGN);
                    control.notifyListeners(25, event);
                    if (event.doit) {
                        int caret = control.getCaretPosition() + 1;
                        NumericTextRidget.this.stopVerifyListener();
                        control.setText(String.valueOf(MINUS_SIGN) + text);
                        control.setSelection(caret);
                        NumericTextRidget.this.startVerifyListener();
                    } else {
                        NumericTextRidget.this.flash();
                    }
                } else {
                    NumericTextRidget.this.flash();
                }
            } else if ('\r' == e.character && NumericTextRidget.this.isDecimal() && !(newText = NumericTextRidget.this.formatFraction(text)).equals(text)) {
                NumericTextRidget.this.stopVerifyListener();
                control.setText(newText);
                control.setSelection(newText.length());
                NumericTextRidget.this.startVerifyListener();
            }
        }
    }

    private final class NumericModifyListener
    implements ModifyListener {
        private boolean isEnabled = true;

        private NumericModifyListener() {
        }

        public synchronized void setEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public synchronized void modifyText(ModifyEvent e) {
            if (!this.isEnabled || !NumericTextRidget.this.isEnabled()) {
                return;
            }
            Text control = (Text)e.widget;
            String oldText = control.getText();
            boolean isDecimal = NumericTextRidget.this.isDecimal();
            String newText = NumericTextRidget.group(NumericTextRidget.removeLeadingCruft(NumericTextRidget.ungroup(oldText)), NumericTextRidget.this.isGrouping(), isDecimal);
            if (NumericTextRidget.this.isOutputOnly() && newText.equals(String.valueOf(DECIMAL_SEPARATOR))) {
                newText = "";
            }
            if (isDecimal && newText.startsWith(String.valueOf(DECIMAL_SEPARATOR)) && newText.length() > 1) {
                newText = String.valueOf('0') + newText;
            }
            if (!oldText.equals(newText)) {
                NumericTextRidget.this.stopVerifyListener();
                int posFromRight = oldText.length() - control.getCaretPosition();
                control.setText(newText);
                int caretPos = newText.length() - posFromRight;
                control.setSelection(caretPos);
                NumericTextRidget.this.startVerifyListener();
            }
        }
    }

    private final class NumericVerifyListener
    implements VerifyListener {
        private boolean isEnabled = true;

        private NumericVerifyListener() {
        }

        public synchronized void setEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public synchronized void verifyText(VerifyEvent e) {
            if (!e.doit || !this.isEnabled) {
                return;
            }
            Text control = (Text)e.widget;
            String oldText = control.getText();
            String newText = null;
            int newCursorPos = -1;
            boolean applyText = false;
            if (Character.isDigit(e.character) || MINUS_SIGN == e.character) {
                boolean preserveDecSep;
                boolean bl = preserveDecSep = oldText.substring(e.start, e.end).indexOf(DECIMAL_SEPARATOR) != -1;
                if (preserveDecSep) {
                    newText = oldText.charAt(e.start) == DECIMAL_SEPARATOR && oldText.length() > e.end - e.start ? String.valueOf(oldText.substring(0, e.start)) + DECIMAL_SEPARATOR + e.character + oldText.substring(e.end) : String.valueOf(oldText.substring(0, e.start)) + e.character + DECIMAL_SEPARATOR + oldText.substring(e.end);
                    applyText = true;
                } else {
                    newText = String.valueOf(oldText.substring(0, e.start)) + e.character + oldText.substring(e.end);
                }
            } else if ('\b' == e.character || 127 == e.keyCode) {
                NumericString ns = new NumericString(oldText, NumericTextRidget.this.isGrouping());
                newCursorPos = ns.delete(e.start, e.end, e.character);
                newText = ns.toString();
                applyText = true;
            }
            boolean doFlash = true;
            if (newText != null) {
                String newTextNoGroup = NumericTextRidget.ungroup(newText);
                String regex = NumericTextRidget.this.createPattern(newTextNoGroup);
                e.doit = Pattern.matches(regex, newTextNoGroup);
                boolean bl = doFlash = !e.doit;
                if (e.doit && applyText) {
                    e.doit = false;
                    NumericTextRidget.this.stopVerifyListener();
                    this.setTextAndCursor(control, newTextNoGroup, newCursorPos, e);
                    NumericTextRidget.this.startVerifyListener();
                }
            } else {
                e.doit = false;
            }
            if (doFlash) {
                NumericTextRidget.this.flash();
            }
        }

        private void setTextAndCursor(Text control, String text, int cursorPos, VerifyEvent e) {
            String oldText = control.getText();
            int oldCursorPos = control.getCaretPosition();
            control.setText(text);
            if (text.length() > 0 && text.charAt(0) == DECIMAL_SEPARATOR && control.getText().startsWith(String.valueOf('0'))) {
                control.setSelection(1);
            } else if (oldCursorPos != 0 && text.length() == 1 && text.charAt(0) == DECIMAL_SEPARATOR) {
                control.setSelection(0);
            } else if (text.length() == 2 && text.charAt(1) == DECIMAL_SEPARATOR) {
                control.setSelection(1);
            } else if (cursorPos > -1) {
                control.setSelection(cursorPos);
            } else {
                int posFromRight = oldText.length() - e.end;
                control.setSelection(control.getText().length() - posFromRight);
            }
        }
    }
}

