/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractItemProperties;
import org.eclipse.riena.internal.ui.ridgets.swt.ToolItemRidget;
import org.eclipse.riena.ui.ridgets.swt.MenuManagerHelper;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolItemProperties
extends AbstractItemProperties {
    private ToolBar parent;
    private List<String> prevSiblingIds;
    private Image hotImage;
    private Image disabledImage;

    public ToolItemProperties(ToolItemRidget ridget) {
        super(ridget);
        ToolItem item = ridget.getUIControl();
        this.parent = item.getParent();
        this.hotImage = item.getHotImage();
        this.disabledImage = item.getDisabledImage();
        this.storePreviousSiblings(item);
    }

    private void storePreviousSiblings(ToolItem item) {
        int index = this.parent.indexOf(item);
        ToolItem[] siblings = this.parent.getItems();
        this.prevSiblingIds = new ArrayList<String>();
        int i = 0;
        while (i < index) {
            this.prevSiblingIds.add(SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)siblings[i]));
            ++i;
        }
    }

    private int getIndex() {
        int index = 0;
        ToolItem[] siblings = this.parent.getItems();
        int i = 0;
        while (i < siblings.length) {
            String id = SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)siblings[i]);
            if (this.prevSiblingIds.contains(id)) {
                ++index;
            }
            ++i;
        }
        return index;
    }

    protected ToolItemRidget getRidget() {
        return (ToolItemRidget)super.getRidget();
    }

    protected ToolItem createItem() {
        ToolItem toolItem;
        IContributionItem contributionItem = this.getContributionItem();
        MenuManager menuManager = this.getMenuManager();
        if (contributionItem != null && menuManager == null) {
            contributionItem.fill(this.parent, this.getIndex());
            toolItem = this.parent.getItem(this.getIndex());
            toolItem.setEnabled(true);
            this.setAllProperties((Item)toolItem, false);
            contributionItem.update();
        } else {
            toolItem = new ToolItem(this.parent, this.getStyle(), this.getIndex());
            this.setAllProperties((Item)toolItem, true);
            if (menuManager != null) {
                toolItem.setData((Object)menuManager);
                MenuManagerHelper helper = new MenuManagerHelper();
                helper.addListeners(toolItem, menuManager.getMenu());
            }
        }
        this.getRidget().setUIControl(toolItem);
        return toolItem;
    }

    protected void setAllProperties(Item item, boolean addListeners) {
        super.setAllProperties(item, addListeners);
        ToolItem toolItem = (ToolItem)item;
        if (this.hotImage == null || !this.hotImage.isDisposed()) {
            toolItem.setHotImage(this.hotImage);
        }
        if (this.disabledImage == null || !this.disabledImage.isDisposed()) {
            toolItem.setDisabledImage(this.disabledImage);
        }
    }

    private MenuManager getMenuManager() {
        IContributionItem contributionItem = this.getContributionItem();
        if (contributionItem instanceof MenuManager) {
            return (MenuManager)contributionItem;
        }
        return null;
    }
}

