/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.riena.internal.ui.ridgets.swt.ColumnUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.TableComparator;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeRidget;
import org.eclipse.riena.ui.common.ISortableByColumn;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.IGroupedTreeTableRidget;
import org.eclipse.riena.ui.ridgets.swt.ColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.SortableComparator;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTableRidget
extends TreeRidget
implements IGroupedTreeTableRidget {
    private static final Listener GROUPED_ITEM_ERASER = new GroupedTableEraseListener();
    private final ColumnSortListener sortListener = new ColumnSortListener();
    private boolean isSortedAscending = true;
    private int sortedColumn = -1;
    private final Map<Integer, Boolean> sortableColumnsMap = new HashMap<Integer, Boolean>();
    private final Map<Integer, Comparator<Object>> comparatorMap = new HashMap<Integer, Comparator<Object>>();
    private final Map<Integer, IColumnFormatter> formatterMap = new HashMap<Integer, IColumnFormatter>();
    private ColumnLayoutData[] columnWidths;
    private boolean isGroupingEnabled;

    @Override
    protected void bindUIControl() {
        super.bindUIControl();
        Tree control = this.getUIControl();
        if (control != null) {
            TreeColumn[] treeColumnArray = control.getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                column.addSelectionListener((SelectionListener)this.sortListener);
                ++n2;
            }
            this.applyComparator();
            this.applyGrouping();
        }
    }

    @Override
    protected void unbindUIControl() {
        super.unbindUIControl();
        Tree control = this.getUIControl();
        if (control != null) {
            TreeColumn[] treeColumnArray = control.getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                column.removeSelectionListener((SelectionListener)this.sortListener);
                ++n2;
            }
            SWTFacade facade = SWTFacade.getDefault();
            facade.removeEraseItemListener(control, GROUPED_ITEM_ERASER);
        }
    }

    @Override
    protected IColumnFormatter[] getColumnFormatters(int numColumns) {
        Assert.isLegal((numColumns >= 0 ? 1 : 0) != 0);
        IColumnFormatter[] result = new IColumnFormatter[numColumns];
        int i = 0;
        while (i < numColumns) {
            IColumnFormatter columnFormatter = this.formatterMap.get(i);
            if (columnFormatter != null) {
                result[i] = columnFormatter;
            }
            ++i;
        }
        return result;
    }

    @Override
    protected void applyColumnWidths(Tree control) {
        ColumnUtils.applyColumnWidths(control, this.columnWidths);
    }

    public void bindToModel(Object[] treeRoots, Class<? extends Object> treeElementClass, String childrenAccessor, String parentAccessor, String[] valueAccessors, String[] columnHeaders) {
        String noEnablementAccessor = null;
        String noVisibilityAccessor = null;
        String noImageAccessor = null;
        String noOpenImageAccessor = null;
        super.bindToModel(treeRoots, treeElementClass, childrenAccessor, parentAccessor, valueAccessors, columnHeaders, noEnablementAccessor, noVisibilityAccessor, noImageAccessor, noOpenImageAccessor);
    }

    public boolean isGroupingEnabled() {
        return this.isGroupingEnabled;
    }

    public void setGroupingEnabled(boolean grouping) {
        boolean oldValue = this.isGroupingEnabled;
        this.isGroupingEnabled = grouping;
        if (oldValue != this.isGroupingEnabled) {
            this.firePropertyChange("groupingEnabled", oldValue, this.isGroupingEnabled);
            this.applyGrouping();
        }
    }

    public int getSortedColumn() {
        boolean isSorted = this.sortedColumn != -1 && this.isColumnSortable(this.sortedColumn);
        return isSorted ? this.sortedColumn : -1;
    }

    public boolean isColumnSortable(int columnIndex) {
        this.checkColumnRange(columnIndex);
        boolean result = false;
        Integer key = columnIndex;
        Boolean sortable = this.sortableColumnsMap.get(columnIndex);
        if (sortable == null || Boolean.TRUE.equals(sortable)) {
            result = this.comparatorMap.get(key) != null;
        }
        return result;
    }

    public boolean isSortedAscending() {
        return this.getSortedColumn() != -1 && this.isSortedAscending;
    }

    public void setColumnSortable(int columnIndex, boolean sortable) {
        this.checkColumnRange(columnIndex);
        Integer key = columnIndex;
        Boolean newValue = sortable;
        Boolean oldValue = this.sortableColumnsMap.put(key, newValue);
        if (oldValue == null) {
            oldValue = Boolean.TRUE;
        }
        if (!newValue.equals(oldValue)) {
            this.firePropertyChange("columnSortability", null, columnIndex);
        }
    }

    public void setColumnWidths(Object[] widths) {
        this.columnWidths = ColumnUtils.copyWidths(widths);
        Tree control = this.getUIControl();
        if (control != null) {
            this.applyColumnWidths(control);
        }
    }

    public void setComparator(int columnIndex, Comparator<Object> compi) {
        this.checkColumnRange(columnIndex);
        Integer key = columnIndex;
        if (compi != null) {
            this.comparatorMap.put(key, compi);
        } else {
            this.comparatorMap.remove(key);
        }
        if (columnIndex == this.sortedColumn) {
            this.applyComparator();
        }
    }

    public void setSortedAscending(boolean ascending) {
        if (this.isSortedAscending != ascending) {
            boolean oldSortedAscending = this.isSortedAscending;
            this.isSortedAscending = ascending;
            this.applyComparator();
            this.firePropertyChange("sortAscending", oldSortedAscending, this.isSortedAscending);
        }
    }

    public void setSortedColumn(int columnIndex) {
        if (columnIndex != -1) {
            this.checkColumnRange(columnIndex);
        }
        if (this.sortedColumn != columnIndex) {
            int oldSortedColumn = this.sortedColumn;
            this.sortedColumn = columnIndex;
            this.applyComparator();
            this.firePropertyChange("sortedColumn", oldSortedColumn, this.sortedColumn);
        }
    }

    public void setColumnFormatter(int columnIndex, IColumnFormatter formatter) {
        this.checkColumnRange(columnIndex);
        if (formatter != null) {
            Assert.isLegal((boolean)(formatter instanceof ColumnFormatter), (String)"formatter must sublass ColumnFormatter");
        }
        Integer key = columnIndex;
        this.formatterMap.put(key, formatter);
    }

    private void applyComparator() {
        TreeViewer viewer = this.getViewer();
        if (viewer != null) {
            Tree tree = viewer.getTree();
            tree.setRedraw(false);
            try {
                Comparator<Object> compi = null;
                if (this.sortedColumn != -1) {
                    Integer key = this.sortedColumn;
                    compi = this.comparatorMap.get(key);
                }
                if (compi != null) {
                    TreeColumn column = tree.getColumn(this.sortedColumn);
                    tree.setSortColumn(column);
                    int direction = this.isSortedAscending ? 128 : 1024;
                    tree.setSortDirection(direction);
                    SortableComparator sortableComparator = new SortableComparator((ISortableByColumn)this, compi);
                    viewer.setComparator((ViewerComparator)new TableComparator(sortableComparator));
                } else {
                    viewer.setComparator(null);
                    tree.setSortColumn(null);
                    tree.setSortDirection(0);
                }
                viewer.refresh();
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }

    private void applyGrouping() {
        Tree control = this.getUIControl();
        if (control != null) {
            control.setRedraw(false);
            try {
                SWTFacade facade = SWTFacade.getDefault();
                facade.removeEraseItemListener(control, GROUPED_ITEM_ERASER);
                if (this.isGroupingEnabled) {
                    facade.addEraseItemListener(control, GROUPED_ITEM_ERASER);
                }
            }
            finally {
                control.setRedraw(true);
                control.redraw();
            }
        }
    }

    private void checkColumnRange(int columnIndex) {
        Tree tree = this.getUIControl();
        int range = tree.getColumnCount();
        String msg = "columnIndex out of range (0 - " + range + " ): " + columnIndex;
        Assert.isLegal((-1 < columnIndex ? 1 : 0) != 0, (String)msg);
        Assert.isLegal((columnIndex < range ? 1 : 0) != 0, (String)msg);
    }

    private final class ColumnSortListener
    extends SelectionAdapter {
        private ColumnSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TreeColumn column = (TreeColumn)e.widget;
            int columnIndex = column.getParent().indexOf(column);
            int direction = column.getParent().getSortDirection();
            if (columnIndex == TreeTableRidget.this.sortedColumn) {
                if (direction == 128) {
                    TreeTableRidget.this.setSortedAscending(false);
                } else if (direction == 1024) {
                    TreeTableRidget.this.setSortedColumn(-1);
                }
            } else if (TreeTableRidget.this.isColumnSortable(columnIndex)) {
                TreeTableRidget.this.setSortedColumn(columnIndex);
                if (direction == 0) {
                    TreeTableRidget.this.setSortedAscending(true);
                }
            }
            column.getParent().showSelection();
        }
    }

    private static final class GroupedTableEraseListener
    implements Listener {
        private GroupedTableEraseListener() {
        }

        public void handleEvent(Event event) {
            TreeItem item = (TreeItem)event.item;
            if (item.getItemCount() == 0 || event.index == 0) {
                return;
            }
            event.detail &= 0xFFFFFFEF;
        }
    }
}

