/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.ClassRidgetMapper;
import org.eclipse.riena.ui.ridgets.IComplexRidget;
import org.eclipse.riena.ui.ridgets.IRidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompositeRidget
extends AbstractRidget
implements IComplexRidget {
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    private final Map<String, IRidget> ridgets = new HashMap<String, IRidget>();
    private Object uiControl;
    private boolean markedHidden;
    private boolean enabled = true;
    private String toolTip = null;

    @Override
    public void addRidget(String id, IRidget ridget) {
        ridget.addPropertyChangeListener(this.propertyChangeListener);
        this.ridgets.put(id, ridget);
    }

    @Override
    public void configureRidgets() {
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public IRidget getRidget(String id) {
        return this.ridgets.get(id);
    }

    @Override
    public <R extends IRidget> R getRidget(Class<R> ridgetClazz, String id) {
        IRidget ridget = this.getRidget(id);
        if (ridget != null) {
            return (R)ridget;
        }
        if (RienaStatus.isTest()) {
            try {
                if (ridgetClazz.isInterface() || Modifier.isAbstract(ridgetClazz.getModifiers())) {
                    Class<? extends IRidget> mappedRidgetClazz = ClassRidgetMapper.getInstance().getRidgetClass(ridgetClazz);
                    if (mappedRidgetClazz != null) {
                        ridget = mappedRidgetClazz.newInstance();
                    }
                    Assert.isNotNull((Object)ridget, (String)("Could not find a corresponding implementation for " + ridgetClazz.getName() + " in " + ClassRidgetMapper.class.getName()));
                } else {
                    ridget = (IRidget)ridgetClazz.newInstance();
                }
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            this.addRidget(id, ridget);
        }
        return (R)ridget;
    }

    @Override
    public Collection<? extends IRidget> getRidgets() {
        return new ArrayList<IRidget>(this.ridgets.values());
    }

    @Override
    public String getToolTipText() {
        return this.toolTip;
    }

    @Override
    public Object getUIControl() {
        return this.uiControl;
    }

    @Override
    public boolean hasFocus() {
        Collection<? extends IRidget> myRidgets = this.getRidgets();
        for (IRidget iRidget : myRidgets) {
            if (!iRidget.hasFocus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isFocusable() {
        for (IRidget iRidget : this.getRidgets()) {
            if (!iRidget.isFocusable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        if (this.markedHidden) {
            return false;
        }
        if (this.getUIControl() != null) {
            return this.isUIControlVisible();
        }
        return this.savedVisibleState;
    }

    @Override
    public void requestFocus() {
        if (!this.getRidgets().isEmpty()) {
            this.getRidgets().iterator().next().requestFocus();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.updateEnabled();
        }
    }

    @Override
    public void setFocusable(boolean focusable) {
        for (IRidget iRidget : this.getRidgets()) {
            iRidget.setFocusable(focusable);
        }
    }

    @Override
    public void setToolTipText(String toolTipText) {
        String oldValue = this.toolTip;
        this.toolTip = toolTipText;
        this.updateToolTipText();
        this.firePropertyChange("tooltip", oldValue, this.toolTip);
    }

    @Override
    public void setUIControl(Object uiControl) {
        this.checkUIControl(uiControl);
        this.unbindUIControl();
        this.savedVisibleState = this.getUIControl() != null ? this.isUIControlVisible() : this.savedVisibleState;
        this.uiControl = uiControl;
        this.updateVisible();
        this.updateEnabled();
        this.updateToolTipText();
        this.bindUIControl();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.markedHidden == visible) {
            this.markedHidden = !visible;
            this.updateVisible();
        }
    }

    protected void bindUIControl() {
    }

    protected void checkUIControl(Object uiControl) {
    }

    @Override
    public void updateFromModel() {
        super.updateFromModel();
        for (IRidget ridget : this.ridgets.values()) {
            ridget.updateFromModel();
        }
    }

    protected final boolean isMarkedHidden() {
        return this.markedHidden;
    }

    protected boolean isUIControlVisible() {
        return true;
    }

    protected final void removeRidgets() {
        this.ridgets.clear();
    }

    protected void unbindUIControl() {
    }

    protected void updateEnabled() {
    }

    protected void updateToolTipText() {
    }

    protected void updateVisible() {
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractCompositeRidget.this.propertyChangeSupport.firePropertyChange(evt);
        }
    }
}

