/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.ui.core.context.IContext;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IDefaultActionManager;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.controller.IController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWindowController
implements IController,
IContext {
    public static final String RIDGET_ID_WINDOW = "windowRidget";
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private final Map<String, IRidget> ridgets = new HashMap<String, IRidget>();
    private final Map<String, Object> context = new HashMap<String, Object>();
    private IWindowRidget windowRidget;
    private boolean blocked;
    private int returnCode;
    private IDefaultActionManager actionManager;

    public void addDefaultAction(IRidget focusRidget, IActionRidget action) {
        this.actionManager = this.getWindowRidget().addDefaultAction(focusRidget, action);
    }

    @Override
    public void addRidget(String id, IRidget ridget) {
        this.ridgets.put(id, ridget);
    }

    @Override
    public void afterBind() {
        this.returnCode = 0;
        this.getWindowRidget().updateFromModel();
        if (this.actionManager != null) {
            this.actionManager.activate();
        }
    }

    @Override
    public void configureRidgets() {
        this.setWindowRidget((IWindowRidget)this.getRidget(RIDGET_ID_WINDOW));
    }

    public Object getContext(String key) {
        return this.context.get(key);
    }

    @Override
    public IRidget getRidget(String id) {
        return this.ridgets.get(id);
    }

    @Override
    public <R extends IRidget> R getRidget(Class<R> ridgetClazz, String id) {
        return (R)this.getRidget(id);
    }

    @Override
    public Collection<? extends IRidget> getRidgets() {
        return this.ridgets.values();
    }

    public IWindowRidget getWindowRidget() {
        return this.windowRidget;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void setContext(String key, Object value) {
        this.context.put(key, value);
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public void setWindowRidget(IWindowRidget windowRidget) {
        this.windowRidget = windowRidget;
    }
}

