/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.marker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.listener.FocusEvent;
import org.eclipse.riena.ui.ridgets.listener.IFocusListener;
import org.eclipse.riena.ui.ridgets.marker.AbstractMessageMarkerViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatuslineMessageMarkerViewer
extends AbstractMessageMarkerViewer {
    private String statuslineMessage;
    private String originalStatuslineMessage;
    private IStatuslineRidget statusline = null;
    private PropertyChangeListener markerPropertyChangeListener = new MarkerPropertyChangeListener();
    private IFocusListener ridgetFocusListener = new RidgetFocusListener();

    public StatuslineMessageMarkerViewer(IStatuslineRidget statuslineRidget) {
        this.statusline = statuslineRidget;
    }

    @Override
    public void addRidget(IBasicMarkableRidget markableRidget) {
        super.addRidget(markableRidget);
        markableRidget.addPropertyChangeListener(this.markerPropertyChangeListener);
        markableRidget.addFocusListener(this.ridgetFocusListener);
    }

    @Override
    protected void showMessages(IBasicMarkableRidget markableRidget) {
        if (markableRidget.hasFocus()) {
            Collection<IMessageMarker> messageMarker = this.getMessageMarker(markableRidget);
            String message = StatuslineMessageMarkerViewer.constructMessage(messageMarker, this.getMessageSeparator());
            Severity severity = this.getMaxSeverity(messageMarker);
            if (message.length() > 0 && this.isVisible()) {
                this.setStatuslineMessage(message, severity);
            } else {
                this.hideMessages(markableRidget);
            }
        }
    }

    @Override
    protected void hideMessages(IBasicMarkableRidget ridget) {
        if (ridget.hasFocus()) {
            this.resetStatuslineMessage();
        }
    }

    @Override
    protected String getMessageSeparator() {
        return " ";
    }

    private void setStatuslineMessage(String message, Severity severity) {
        if (this.getStatusLine() != null) {
            if (this.statuslineMessage == null) {
                this.originalStatuslineMessage = this.getStatusLine().getMessage();
            }
            switch (severity) {
                case ERROR: {
                    this.getStatusLine().error(message);
                    break;
                }
                case WARNING: {
                    this.getStatusLine().warning(message);
                    break;
                }
                case INFO: {
                    this.getStatusLine().info(message);
                    break;
                }
                default: {
                    this.getStatusLine().clear();
                    this.getStatusLine().setMessage(message);
                }
            }
            this.statuslineMessage = message;
        }
    }

    private void resetStatuslineMessage() {
        if (this.getStatusLine() != null) {
            if (this.statuslineMessage != null && this.statuslineMessage.equals(this.getStatusLine().getMessage())) {
                this.getStatusLine().clear();
                this.getStatusLine().setMessage(this.originalStatuslineMessage);
            }
            this.statuslineMessage = null;
        }
    }

    private Severity getMaxSeverity(Collection<IMessageMarker> messageMarkers) {
        Severity severity = Severity.NONE;
        for (IMessageMarker messageMarker : messageMarkers) {
            if (!(messageMarker instanceof ErrorMarker) || !severity.isLower(Severity.ERROR)) continue;
            severity = Severity.ERROR;
        }
        return severity;
    }

    IStatuslineRidget getStatusLine() {
        return this.statusline;
    }

    private class MarkerPropertyChangeListener
    implements PropertyChangeListener {
        private MarkerPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("marker") && evt.getSource() instanceof IBasicMarkableRidget && ((IBasicMarkableRidget)evt.getSource()).hasFocus()) {
                StatuslineMessageMarkerViewer.this.showMessages((IBasicMarkableRidget)evt.getSource());
            }
        }
    }

    private class RidgetFocusListener
    implements IFocusListener {
        private RidgetFocusListener() {
        }

        public void focusGained(FocusEvent event) {
            if (event.getNewFocusOwner() instanceof IBasicMarkableRidget) {
                StatuslineMessageMarkerViewer.this.showMessages((IBasicMarkableRidget)event.getNewFocusOwner());
            }
        }

        public void focusLost(FocusEvent event) {
            if (event.getOldFocusOwner() instanceof IBasicMarkableRidget) {
                StatuslineMessageMarkerViewer.this.resetStatuslineMessage();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Severity {
        NONE(0),
        INFO(1),
        WARNING(2),
        ERROR(3);

        private int index;

        private Severity(int index) {
            this.index = index;
        }

        boolean isLower(Severity other) {
            return this.index < other.index;
        }
    }
}

