/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.riena.core.util.ArraysUtil;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.ui.ridgets.nls.Messages;
import org.eclipse.riena.ui.ridgets.validation.Utils;
import org.eclipse.riena.ui.ridgets.validation.ValidDecimal;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public class ValidInteger
extends ValidDecimal {
    private boolean signed;

    public ValidInteger() {
        this(Locale.getDefault());
    }

    public ValidInteger(boolean signed) {
        this(signed, Locale.getDefault());
    }

    public ValidInteger(Locale locale) {
        this(true, locale);
    }

    public ValidInteger(boolean signed, Locale locale) {
        super(true, locale);
        this.signed = signed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus validate(Object value) {
        if (value != null) {
            if (!(value instanceof String)) {
                throw new ValidationFailure("ValidCharacters can only validate objects of type String.");
            }
            String string = Utils.removeWhitespace((String)value);
            if (string.length() > 0) {
                ValidDecimal.ScanResult scanned = this.scan(string);
                if (scanned.decimalSeperatorIndex >= 0) {
                    Character decSep = Character.valueOf(this.getSymbols().getDecimalSeparator());
                    String message = NLS.bind((String)Messages.ValidInteger_error_hasDecSep, (Object)decSep, (Object)string);
                    return ValidationRuleStatus.error(true, message);
                }
                if (!this.signed && scanned.minusSignIndex > -1) {
                    String message = NLS.bind((String)Messages.ValidInteger_error_hasMinus, (Object)scanned.minusSignIndex, (Object)string);
                    return ValidationRuleStatus.error(true, message);
                }
                if (scanned.lastAlienCharIndex > -1) {
                    String message = NLS.bind((String)Messages.ValidInteger_error_alienChar, (Object)Character.valueOf(scanned.lastAlienCharacter), (Object)string);
                    return ValidationRuleStatus.error(true, message);
                }
                try {
                    DecimalFormat format;
                    DecimalFormat decimalFormat = format = this.getFormat();
                    synchronized (decimalFormat) {
                        format.parse(string);
                    }
                }
                catch (ParseException parseException) {
                    String message = NLS.bind((String)Messages.ValidInteger_error_cannotParse, (Object)string);
                    return ValidationRuleStatus.error(true, message);
                }
            }
        }
        return ValidationRuleStatus.ok();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            Object[] args = PropertiesUtils.asArray((Object)data);
            int localStart = 0;
            if (args.length > 0) {
                if (args[0].equals(Boolean.TRUE.toString())) {
                    this.signed = true;
                    localStart = 1;
                } else if (((String)args[0]).equals(Boolean.FALSE.toString())) {
                    this.signed = false;
                    localStart = 1;
                }
            }
            if (args.length > localStart) {
                String[] localArgs = (String[])ArraysUtil.copyRange((Object[])args, (int)localStart, (int)args.length);
                this.setLocal(localArgs);
            }
        }
    }
}

