/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.swt.test;

import java.util.Locale;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class UITestHelper {
    public static final int KC_ARROW_DOWN = 0x1000002;
    public static final int KC_ARROW_UP = 0x1000001;
    public static final int KC_HOME = 0x1000007;
    public static final int KC_END = 0x1000008;
    public static final int KC_DEL = 127;

    private UITestHelper() {
    }

    public static void fireSelectionEvent(Widget widget) {
        Event event = new Event();
        event.type = 13;
        event.widget = widget;
        widget.notifyListeners(13, event);
    }

    public static void readAndDispatch(Widget control) {
        Display display = control.getDisplay();
        while (display.readAndDispatch()) {
            Nop.reason((String)"keep going");
        }
    }

    public static void sendKeyAction(Display display, int keyCode) {
        EventSender sender = new EventSender(display, keyCode);
        UITestHelper.send(display, sender);
    }

    public static void sendString(Display display, String message) {
        EventSender sender = new EventSender(display, message);
        UITestHelper.send(display, sender);
    }

    private static void send(Display display, Runnable runnable) {
        Thread thread = new Thread(runnable);
        Shell activeShell = display.getActiveShell();
        if (activeShell != null) {
            activeShell.forceActive();
        }
        thread.start();
        UITestHelper.waitAndDispatch(display, thread);
    }

    private static void waitAndDispatch(Display display, Thread thread) {
        Shell shell = display.getActiveShell();
        while (!shell.isDisposed() && thread.isAlive()) {
            try {
                display.readAndDispatch();
            }
            catch (SWTException exc) {
                if (exc.toString().contains("Workbench has not been created yet.")) continue;
                throw exc;
            }
        }
    }

    private static class EventSender
    implements Runnable {
        private static final int MS_SHORT_WAIT = 10;
        private static final int MS_LONG_WAIT = 250;
        private final Display display;
        private final int keyCode;
        private final String message;
        private final SWTFacade swtFacade;

        EventSender(Display display, int keyCode) {
            this.display = display;
            this.keyCode = keyCode;
            this.message = null;
            this.swtFacade = SWTFacade.getDefault();
        }

        EventSender(Display display, String message) {
            this.display = display;
            this.keyCode = 0;
            this.message = message;
            this.swtFacade = SWTFacade.getDefault();
        }

        public void run() {
            if (this.message != null) {
                this.sendMessage();
            } else {
                this.sendKeyEvent();
            }
        }

        private void sendMessage() {
            int i = 0;
            while (i < this.message.length()) {
                char ch = this.message.charAt(i);
                boolean isShift = this.doShift(ch);
                if (isShift) {
                    this.postShift(true);
                }
                this.postCharacter(ch);
                if (isShift) {
                    this.postShift(false);
                }
                ++i;
            }
        }

        private boolean doShift(char ch) {
            boolean result = false;
            if (Character.isLetter(ch)) {
                result = Character.isUpperCase(ch);
            } else if (ch == '/' && "US" != Locale.getDefault().getCountry()) {
                result = true;
            }
            return result;
        }

        private void sendKeyEvent() {
            Event event = new Event();
            event.type = 1;
            event.keyCode = this.keyCode;
            this.doSleep(250);
            this.post(event);
            this.doSleep(250);
            event.type = 2;
            this.post(event);
            this.doSleep(250);
        }

        private void postCharacter(char ch) {
            Event event = new Event();
            event.type = 1;
            event.character = ch;
            this.doSleep(250);
            this.post(event);
            this.doSleep(250);
            event.type = 2;
            this.post(event);
            this.doSleep(250);
        }

        private void postShift(boolean keyDown) {
            Event event = new Event();
            event.keyCode = 131072;
            event.type = keyDown ? 1 : 2;
            this.post(event);
            this.doSleep(10);
        }

        private boolean post(Event event) {
            return this.swtFacade.postEvent(this.display, event);
        }

        private void doSleep(int millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
                Nop.reason((String)"ignore");
            }
        }
    }
}

