/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class ImageButton
extends Composite {
    private static final Point DEF_HORIZONTAL_MARGIN = new Point(0, 0);
    private static final Point DEF_HOVER_BUTTON_HORIZONTAL_MARGIN = new Point(12, 12);
    private static final int IMAGE_INDEX = 0;
    private static final int PRESSED_IMAGE_INDEX = 1;
    private static final int FOCUSED_IMAGE_INDEX = 2;
    private static final int DISABLED_IMAGE_INDEX = 3;
    private static final int HOVER_IMAGE_INDEX = 4;
    private static final int HOVER_FOCUSED_IMAGE_INDEX = 5;
    private static int idealHeight = -1;
    private Image[] images = new Image[6];
    private boolean useIdealHeight;
    private boolean pressed;
    private boolean hover;
    private boolean focused;
    private DisposeListener disposeListener;
    private PaintListener paintListener;
    private ButtonMouseListener mouseListener;
    private FocusListener focusListener;
    private TraverseListener traverseListener;
    private ButtonKeyListener keyListener;
    private Button hoverButton;
    private Point horizontalMargin;
    private List<SelectionListener> selectionListeners;

    public ImageButton(Composite parent, int style) {
        super(parent, style | 0x20000000);
        if (this.hasHotStyle()) {
            this.horizontalMargin = DEF_HOVER_BUTTON_HORIZONTAL_MARGIN;
            this.setLayout((Layout)new FormLayout());
            this.addHoverButton();
        } else {
            this.horizontalMargin = DEF_HORIZONTAL_MARGIN;
        }
        this.addListeners();
    }

    public void addSelectionListener(SelectionListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<SelectionListener>();
            TypedListener delegate = this.createSelectionDelegate();
            this.addListener(13, (Listener)delegate);
            this.addListener(14, (Listener)delegate);
        }
        this.selectionListeners.add(listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = new Point(0, 0);
        if (this.isUseIdealHeight()) {
            size.y = this.getIdealHeight();
        }
        Image[] imageArray = this.images;
        int n = this.images.length;
        int n2 = 0;
        while (n2 < n) {
            Image oneImage = imageArray[n2];
            if (oneImage != null && !oneImage.isDisposed()) {
                Rectangle bounds = oneImage.getBounds();
                size.x = Math.max(size.x, bounds.width);
                size.y = Math.max(size.y, bounds.height);
            }
            ++n2;
        }
        if (this.hoverButton != null) {
            Point btnSize = this.hoverButton.computeSize(-1, -1);
            if (size.x < btnSize.x) {
                size.x = btnSize.x;
            }
            if (size.y < btnSize.y) {
                size.y = btnSize.y;
            }
        }
        size.x += this.horizontalMargin.x;
        size.x += this.horizontalMargin.y;
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    public Image getDisabledImage() {
        return this.images[3];
    }

    public Image getFocusedImage() {
        return this.images[2];
    }

    public Point getHorizontalMargin() {
        return new Point(this.horizontalMargin.x, this.horizontalMargin.y);
    }

    public Image getHoverFocusedImage() {
        return this.images[5];
    }

    public Image getHoverImage() {
        return this.images[4];
    }

    public Image getImage() {
        return this.images[0];
    }

    public Image getPressedImage() {
        return this.images[1];
    }

    public boolean isUseIdealHeight() {
        return this.useIdealHeight;
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.selectionListeners != null) {
            this.selectionListeners.remove(listener);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.hoverButton != null) {
            this.hoverButton.setBackground(color);
        }
    }

    public void setDisabledImage(Image image) {
        this.images[3] = image;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setPressed(false);
        this.setHover(false);
        this.setFocused(false);
    }

    public void setFocusedImage(Image image) {
        this.images[2] = image;
    }

    public void setHorizontalMargin(Point horizontalMargin) {
        this.horizontalMargin = new Point(horizontalMargin.x, horizontalMargin.y);
    }

    public void setHoverFocusedImage(Image image) {
        this.images[5] = image;
    }

    public void setHoverImage(Image image) {
        this.images[4] = image;
    }

    public void setImage(Image image) {
        if (image != this.images[0]) {
            this.images[0] = image;
            this.redraw();
        }
    }

    public void setPressedImage(Image image) {
        this.images[1] = image;
    }

    public void setUseIdealHeight(boolean useIdealHeight) {
        this.useIdealHeight = useIdealHeight;
    }

    private void addHoverButton() {
        this.hoverButton = new Button((Composite)this, 8);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.hoverButton.setLayoutData((Object)data);
        this.hoverButton.setVisible(false);
    }

    private void addListeners() {
        SWTFacade swtFacade = SWTFacade.getDefault();
        this.paintListener = new PaintDelegation();
        swtFacade.addPaintListener((Control)this, (EventListener)this.paintListener);
        this.mouseListener = new ButtonMouseListener();
        this.addMouseListener(this.mouseListener);
        swtFacade.addMouseTrackListener((Control)this, this.mouseListener);
        swtFacade.addMouseMoveListener((Control)this, this.mouseListener);
        if (this.hoverButton != null) {
            this.hoverButton.addMouseListener((MouseListener)this.mouseListener);
            swtFacade.addMouseTrackListener((Control)this.hoverButton, this.mouseListener);
            swtFacade.addMouseMoveListener((Control)this.hoverButton, this.mouseListener);
        }
        this.focusListener = new ButtonFocusListener();
        this.addFocusListener(this.focusListener);
        this.keyListener = new ButtonKeyListener();
        this.addKeyListener(this.keyListener);
        this.traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = true;
            }
        };
        this.addTraverseListener(this.traverseListener);
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageButton.this.onDispose(e);
            }
        };
        this.addDisposeListener(this.disposeListener);
    }

    private Point computeImagePos(PaintEvent event, Image image) {
        int x = 0;
        int y = 0;
        if (image != null && event != null) {
            Rectangle imgBounds = image.getBounds();
            x = (event.width - imgBounds.width) / 2;
            if (x < 0) {
                x = 0;
            }
            if ((y = (event.height - imgBounds.height) / 2) < 0) {
                y = 0;
            }
            if (this.hasHotStyle() && event.height % 2 != 0) {
                ++y;
            }
        }
        return new Point(x, y);
    }

    private TypedListener createSelectionDelegate() {
        return new TypedListener((SWTEventListener)new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (SelectionListener sl : ImageButton.this.selectionListeners) {
                    sl.widgetSelected(e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                for (SelectionListener sl : ImageButton.this.selectionListeners) {
                    sl.widgetDefaultSelected(e);
                }
            }
        });
    }

    private int getIdealHeight() {
        if (idealHeight < 0) {
            Button button = new Button((Composite)this, 8);
            idealHeight = button.computeSize((int)-1, (int)-1).y;
            button.dispose();
        }
        return idealHeight;
    }

    private Image getImageToDraw() {
        Image imageToDraw = null;
        if (!this.isEnabled()) {
            imageToDraw = this.getDisabledImage();
            if (imageToDraw == null) {
                imageToDraw = this.getImage();
            }
            return imageToDraw;
        }
        if (this.isPressed()) {
            imageToDraw = this.getPressedImage();
            if (imageToDraw == null) {
                imageToDraw = this.getImage();
            }
            return imageToDraw;
        }
        if (this.isHover()) {
            if (this.isFocused()) {
                imageToDraw = this.getHoverFocusedImage();
            }
            if (imageToDraw == null) {
                imageToDraw = this.getHoverImage();
            }
            if (imageToDraw == null) {
                imageToDraw = this.getImage();
            }
            return imageToDraw;
        }
        if (this.isFocused()) {
            imageToDraw = this.getFocusedImage();
        }
        if (imageToDraw == null) {
            imageToDraw = this.getImage();
        }
        return imageToDraw;
    }

    private boolean hasHotStyle() {
        int style = this.getStyle();
        return (style & 0x20) == 32;
    }

    private boolean isFocused() {
        return this.focused;
    }

    private boolean isHover() {
        return this.hover;
    }

    private boolean isPressed() {
        return this.pressed;
    }

    private void onDispose(DisposeEvent event) {
        if (event.widget != this) {
            return;
        }
        this.removeListeners();
        Arrays.fill(this.images, null);
    }

    private void onPaint(PaintEvent event) {
        if (this.hoverButton != null && this.hoverButton.isVisible()) {
            return;
        }
        Image image = this.getImageToDraw();
        if (image != null) {
            Point pos = this.computeImagePos(event, image);
            GC gc = event.gc;
            gc.drawImage(image, pos.x, pos.y);
        }
    }

    private void removeListeners() {
        SWTFacade swtFacade = SWTFacade.getDefault();
        if (this.disposeListener != null) {
            this.removeDisposeListener(this.disposeListener);
            this.disposeListener = null;
        }
        if (this.traverseListener != null) {
            this.removeTraverseListener(this.traverseListener);
            this.traverseListener = null;
        }
        if (this.paintListener != null) {
            swtFacade.removePaintListener((Control)this, (EventListener)this.paintListener);
            this.paintListener = null;
        }
        if (this.focusListener != null) {
            this.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.mouseListener != null) {
            if (this.hoverButton != null) {
                this.hoverButton.removeMouseListener((MouseListener)this.mouseListener);
                swtFacade.removeMouseTrackListener((Control)this.hoverButton, this.mouseListener);
                swtFacade.removeMouseMoveListener((Control)this.hoverButton, this.mouseListener);
            }
            this.removeMouseListener(this.mouseListener);
            swtFacade.removeMouseTrackListener((Control)this, this.mouseListener);
            swtFacade.removeMouseMoveListener((Control)this, this.mouseListener);
            this.mouseListener = null;
        }
        if (this.keyListener != null) {
            this.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
    }

    private void setFocused(boolean focused) {
        if (this.isFocused() != focused) {
            this.focused = focused;
            this.redraw();
        }
    }

    private void setHover(boolean hover) {
        if (this.hover != hover) {
            this.hover = hover;
            this.redraw();
        }
    }

    private void setPressed(boolean pressed) {
        if (this.pressed != pressed) {
            this.pressed = pressed;
            this.redraw();
        }
    }

    private void updateHoverButton() {
        if (this.hoverButton != null) {
            boolean visible;
            boolean bl = visible = this.isHover() || this.isPressed();
            if (visible != this.hoverButton.isVisible()) {
                this.hoverButton.setVisible(visible);
            }
            if (this.hoverButton.isVisible()) {
                this.hoverButton.setImage(this.getImageToDraw());
            }
        }
    }

    private final class ButtonFocusListener
    implements FocusListener {
        private ButtonFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            ImageButton.this.setFocused(true);
            ImageButton.this.updateHoverButton();
        }

        public void focusLost(FocusEvent e) {
            ImageButton.this.setFocused(false);
            ImageButton.this.updateHoverButton();
        }
    }

    private final class ButtonKeyListener
    implements KeyListener {
        private ButtonKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (!ImageButton.this.isEnabled()) {
                return;
            }
            if (!this.ignore(e)) {
                ImageButton.this.setPressed(true);
                ImageButton.this.updateHoverButton();
            }
        }

        public void keyReleased(KeyEvent e) {
            if (!ImageButton.this.isEnabled()) {
                return;
            }
            if (!this.ignore(e)) {
                if (ImageButton.this.isPressed()) {
                    Event event = new Event();
                    ImageButton.this.notifyListeners(13, event);
                }
                ImageButton.this.setPressed(false);
                ImageButton.this.updateHoverButton();
            }
        }

        private boolean ignore(KeyEvent e) {
            return e.character != ' ';
        }
    }

    private final class ButtonMouseListener
    implements MouseListener,
    MouseTrackListener,
    MouseMoveListener {
        private ButtonMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            if (!ImageButton.this.isEnabled()) {
                return;
            }
            if (!this.ignoreMouseButton(e) && !this.ignoreWidget(e)) {
                ImageButton.this.setPressed(true);
                ImageButton.this.updateHoverButton();
            }
        }

        public void mouseEnter(MouseEvent e) {
            if (!ImageButton.this.isEnabled()) {
                return;
            }
            if (!this.ignoreWidget(e)) {
                boolean oldHover = ImageButton.this.isHover();
                ImageButton.this.setHover(true);
                if (oldHover != ImageButton.this.isHover()) {
                    ImageButton.this.updateHoverButton();
                }
            }
        }

        public void mouseExit(MouseEvent e) {
            if (!ImageButton.this.isEnabled()) {
                return;
            }
            if (!this.ignoreWidget(e)) {
                boolean oldHover = ImageButton.this.isHover();
                ImageButton.this.setHover(false);
                if (oldHover != ImageButton.this.isHover()) {
                    ImageButton.this.updateHoverButton();
                }
            }
        }

        public void mouseHover(MouseEvent e) {
        }

        public void mouseMove(MouseEvent e) {
            if (!ImageButton.this.isEnabled()) {
                return;
            }
            if (!this.ignoreWidget(e) && (e.stateMask & SWT.BUTTON_MASK) != 0) {
                boolean oldHover = ImageButton.this.isHover();
                Point point = new Point(e.x, e.y);
                if (this.isOverButton(point)) {
                    ImageButton.this.setPressed(true);
                } else {
                    ImageButton.this.setPressed(false);
                }
                if (oldHover != ImageButton.this.isHover()) {
                    ImageButton.this.updateHoverButton();
                }
            }
        }

        public void mouseUp(MouseEvent e) {
            if (!ImageButton.this.isEnabled()) {
                return;
            }
            if (!this.ignoreMouseButton(e) && !this.ignoreWidget(e)) {
                if (ImageButton.this.isPressed() && ImageButton.this.isHover() && this.isOverButton(new Point(e.x, e.y))) {
                    Event event = new Event();
                    ImageButton.this.notifyListeners(13, event);
                }
                ImageButton.this.setPressed(false);
                ImageButton.this.updateHoverButton();
            }
        }

        private boolean ignoreMouseButton(MouseEvent e) {
            return e.button != 1;
        }

        private boolean ignoreWidget(MouseEvent e) {
            if (ImageButton.this.hoverButton != null) {
                if (ImageButton.this.hoverButton.isVisible()) {
                    return e.widget != ImageButton.this.hoverButton;
                }
                return e.widget == ImageButton.this.hoverButton;
            }
            return false;
        }

        private boolean isOverButton(Point point) {
            return point.x <= ImageButton.this.getBounds().width && point.x >= 0 && point.y <= ImageButton.this.getBounds().height && point.y >= 0;
        }
    }

    private final class PaintDelegation
    implements PaintListener {
        private PaintDelegation() {
        }

        public void paintControl(PaintEvent e) {
            ImageButton.this.onPaint(e);
        }
    }
}

