/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.beans.Beans;
import java.util.EventListener;
import org.eclipse.jface.window.Window;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.swt.AbstractTitleBarMouseListener;
import org.eclipse.riena.ui.swt.LnfRendererExtension;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.ILnfRenderer;
import org.eclipse.riena.ui.swt.lnf.ILnfRendererExtension;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.AbstractTitleBarRenderer;
import org.eclipse.riena.ui.swt.lnf.renderer.DialogBorderRenderer;
import org.eclipse.riena.ui.swt.lnf.renderer.DialogTitleBarRenderer;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RienaWindowRenderer {
    private final Window dialog;
    private Composite centerComposite;
    private DialogTitleBarMouseListener mouseListener;
    private Composite topComposite;

    public RienaWindowRenderer(Window dialog) {
        this.dialog = dialog;
        if (Beans.isDesignTime() || Activator.getDefault() == null) {
            ILnfRendererExtension[] extensions = new ILnfRendererExtension[]{new LnfRendererExtension(new DialogBorderRenderer(), "Dialog.borderRenderer"), new LnfRendererExtension(new DialogTitleBarRenderer(), "Dialog.renderer")};
            LnfManager.getLnf().update(extensions);
        }
    }

    public int computeShellStyle() {
        int result = this.getShellStyle();
        if (this.isHideOsBorder()) {
            if ((result & 0x860) == 2144) {
                result &= 0xFFFFF79F;
            }
            result |= 8;
        } else {
            if ((result & 8) == 8) {
                result &= 0xFFFFFFF7;
            }
            result &= 0xFFFFF79F;
        }
        if (this.isApplicationModal()) {
            result |= 0x10000;
        } else if ((result & 0x10000) == 65536) {
            result &= 0xFFFEFFFF;
        }
        if (this.isCloseable()) {
            result |= 0x40;
        }
        if (this.isMaximizeable()) {
            result |= 0x400;
        }
        if (this.isMinimizeable()) {
            result |= 0x80;
        }
        return result;
    }

    public Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData();
        data.heightHint = 0;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public Control createContents(Composite parent) {
        int padding = 0;
        Composite contentsComposite = new Composite(parent, 0);
        contentsComposite.setLayout((Layout)new FormLayout());
        if (this.isHideOsBorder()) {
            SWTFacade.getDefault().addPaintListener((Control)contentsComposite, (EventListener)((Object)new DialogBorderPaintListener()));
            padding = this.getBorderWidth();
        }
        contentsComposite.setLayoutData((Object)new GridData(1808));
        int titleBarHeight = 0;
        this.topComposite = new Composite(contentsComposite, 0);
        if (this.isHideOsBorder()) {
            titleBarHeight = this.getTitleBarHeight();
            SWTFacade swtFacade = SWTFacade.getDefault();
            DialogTitlePaintListener titlePaintListener = new DialogTitlePaintListener(this.isCloseable(), this.isMaximizeable(), this.isMinimizeable());
            swtFacade.addPaintListener((Control)this.topComposite, (EventListener)((Object)titlePaintListener));
            this.mouseListener = new DialogTitleBarMouseListener();
            this.topComposite.addMouseListener((MouseListener)this.mouseListener);
            swtFacade.addMouseMoveListener((Control)this.topComposite, this.mouseListener);
            swtFacade.addMouseTrackListener((Control)this.topComposite, this.mouseListener);
        }
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, padding);
        formData.top = new FormAttachment(0, padding);
        formData.right = new FormAttachment(100, -padding);
        formData.bottom = new FormAttachment(0, titleBarHeight);
        this.topComposite.setLayoutData((Object)formData);
        this.centerComposite = new Composite(contentsComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.centerComposite.setLayout((Layout)layout);
        formData = new FormData();
        formData.left = new FormAttachment(0, padding);
        formData.top = new FormAttachment((Control)this.topComposite);
        formData.right = new FormAttachment(100, -padding);
        formData.bottom = new FormAttachment(100, -padding);
        this.centerComposite.setLayoutData((Object)formData);
        return contentsComposite;
    }

    public Composite getCenterComposite() {
        return this.centerComposite;
    }

    public void removeDialogTitleBarMouseListener() {
        if (this.topComposite != null && this.mouseListener != null) {
            this.topComposite.removeMouseListener((MouseListener)this.mouseListener);
            SWTFacade swtFacade = SWTFacade.getDefault();
            swtFacade.removeMouseMoveListener((Control)this.topComposite, this.mouseListener);
            swtFacade.removeMouseTrackListener((Control)this.topComposite, this.mouseListener);
            this.mouseListener.dispose();
            this.mouseListener = null;
        }
    }

    private int getBorderWidth() {
        DialogBorderRenderer borderRenderer = (DialogBorderRenderer)LnfManager.getLnf().getRenderer("Dialog.borderRenderer");
        return borderRenderer != null ? borderRenderer.getBorderWidth() : 0;
    }

    private int getTitleBarHeight() {
        DialogTitleBarRenderer titleBarRenderer = (DialogTitleBarRenderer)LnfManager.getLnf().getRenderer("Dialog.renderer");
        return titleBarRenderer != null ? titleBarRenderer.getHeight() : 0;
    }

    private boolean isApplicationModal() {
        return (this.getShellStyle() & 0x10000) == 65536;
    }

    private boolean isCloseable() {
        return (this.getShellStyle() & 0x40) == 64;
    }

    private boolean isHideOsBorder() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        return lnf.getBooleanSetting("Dialog.hideOsBorder");
    }

    private boolean isMinimizeable() {
        return (this.getShellStyle() & 0x80) == 128;
    }

    private boolean isMaximizeable() {
        return (this.getShellStyle() & 0x400) == 1024;
    }

    private int getShellStyle() {
        return (Integer)ReflectionUtils.invokeHidden((Object)this.dialog, (String)"getShellStyle", null);
    }

    private static final class DialogBorderPaintListener
    implements PaintListener {
        private DialogBorderPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            if (e.getSource() instanceof Control) {
                Control dialog = (Control)e.getSource();
                Rectangle dialogBounds = dialog.getBounds();
                Rectangle bounds = new Rectangle(0, 0, dialogBounds.width, dialogBounds.height);
                ILnfRenderer borderRenderer = LnfManager.getLnf().getRenderer("Dialog.borderRenderer");
                borderRenderer.setBounds(bounds);
                borderRenderer.paint(e.gc, null);
            }
        }
    }

    private static final class DialogTitleBarMouseListener
    extends AbstractTitleBarMouseListener {
        private DialogTitleBarMouseListener() {
        }

        protected AbstractTitleBarRenderer getTitleBarRenderer() {
            return (DialogTitleBarRenderer)LnfManager.getLnf().getRenderer("Dialog.renderer");
        }
    }

    private static final class DialogTitlePaintListener
    implements PaintListener {
        private final boolean canClose;
        private final boolean canMax;
        private final boolean canMin;

        DialogTitlePaintListener(boolean canClose, boolean canMax, boolean canMin) {
            this.canClose = canClose;
            this.canMax = canMax;
            this.canMin = canMin;
        }

        public void paintControl(PaintEvent e) {
            if (e.getSource() instanceof Control) {
                Control control = (Control)e.getSource();
                Rectangle dialogBounds = control.getBounds();
                DialogTitleBarRenderer renderer = (DialogTitleBarRenderer)LnfManager.getLnf().getRenderer("Dialog.renderer");
                renderer.setShell(control.getShell());
                Rectangle bounds = new Rectangle(0, 0, dialogBounds.width, renderer.getHeight());
                renderer.setBounds(bounds);
                renderer.setCloseable(this.canClose);
                renderer.setMaximizable(this.canMax);
                renderer.setMinimizable(this.canMin);
                renderer.paint(e.gc, control);
            }
        }
    }
}

