/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf.renderer;

import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.AbstractTitleBarRenderer;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class DialogTitleBarRenderer
extends AbstractTitleBarRenderer {
    private static final int IMAGE_TITLE_GAP = 5;
    private static final int BORDER_IMAGE_GAP = 5;
    private String[] btnImageKeys = new String[]{"Dialog.closeIcon", "Dialog.maxIcon", "Dialog.minIcon", "Dialog.restoreIcon"};
    private String[] btnHoverSelectedImageKeys = new String[]{"Dialog.closeHoverSelectedIcon", "Dialog.maxHoverSelectedIcon", "Dialog.minHoverSelectedIcon", "Dialog.restoreHoverSelectedIcon"};
    private String[] btnHoverImageKeys = new String[]{"Dialog.closeHoverIcon", "Dialog.maxHoverIcon", "Dialog.minHoverIcon", "Dialog.restoreHoverIcon"};
    private String[] btnInactiveImageKeys = new String[]{"Dialog.closeInactiveIcon", "Dialog.maxInactiveIcon", "Dialog.minInactiveIcon", "Dialog.restoreInactiveIcon"};

    protected String[] getBtnHoverImageKeys() {
        return this.btnHoverImageKeys;
    }

    protected String[] getBtnHoverSelectedImageKeys() {
        return this.btnHoverSelectedImageKeys;
    }

    protected String[] getBtnImageKeys() {
        return this.btnImageKeys;
    }

    protected String[] getBtnInactiveImageKeys() {
        return this.btnInactiveImageKeys;
    }

    protected void paintBackground(GC gc) {
        gc.setForeground(LnfManager.getLnf().getColor("DialogTitleBar.backgroundEndColor"));
        gc.setBackground(LnfManager.getLnf().getColor("DialogTitleBar.backgroundStartColor"));
        gc.fillGradientRectangle(3, 3, this.getBounds().width - 3, this.getBounds().height - 4, true);
        gc.setForeground(LnfManager.getLnf().getColor("DialogTitleBar.backgroundTopColor1"));
        gc.drawLine(0, 0, this.getBounds().width - 1, 0);
        gc.drawLine(0, 0, 0, this.getHeight() - 1);
        gc.setForeground(LnfManager.getLnf().getColor("DialogTitleBar.backgroundTopColor2"));
        gc.drawLine(1, 1, this.getBounds().width - 1, 1);
        gc.drawLine(1, 1, 1, this.getHeight() - 2);
        gc.setForeground(LnfManager.getLnf().getColor("DialogTitleBar.backgroundTopColor3"));
        gc.drawLine(2, 2, this.getBounds().width - 1, 2);
        gc.drawLine(2, 2, 2, this.getHeight() - 2);
        gc.setForeground(LnfManager.getLnf().getColor("DialogTitleBar.backgroundBottomColor1"));
        gc.drawLine(0, this.getHeight() - 3, this.getBounds().width - 1, this.getHeight() - 3);
        gc.setForeground(LnfManager.getLnf().getColor("DialogTitleBar.backgroundBottomColor2"));
        gc.drawLine(1, this.getHeight() - 4, this.getBounds().width - 1, this.getHeight() - 4);
        gc.setForeground(LnfManager.getLnf().getColor("DialogTitleBar.backgroundBottomColor3"));
        gc.drawLine(2, this.getHeight() - 5, this.getBounds().width - 1, this.getHeight() - 5);
        gc.drawLine(this.getBounds().width - 1, 0, this.getBounds().width - 1, this.getHeight() - 5);
    }

    protected Rectangle paintTitle(GC gc) {
        if (!LnfManager.getLnf().getBooleanSetting("Dialog.hideOsBorder").booleanValue()) {
            return new Rectangle(0, 0, 0, 0);
        }
        String title = this.getShell().getText();
        if (StringUtils.isEmpty((CharSequence)title)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Color fgColor = LnfManager.getLnf().getColor("Dialog.foreground");
        if (!this.isActive()) {
            fgColor = LnfManager.getLnf().getColor("Dialog.passiveForeground");
        }
        gc.setForeground(fgColor);
        Font font = LnfManager.getLnf().getFont("Dialog.font");
        gc.setFont(font);
        int textHeight = gc.getFontMetrics().getHeight();
        int y = this.getHeight() / 2 - textHeight / 2;
        y -= 2;
        int x = this.getImageBounds().x + this.getImageBounds().width + 5;
        int textWidth = SwtUtilities.calcTextWidth(gc, title);
        if (textWidth + x > this.getBounds().width) {
            textWidth = this.getBounds().width - x;
            title = SwtUtilities.clipText(gc, title, textWidth);
        }
        gc.drawText(title, x, y, true);
        return new Rectangle(x, y, textWidth, textHeight);
    }

    protected Rectangle paintImage(GC gc) {
        if (!LnfManager.getLnf().getBooleanSetting("Dialog.hideOsBorder").booleanValue()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Image image = this.getShell().getImage();
        if (image == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        int x = 5;
        int imageWidth = image.getBounds().width;
        int imageHeight = image.getBounds().height;
        int y = this.getHeight() / 2 - imageHeight / 2;
        gc.drawImage(image, x, y);
        return new Rectangle(x, y, imageWidth, imageHeight);
    }
}

