/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.cache.LRUHashMap;
import org.eclipse.riena.ui.swt.facades.GCFacade;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Widget;

public final class SwtUtilities {
    private static final String THREE_DOTS = "...";
    private static final GCFacade GC_FACADE = GCFacade.getDefault();
    private static final Map<GCString, Integer> TEXT_WIDTH_CACHE = LRUHashMap.createLRUHashMap((int)512);

    private SwtUtilities() {
        throw new Error("SwtUtilities is just a container for static methods");
    }

    public static String clipText(GC gc, String text, int maxWidth) {
        int textwidth = SwtUtilities.calcTextWidth(gc, text);
        if (textwidth <= maxWidth) {
            return text;
        }
        int threeDotsWidth = SwtUtilities.calcTextWidth(gc, THREE_DOTS);
        StringBuilder shortenedText = new StringBuilder(text);
        while (textwidth + threeDotsWidth > maxWidth && shortenedText.length() != 0) {
            shortenedText.setLength(shortenedText.length() - 1);
            textwidth = SwtUtilities.calcTextWidth(gc, shortenedText);
        }
        shortenedText.append(THREE_DOTS);
        return shortenedText.toString();
    }

    public static int calcTextWidth(GC gc, CharSequence text) {
        if (text == null) {
            return 0;
        }
        GCString lookupKey = new GCString(gc, text);
        Integer width = TEXT_WIDTH_CACHE.get(lookupKey);
        if (width == null) {
            int w = 0;
            int i = 0;
            while (i < text.length()) {
                w += SwtUtilities.calcCharWidth(gc, text.charAt(i));
                ++i;
            }
            width = w;
            TEXT_WIDTH_CACHE.put(lookupKey, width);
        }
        return width;
    }

    public static int calcCharWidth(GC gc, char ch) {
        GCString lookupKey = new GCString(gc, Character.toString(ch));
        Integer width = TEXT_WIDTH_CACHE.get(lookupKey);
        if (width == null) {
            width = GC_FACADE.getAdvanceWidth(gc, ch);
            TEXT_WIDTH_CACHE.put(lookupKey, width);
        }
        return width;
    }

    public static Color makeBrighter(Color color, float f) {
        Assert.isNotNull((Object)color);
        Assert.isTrue(((double)f >= 0.0 ? 1 : 0) != 0);
        float[] hsb = color.getRGB().getHSB();
        float h = hsb[0];
        float s = hsb[1];
        float b = hsb[2];
        b *= f;
        if (b > 1.0f) {
            b = 1.0f;
        }
        RGB rgb = new RGB(h, s, b);
        return new Color(color.getDevice(), rgb);
    }

    public static void disposeResource(Resource resource) {
        if (!SwtUtilities.isDisposed(resource)) {
            resource.dispose();
        }
    }

    public static void disposeWidget(Widget widget) {
        if (!SwtUtilities.isDisposed(widget)) {
            widget.dispose();
        }
    }

    public static boolean isDisposed(Widget widget) {
        return widget == null || widget.isDisposed();
    }

    public static boolean isDisposed(Resource resource) {
        return resource == null || resource.isDisposed();
    }

    private static final class GCString {
        private final String text;
        private final FontMetrics fontMetrics;

        private GCString(GC gc, CharSequence seq) {
            this.fontMetrics = gc.getFontMetrics();
            this.text = seq.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fontMetrics == null ? 0 : this.fontMetrics.hashCode());
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GCString other = (GCString)obj;
            if (this.fontMetrics == null ? other.fontMetrics != null : !this.fontMetrics.equals((Object)other.fontMetrics)) {
                return false;
            }
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }
    }
}

