/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sequoyah.device.common.utilities.exception.ExceptionHandler;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.manager.InstanceManager;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstanceBuilder;
import org.eclipse.sequoyah.device.framework.ui.wizard.DefaultDeviceTypeWizardPage;
import org.eclipse.sequoyah.device.framework.ui.wizard.DeviceTypeCustomWizardPageHandler;
import org.eclipse.sequoyah.device.framework.ui.wizard.IInstanceProperties;
import org.eclipse.sequoyah.device.framework.ui.wizard.InstanceBuilder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewDeviceWizard
extends Wizard
implements INewWizard {
    public static String DEFAULT_PAGE_ID = "$_default_page_$";
    private String currentDeviceTypeId;
    private DeviceTypeCustomWizardPageHandler customWizardPageHandler = new DeviceTypeCustomWizardPageHandler(this);
    private DefaultDeviceTypeWizardPage firstPage;
    private Properties properties;

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        this.setHelpAvailable(true);
    }

    public void addPages() {
        this.firstPage = new DefaultDeviceTypeWizardPage(DEFAULT_PAGE_ID);
        this.addPage((IWizardPage)this.firstPage);
        super.addPages();
    }

    public boolean performFinish() {
        this.updatePropertiesFromWizardPages();
        boolean bl = false;
        try {
            final IInstanceBuilder iInstanceBuilder = this.getProjectBuilder();
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    try {
                        InstanceManager.createProject((IDeviceType)NewDeviceWizard.this.firstPage.getDeviceType(), (IInstanceBuilder)iInstanceBuilder, (IProgressMonitor)iProgressMonitor);
                    }
                    catch (SequoyahException sequoyahException) {
                        ExceptionHandler.showException((SequoyahException)sequoyahException);
                    }
                }
            };
            this.getContainer().run(false, true, iRunnableWithProgress);
            bl = true;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        if (bl) {
            return this.customWizardPageHandler.performFinish();
        }
        return false;
    }

    public IInstanceBuilder getProjectBuilder() {
        return new InstanceBuilder(this.firstPage.getInstanceName(), this.getProperties());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public String getCurrentDeviceTypeId() {
        return this.currentDeviceTypeId;
    }

    public void setCurrentDeviceTypeId(String string) {
        this.currentDeviceTypeId = string;
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        IWizardPage iWizardPage2 = this.customWizardPageHandler.getNextPage(iWizardPage);
        this.addCustomPage(iWizardPage2);
        return iWizardPage2;
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        return this.customWizardPageHandler.getPreviousPage(iWizardPage);
    }

    private void addCustomPage(IWizardPage iWizardPage) {
        if (iWizardPage == null) {
            return;
        }
        IWizardPage[] iWizardPageArray = this.getPages();
        boolean bl = false;
        int n = 0;
        while (n < iWizardPageArray.length && !bl) {
            if (iWizardPageArray[n].equals(iWizardPage)) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            this.addPage(iWizardPage);
        }
    }

    private void updatePropertiesFromWizardPages() {
        this.properties = new Properties();
        DefaultDeviceTypeWizardPage defaultDeviceTypeWizardPage = this.firstPage;
        while (defaultDeviceTypeWizardPage != null) {
            if (defaultDeviceTypeWizardPage instanceof IInstanceProperties) {
                this.properties.putAll((Map<?, ?>)((IInstanceProperties)((Object)defaultDeviceTypeWizardPage)).getProperties());
            }
            defaultDeviceTypeWizardPage = this.getNextPage((IWizardPage)defaultDeviceTypeWizardPage);
        }
    }

    public boolean canFinish() {
        return this.firstPage.isPageComplete() && this.customWizardPageHandler.canFinish();
    }
}

