/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.qemureact;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.sequoyah.device.common.utilities.PluginUtils;
import org.eclipse.sequoyah.device.framework.model.IConnection;
import org.eclipse.sequoyah.device.framework.model.IDeviceLauncher;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.qemureact.QEmuReactPlugin;
import org.eclipse.sequoyah.device.service.start.launcher.DefaultConnection;

public class QEmuReactLauncher
implements IDeviceLauncher {
    public static final String SLASH = "\\";
    public IConnection connection = new DefaultConnection();
    public int pid = 0;

    public QEmuReactLauncher(IInstance iInstance) {
        this.connection.setHost(iInstance.getProperties().getProperty("host"));
        this.connection.setDisplay(iInstance.getProperties().getProperty("display"));
        this.connection.setPort(Integer.parseInt(iInstance.getProperties().getProperty("port")));
    }

    public int getPID() {
        return this.pid;
    }

    public void setPID(int n) {
        this.pid = n;
    }

    public String getFileId() {
        return PluginUtils.getPluginInstallationPath((Plugin)QEmuReactPlugin.getDefault()).getAbsolutePath().concat(SLASH).concat("qemu").concat(SLASH).concat("react.id");
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public String getLocation() {
        return PluginUtils.getPluginInstallationPath((Plugin)QEmuReactPlugin.getDefault()).getAbsolutePath().concat(SLASH).concat("qemu").concat(SLASH).concat("qemu-react-vnc.bat");
    }

    public String getToolArguments() {
        return "-L . -m 128 -hda ReactOS.hd -pidfile react.id -vnc " + this.connection.getStringHost();
    }

    public String getWorkingDirectory() {
        return PluginUtils.getPluginInstallationPath((Plugin)QEmuReactPlugin.getDefault()).getAbsolutePath().concat(SLASH).concat("qemu").concat(SLASH);
    }
}

