/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.stringeditor.editor.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.localization.stringeditor.datatype.CellInfo;
import org.eclipse.sequoyah.localization.stringeditor.editor.StringEditorPart;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.EditorOperation;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.Messages;

public class EditCellOperation
extends EditorOperation {
    private final String key;
    private final String column;
    private final CellInfo oldValue;
    private final CellInfo newValue;

    public EditCellOperation(String string, String string2, CellInfo cellInfo, CellInfo cellInfo2, StringEditorPart stringEditorPart) {
        super(Messages.EditCellOperation_0, stringEditorPart);
        this.key = string;
        this.column = string2;
        this.oldValue = cellInfo;
        this.newValue = cellInfo2;
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        return this.redo(iProgressMonitor, iAdaptable);
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        this.getModel().addCell(this.newValue, this.key, this.column);
        if (this.newValue != null && !this.newValue.isDirty()) {
            this.newValue.setDirty(true);
        }
        try {
            if (this.newValue == null || this.newValue != null && this.newValue.getValue() == null) {
                this.getEditorInput().removeCell(this.key, this.column);
            } else {
                this.getEditorInput().setValue(this.column, this.key, this.newValue.getValue());
            }
        }
        catch (SequoyahException sequoyahException) {
            BasePlugin.logError((String)("Error editing cell value: (" + this.column + ", " + this.key + ") =" + this.newValue != null ? this.newValue.getValue() : null), (Throwable)sequoyahException);
        }
        this.getEditor().fireDirtyPropertyChanged();
        this.getEditor().getEditorViewer().update((Object)this.getModel().getRow(this.key), null);
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        this.getModel().addCell(this.oldValue, this.key, this.column);
        try {
            if (this.oldValue != null) {
                this.oldValue.setDirty(true);
            }
            if (this.oldValue != null && this.oldValue.getValue() != null) {
                this.getEditorInput().setValue(this.column, this.key, this.oldValue.getValue());
            } else {
                this.getEditorInput().removeCell(this.key, this.column);
            }
        }
        catch (SequoyahException sequoyahException) {
            BasePlugin.logError((String)("Error undoing cell edition: (" + this.column + ", " + this.key + ") =" + this.oldValue != null ? this.oldValue.getValue() : null), (Throwable)sequoyahException);
        }
        this.getEditor().fireDirtyPropertyChanged();
        this.getEditor().getEditorViewer().update((Object)this.getModel().getRow(this.key), null);
        return Status.OK_STATUS;
    }
}

