/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.graphics;

import java.io.DataInput;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.AbstractPaintStrategy;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.IPainterContext;
import org.eclipse.sequoyah.vnc.vncviewer.network.RectHeader;

public class HexTilePaintStrategy
extends AbstractPaintStrategy {
    private static final int RAW = 1;
    private static final int BACKGROUND_SPECIFIED = 2;
    private static final int FOREGROUND_SPECIFIED = 4;
    private static final int ANY_SUBRECTS = 8;
    private static final int SUBRECTS_COLOURED = 16;
    protected int hextileBackground = 0;
    protected int hextileForeground = 0;

    public HexTilePaintStrategy(IPainterContext iPainterContext) {
        super(iPainterContext);
    }

    public void processRectangle(RectHeader rectHeader, DataInput dataInput) throws Exception {
        int n = rectHeader.getX();
        int n2 = rectHeader.getY();
        int n3 = rectHeader.getWidth();
        int n4 = rectHeader.getHeight();
        int n5 = n2;
        while (n5 < n2 + n4) {
            int n6 = Math.min(n2 + n4 - n5, 16);
            int n7 = n;
            while (n7 < n + n3) {
                int n8 = Math.min(n + n3 - n7, 16);
                this.processHextileSubrect(dataInput, n7, n5, n8, n6);
                n7 += 16;
            }
            n5 += 16;
        }
    }

    void processHextileSubrect(DataInput dataInput, int n, int n2, int n3, int n4) throws Exception {
        int n5 = dataInput.readUnsignedByte();
        if ((n5 & 1) != 0) {
            this.getContext().processRectangle(new RectHeader(n, n2, n3, n4, 0), dataInput);
            return;
        }
        if ((n5 & 2) != 0) {
            this.hextileBackground = this.getContext().readPixel(dataInput);
        }
        if ((n5 & 4) != 0) {
            this.hextileForeground = this.getContext().readPixel(dataInput);
        }
        this.getContext().fillRect(this.hextileBackground, n, n2, n3, n4);
        if ((n5 & 8) == 0) {
            return;
        }
        boolean bl = (n5 & 0x10) != 0;
        int n6 = dataInput.readUnsignedByte();
        int n7 = 0;
        while (n7 < n6) {
            int n8 = this.hextileForeground;
            if (bl) {
                n8 = this.getContext().readPixel(dataInput);
            }
            int n9 = dataInput.readUnsignedByte();
            int n10 = dataInput.readUnsignedByte();
            int n11 = n + (n9 >> 4);
            int n12 = n2 + (n9 & 0xF);
            int n13 = (n10 >> 4) + 1;
            int n14 = (n10 & 0xF) + 1;
            this.getContext().fillRect(n8, n11, n12, n13, n14);
            ++n7;
        }
    }
}

