/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.network;

import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolHandshake;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.ProtocolHandshakeException;
import org.eclipse.sequoyah.vnc.utilities.logger.Logger;
import org.eclipse.sequoyah.vnc.vncviewer.exceptions.ProtoClientException;
import org.eclipse.sequoyah.vnc.vncviewer.network.AbstractVNCPainter;
import org.eclipse.sequoyah.vnc.vncviewer.network.DesEncoder;
import org.eclipse.sequoyah.vnc.vncviewer.network.IRFBConstants;
import org.eclipse.sequoyah.vnc.vncviewer.network.PixelFormat;
import org.eclipse.sequoyah.vnc.vncviewer.network.VNCProtocolData;
import org.eclipse.sequoyah.vnc.vncviewer.registry.VNCProtocolRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VNCProtocol
implements IProtocolHandshake,
IRFBConstants {
    private static final int PROTOCOL_VERSION_MESSAGE_SIZE = 12;
    private static final int VNC_AUTHENTICATION_CHALLENGE_MESSAGE_SIZE = 16;

    protected abstract String getVersion();

    protected abstract void handShake(DataInput var1, OutputStream var2) throws Exception;

    protected int[] getSupportedEncodings() {
        return AbstractVNCPainter.getSupportedEncodingsStatic();
    }

    private void initPhase(ProtocolHandle protocolHandle, DataInput dataInput, OutputStream outputStream, String string) throws Exception {
        VNCProtocolData vNCProtocolData = VNCProtocolRegistry.getInstance().get(protocolHandle);
        VNCProtocolData vNCProtocolData2 = new VNCProtocolData();
        if (vNCProtocolData != null) {
            vNCProtocolData2.setVncPainter(vNCProtocolData.getVncPainter());
        }
        vNCProtocolData2.setPassword(string);
        outputStream.write(1);
        vNCProtocolData2.setFbWidth(dataInput.readUnsignedShort());
        vNCProtocolData2.setFbHeight(dataInput.readUnsignedShort());
        PixelFormat pixelFormat = new PixelFormat();
        pixelFormat.getPixelFormat(dataInput);
        vNCProtocolData2.setPixelFormat(pixelFormat);
        int n = dataInput.readInt();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray, 0, n);
        String string2 = "";
        int n2 = 0;
        while (n2 < byArray.length) {
            char c = (char)byArray[n2];
            string2 = String.valueOf(string2) + c;
            ++n2;
        }
        vNCProtocolData2.setServerName(string2);
        VNCProtocolRegistry.getInstance().register(protocolHandle, vNCProtocolData2);
        this.sendEncodingsPreferences(this.getSupportedEncodings(), outputStream);
    }

    void sendEncodingsPreferences(int[] nArray, OutputStream outputStream) throws IOException {
        int n = nArray.length;
        byte[] byArray = new byte[4 + 4 * nArray.length];
        byArray[0] = 2;
        byArray[1] = 0;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        int n2 = 0;
        while (n2 < n) {
            byArray[4 + 4 * n2] = (byte)(nArray[n2] >> 24 & 0xFF);
            byArray[5 + 4 * n2] = (byte)(nArray[n2] >> 16 & 0xFF);
            byArray[6 + 4 * n2] = (byte)(nArray[n2] >> 8 & 0xFF);
            byArray[7 + 4 * n2] = (byte)(nArray[n2] & 0xFF);
            ++n2;
        }
        outputStream.write(byArray);
    }

    protected void compareVersion(byte[] byArray) throws Exception {
        String string = this.getVersion();
        String string2 = new String(byArray);
        boolean bl = false;
        if (string2.equals(string)) {
            bl = true;
        } else if (string2.length() == string.length() && string2.substring(0, 10).equals(string.substring(0, 10)) && string2.charAt(10) > string.charAt(10)) {
            bl = true;
        }
        if (!bl) {
            throw new ProtoClientException("Wrong protocol version.");
        }
    }

    protected void negotiateProtocol(DataInput dataInput, OutputStream outputStream) throws Exception {
        byte[] byArray = new byte[12];
        dataInput.readFully(byArray, 0, 12);
        this.compareVersion(byArray);
        outputStream.write(this.getVersion().getBytes());
    }

    protected int negotiateSecurity(DataInput dataInput, OutputStream outputStream) throws Exception {
        int[] nArray = this.readSecurityTypes(dataInput);
        int n = this.chooseSecurityType(nArray);
        if (n != 0) {
            this.sendSecurityType(outputStream, n);
        }
        return n;
    }

    protected int chooseSecurityType(int[] nArray) throws Exception {
        int n = 0;
        while (n < nArray.length) {
            if (this.securityTypeSupported(nArray[n])) {
                return nArray[n];
            }
            ++n;
        }
        return 0;
    }

    protected int[] readSecurityTypes(DataInput dataInput) throws Exception {
        int[] nArray = null;
        int n = dataInput.readByte();
        if (n > 0) {
            nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = dataInput.readByte();
                ++n2;
            }
        } else {
            this.handshakeFail(dataInput);
        }
        return nArray;
    }

    protected void sendSecurityType(OutputStream outputStream, int n) throws Exception {
        outputStream.write((byte)n);
    }

    protected void handshakeFail(DataInput dataInput) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = dataInput.readInt();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append((char)dataInput.readByte());
            ++n2;
        }
        throw new Exception("Handshake failed: " + stringBuffer.toString());
    }

    protected boolean securityTypeSupported(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected void authenticate(DataInput dataInput, OutputStream outputStream, String string, int n) throws Exception {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                this.authenticateVNC(dataInput, outputStream, string);
                break;
            }
            default: {
                throw new Exception("Handshake failed: unsupported security type " + n);
            }
        }
    }

    protected void authenticateVNC(DataInput dataInput, OutputStream outputStream, String string) throws Exception {
        byte[] byArray = new byte[16];
        dataInput.readFully(byArray, 0, 16);
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = string != null ? string.getBytes() : new byte[]{};
        int n = 0;
        while (n < 8 && n < byArray3.length) {
            byArray2[n] = byArray3[n];
            ++n;
        }
        DesEncoder desEncoder = new DesEncoder(byArray2);
        desEncoder.encode(byArray, byArray);
        outputStream.write(byArray);
    }

    protected void readAuthenticationResult(DataInput dataInput) throws Exception {
        int n = dataInput.readInt();
        if (n != 0) {
            this.handshakeFail(dataInput);
        }
    }

    public void clientHandshake(ProtocolHandle protocolHandle, DataInput dataInput, OutputStream outputStream, Map<?, ?> map) throws ProtocolHandshakeException {
        int n;
        String string = (String)map.get("password");
        try {
            this.negotiateProtocol(dataInput, outputStream);
        }
        catch (Exception exception) {
            Logger.log(VNCProtocol.class).error("VNC protocol negotiation error: " + exception.getMessage());
            throw new ProtocolHandshakeException("VNC protocol negotiation error.");
        }
        try {
            n = this.negotiateSecurity(dataInput, outputStream);
        }
        catch (Exception exception) {
            Logger.log(VNCProtocol.class).error("VNC security negotiation error: " + exception.getMessage());
            throw new ProtocolHandshakeException("VNC security negotiation error.");
        }
        try {
            this.authenticate(dataInput, outputStream, string, n);
            this.readAuthenticationResult(dataInput);
        }
        catch (Exception exception) {
            Logger.log(VNCProtocol.class).error("VNC authenticate error: " + exception.getMessage());
            throw new ProtocolHandshakeException("VNC authenticate error.");
        }
        try {
            this.initPhase(protocolHandle, dataInput, outputStream, string);
        }
        catch (Exception exception) {
            Logger.log(VNCProtocol.class).error("VNC Init Phase error: " + exception.getMessage());
            throw new ProtocolHandshakeException("VNC Init Phase error.");
        }
    }

    public void serverHandshake(ProtocolHandle protocolHandle, DataInput dataInput, OutputStream outputStream, Map<?, ?> map) throws ProtocolHandshakeException {
    }
}

