/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.network;

import java.io.DataInput;
import java.io.OutputStream;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.ProtocolException;
import org.eclipse.sequoyah.vnc.vncviewer.network.VNCProtocol;

public class VNCProtocol33
extends VNCProtocol {
    static final String RFB_VERSION = "RFB 003.003\n";
    static final int HANDSHAKE_MESSAGE_SIZE = 12;

    protected String getVersion() {
        return RFB_VERSION;
    }

    protected int[] readSecurityTypes(DataInput dataInput) throws Exception {
        int[] nArray = null;
        int n = dataInput.readInt();
        switch (n) {
            case 0: {
                this.handshakeFail(dataInput);
                break;
            }
            case 1: 
            case 2: {
                nArray = new int[]{n};
                break;
            }
            default: {
                throw new Exception("VNC security negotiation error: Unknown security type");
            }
        }
        return nArray;
    }

    protected void sendSecurityType(OutputStream outputStream, int n) throws Exception {
    }

    protected void readAuthenticationResult(DataInput dataInput) throws Exception {
    }

    protected void compareVersion(byte[] byArray) throws Exception {
        if (!new String(byArray).equals(RFB_VERSION)) {
            throw new ProtocolException("Wrong protocol version.");
        }
    }

    protected void handShake(DataInput dataInput, OutputStream outputStream) throws Exception {
        byte[] byArray = new byte[12];
        dataInput.readFully(byArray, 0, 12);
        this.compareVersion(byArray);
        outputStream.write(byArray);
        dataInput.readInt();
    }
}

