/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.action.AbstractActionHandler;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGroupUngroupAction
extends AbstractActionHandler {
    public AbstractGroupUngroupAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public AbstractGroupUngroupAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
    }

    protected static void reparentInnnerConnections(Collection<SequenceEdgeEditPart> innerConnections, TransactionalEditingDomain domain, EObject container, CompositeCommand cc) {
        if (!innerConnections.isEmpty()) {
            CompositeCommand reparentCommands = new CompositeCommand(BpmnDiagramMessages.AbstractGroupUngroupAction_command_name);
            cc.compose((IUndoableOperation)reparentCommands);
            for (SequenceEdgeEditPart connection : innerConnections) {
                View view = (View)connection.getModel();
                EObject element = ViewUtil.resolveSemanticElement((View)view);
                MoveElementsCommand moveSemanticCmd = new MoveElementsCommand(new MoveRequest(domain, container, element));
                reparentCommands.compose((IUndoableOperation)moveSemanticCmd);
            }
        }
    }

    protected static ICommand getReconnectSourceCommand(ConnectionEditPart cep, ShapeNodeEditPart newParentEditPart, int index, int numberOfConnections) {
        TransactionalEditingDomain editingDomain = newParentEditPart.getEditingDomain();
        ReconnectRequest request = new ReconnectRequest();
        request.setConnectionEditPart(cep);
        request.setTargetEditPart((EditPart)newParentEditPart);
        IFigure newParentFigure = newParentEditPart.getFigure();
        Rectangle newParentBounds = newParentFigure.getBounds();
        Point p = newParentBounds.getRight();
        int height = newParentBounds.height;
        if (cep instanceof SubProcessEditPart) {
            height -= 32;
        }
        p.y = newParentBounds.y + height / (numberOfConnections + 1) * (index + 1);
        newParentFigure.translateToAbsolute((Translatable)p);
        request.setLocation(p);
        ConnectionAnchor sourceAnchor = newParentEditPart.getSourceConnectionAnchor((Request)request);
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, null);
        sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)cep.getModel())));
        sceCommand.setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)newParentEditPart.getModel())));
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, null);
        scaCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)cep.getModel())));
        scaCommand.setNewSourceTerminal(newParentEditPart.mapConnectionAnchorToTerminal(sourceAnchor));
        CompositeCommand cc = new CompositeCommand(BpmnDiagramMessages.Commands_SetConnectionEndsCommand_Source);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        EditPart containerEditPart = cep.getSource().getParent();
        View container = (View)containerEditPart.getModel();
        EObject context = ViewUtil.resolveSemanticElement((View)container);
        View view = (View)cep.getModel();
        EObject element = ViewUtil.resolveSemanticElement((View)view);
        View newView = (View)newParentEditPart.getModel();
        EObject newSource = ViewUtil.resolveSemanticElement((View)newView);
        class SetNewSourceCommand
        extends AbstractTransactionalCommand {
            private final /* synthetic */ EObject val$element;
            private final /* synthetic */ EObject val$newSource;

            public SetNewSourceCommand(TransactionalEditingDomain domain, String label, EObject eObject, EObject eObject2) {
                this.val$element = eObject;
                this.val$newSource = eObject2;
                super(domain, label, null);
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                CommandResult res;
                try {
                    ((SequenceEdge)this.val$element).setSource((Vertex)this.val$newSource);
                    res = CommandResult.newOKCommandResult();
                }
                catch (Exception e) {
                    res = CommandResult.newErrorCommandResult((Throwable)e);
                }
                return res;
            }
        }
        SetNewSourceCommand moveSemantCommand = new SetNewSourceCommand(editingDomain, BpmnDiagramMessages.AbstractGroupUngroupAction_command_new_source, element, newSource);
        cc.compose((IUndoableOperation)moveSemantCommand);
        return cc;
    }

    protected static ICommand getReconnectTargetCommand(ConnectionEditPart cep, ShapeNodeEditPart newParentEditPart, int index, int numberOfConnections) {
        TransactionalEditingDomain editingDomain = newParentEditPart.getEditingDomain();
        ReconnectRequest request = new ReconnectRequest();
        request.setConnectionEditPart(cep);
        request.setTargetEditPart((EditPart)newParentEditPart);
        IFigure newParentFigure = newParentEditPart.getFigure();
        Rectangle newParentBounds = newParentFigure.getBounds();
        Point p = newParentBounds.getLeft();
        int height = newParentBounds.height;
        if (cep instanceof SubProcessEditPart) {
            height -= 32;
        }
        p.y = newParentBounds.y + height / (numberOfConnections + 1) * (index + 1);
        newParentFigure.translateToAbsolute((Translatable)p);
        request.setLocation(p);
        ConnectionAnchor targetAnchor = newParentEditPart.getTargetConnectionAnchor((Request)request);
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, null);
        sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)cep.getModel())));
        sceCommand.setNewTargetAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)newParentEditPart.getModel())));
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, null);
        scaCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)cep.getModel())));
        scaCommand.setNewTargetTerminal(newParentEditPart.mapConnectionAnchorToTerminal(targetAnchor));
        CompositeCommand cc = new CompositeCommand(BpmnDiagramMessages.Commands_SetConnectionEndsCommand_Target);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        View view = (View)cep.getModel();
        EObject element = ViewUtil.resolveSemanticElement((View)view);
        View newView = (View)newParentEditPart.getModel();
        EObject newTarget = ViewUtil.resolveSemanticElement((View)newView);
        class SetNewTargetCommand
        extends AbstractTransactionalCommand {
            private final /* synthetic */ EObject val$element;
            private final /* synthetic */ EObject val$newTarget;

            public SetNewTargetCommand(TransactionalEditingDomain domain, String label, EObject eObject, EObject eObject2) {
                this.val$element = eObject;
                this.val$newTarget = eObject2;
                super(domain, label, null);
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                CommandResult res;
                try {
                    ((SequenceEdge)this.val$element).setTarget((Vertex)this.val$newTarget);
                    res = CommandResult.newOKCommandResult();
                }
                catch (Exception e) {
                    res = CommandResult.newErrorCommandResult((Throwable)e);
                }
                return res;
            }
        }
        SetNewTargetCommand moveSemantCommand = new SetNewTargetCommand(editingDomain, BpmnDiagramMessages.AbstractGroupUngroupAction_command_new_target, element, newTarget);
        cc.compose((IUndoableOperation)moveSemantCommand);
        return cc;
    }

    protected static SubProcessEditPart getSubProcess(EditPart editPart) {
        SubProcessEditPart subProcessEditPart = null;
        EditPart currEditPart = editPart;
        while (currEditPart != null) {
            if (currEditPart instanceof SubProcessEditPart) {
                subProcessEditPart = (SubProcessEditPart)currEditPart;
                break;
            }
            currEditPart = currEditPart.getParent();
        }
        return subProcessEditPart;
    }

    protected boolean isSelectionListener() {
        return true;
    }
}

