/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.OneLineBorder;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.NamedBpmnObject;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityCanonicalEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityGraphicalNodeEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.figures.BpmnShapesDefaultSizes;
import org.eclipse.stp.bpmn.figures.WrapLabelWithToolTip;
import org.eclipse.stp.bpmn.figures.activities.ActivityDiamondFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityNodeFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityOvalFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;
import org.eclipse.stp.bpmn.figures.connectionanchors.IConnectionAnchorFactory;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchor;
import org.eclipse.stp.bpmn.figures.connectionanchors.impl.ConnectionAnchorFactory;
import org.eclipse.stp.bpmn.layouts.ActivityLayout;
import org.eclipse.stp.bpmn.policies.BpmnDragDropEditPolicy;
import org.eclipse.stp.bpmn.policies.ConnectionHandleEditPolicyEx;
import org.eclipse.stp.bpmn.policies.OpenFileEditPolicy;
import org.eclipse.stp.bpmn.policies.ResizableActivityEditPolicy;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityEditPart
extends ShapeNodeEditPart {
    private static final int SHAPE_RECTANGLE = 0;
    private static final int SHAPE_DIAMOND = 1;
    private static final int SHAPE_CIRCLE = 2;
    public static final int EVENT_FIGURE_SIZE = 30;
    public static final int GATEWAY_FIGURE_SIZE = 50;
    public static final Dimension ACTIVITY_FIGURE_SIZE = new Dimension(111, 61);
    public static final int VISUAL_ID = 2001;
    private int handlePosition;
    protected boolean isChildAdded = false;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private IModelAwareAnchor.INodeFigureAnchorTerminalUpdatable wrappedFigure;
    private static final Border BORDER_TOP = new MarginBorder(4, 0, 0, 0);
    private static final Border BORDER_NONE = new MarginBorder(0, 0, 0, 0);
    private static final Border BORDER_TEST = new OneLineBorder(ColorConstants.black, 4, 8);
    private static final EdgeComparator EDGE_AT_START_COMPARATOR = new EdgeComparator(true);
    private static final EdgeComparator EDGE_AT_END_COMPARATOR = new EdgeComparator(false);

    public ActivityEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ActivityItemSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActivityGraphicalNodeEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new ActivityCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.removeEditPolicy("ConnectionHandlesPolicy");
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)this.createConnectionHandlerEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new BpmnDragDropEditPolicy((IGraphicalEditPart)this));
        this.installEditPolicy("OpenPolicy", (EditPolicy)this.createOpenFileEditPolicy());
    }

    protected DiagramAssistantEditPolicy createConnectionHandlerEditPolicy() {
        return new ConnectionHandleEditPolicyEx();
    }

    protected OpenFileEditPolicy createOpenFileEditPolicy() {
        return new OpenFileEditPolicy();
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = ActivityEditPart.this.getPrimaryDragEditPolicy();
                    if (result != null) {
                        return result;
                    }
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        super.installEditPolicy(key, editPolicy);
    }

    protected IFigure createNodeShapeGen() {
        ActivityFigure figure = new ActivityFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    protected IFigure createNodeShape() {
        ActivityFigure figure = (ActivityFigure)this.createNodeShapeGen();
        EObject activity = this.resolveSemanticElement();
        if (activity instanceof Activity) {
            this.setActivityTypeAndLabelAndLayout(figure, (Activity)activity);
            figure.setLooping(((Activity)activity).isLooping());
        }
        return figure;
    }

    private boolean setActivityTypeAndLabelAndLayout(ActivityFigure activityFigure, Activity activity) {
        activityFigure.setActivityType(activity.getActivityType().getLiteral());
        boolean res = false;
        WrappingLabel wl = activityFigure.getFigureActivityNameFigure();
        if (activity.getName() == null) {
            if (activity.getActivityType().equals((Object)ActivityType.TASK_LITERAL) && !BpmnDiagramMessages.ActivityEditPart_task_default_name.equals(wl.getText())) {
                wl.setText(BpmnDiagramMessages.ActivityEditPart_task_default_name);
            }
            res = true;
        }
        return this.setAlignments(activityFigure, activity, wl, res);
    }

    private boolean setAlignments(ActivityFigure activityFigure, Activity activity, WrappingLabel wl, boolean res) {
        if (activity.getActivityType().equals((Object)ActivityType.TASK_LITERAL)) {
            Object layout;
            if (!(activityFigure.getLayoutManager() instanceof StackLayout)) {
                layout = new StackLayout();
                activityFigure.setLayoutManager((LayoutManager)layout);
                res = true;
            }
            wl.setAlignment(2);
            wl.setTextJustification(2);
            if (this.wrappedFigure.getLayoutManager() instanceof ActivityLayout) {
                layout = (ActivityLayout)this.wrappedFigure.getLayoutManager();
                ((ActivityLayout)layout).setVerticalSpacing(0);
            }
        } else {
            Object layout;
            if (wl != null) {
                wl.setTextJustification(2);
                wl.setAlignment(8);
                if (this.wrappedFigure.getLayoutManager() instanceof ActivityLayout) {
                    layout = (ActivityLayout)this.wrappedFigure.getLayoutManager();
                    ((ActivityLayout)layout).setVerticalSpacing(4);
                }
            }
            if (!(activityFigure.getLayoutManager() instanceof ConstrainedToolbarLayout)) {
                layout = new ConstrainedToolbarLayout();
                layout.setSpacing(this.getMapMode().DPtoLP(5));
                activityFigure.setLayoutManager((LayoutManager)layout);
                res = true;
            }
        }
        activityFigure.invalidate();
        return res;
    }

    public ActivityFigure getPrimaryShape() {
        return (ActivityFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ActivityNameEditPart) {
            ((ActivityNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureActivityNameFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected IConnectionAnchorFactory getConnectionAnchorFactory() {
        return ConnectionAnchorFactory.INSTANCE;
    }

    public IFigure getHandleBoundsFigure() {
        if (this.wrappedFigure.getLayoutManager() instanceof ActivityLayout) {
            return ((ActivityLayout)this.wrappedFigure.getLayoutManager()).getOvalOrDiamondFigure();
        }
        return this.getPrimaryShape();
    }

    protected NodeFigure createNodePlate() {
        int shapeType;
        int activityType = 0;
        if (this.resolveSemanticElement() instanceof Activity) {
            Activity activity = (Activity)this.resolveSemanticElement();
            activityType = activity.getActivityType().getValue();
        }
        if ((shapeType = ActivityEditPart.getShapeType(activityType)) == 0) {
            int width = this.getMapMode().DPtoLP(ActivityEditPart.ACTIVITY_FIGURE_SIZE.width);
            int height = this.getMapMode().DPtoLP(ActivityEditPart.ACTIVITY_FIGURE_SIZE.height);
            this.wrappedFigure = new ActivityNodeFigure(this.getConnectionAnchorFactory(), width, height, false);
        } else if (shapeType == 1) {
            int width = this.getMapMode().DPtoLP(50);
            int height = this.getMapMode().DPtoLP(50);
            this.wrappedFigure = new ActivityNodeFigure(this.getConnectionAnchorFactory(), width, height, false);
        } else {
            int width = this.getMapMode().DPtoLP(30);
            int height = this.getMapMode().DPtoLP(30);
            this.wrappedFigure = new ActivityNodeFigure(this.getConnectionAnchorFactory(), width, height, false);
        }
        this.wrappedFigure.setLayoutManager((LayoutManager)new StackLayout());
        return (NodeFigure)this.wrappedFigure;
    }

    private void buildFigure(IFigure ovalOrDiamond, IFigure shape, WrappingLabel wrapLabel) {
        ActivityLayout layout = new ActivityLayout();
        this.wrappedFigure.setLayoutManager(layout);
        ovalOrDiamond.setLayoutManager((LayoutManager)new BorderLayout());
        ovalOrDiamond.add(shape, (Object)BorderLayout.CENTER);
        this.wrappedFigure.add(ovalOrDiamond, BorderLayout.CENTER);
        this.wrappedFigure.add((IFigure)wrapLabel, BorderLayout.BOTTOM);
        ActivityFigure activityFigure = (ActivityFigure)shape;
        activityFigure.setFigureActivityNameFigure(wrapLabel);
        this.contentPane = this.setupContentPane(this.wrappedFigure);
        EObject sem = this.resolveSemanticElement();
        if (sem instanceof Activity) {
            this.setAlignments(activityFigure, (Activity)sem, wrapLabel, true);
        }
    }

    protected NodeFigure createNodeFigure() {
        boolean event;
        NodeFigure figure = this.createNodePlate();
        IFigure shape = this.createNodeShape();
        ActivityType activityType = ActivityType.TASK_LITERAL;
        if (this.resolveSemanticElement() instanceof Activity) {
            activityType = ((Activity)this.getPrimaryView().getElement()).getActivityType();
        }
        boolean gateway = ActivityType.VALUES_GATEWAYS.contains(activityType);
        boolean bl = event = ActivityType.VALUES_EVENTS.contains(activityType) || ActivityType.VALUES_EVENTS_INTERMEDIATE.contains(activityType);
        if (gateway) {
            ActivityDiamondFigure diamondFigure = new ActivityDiamondFigure(this.getConnectionAnchorFactory());
            WrapLabelWithToolTip label = new WrapLabelWithToolTip(this.getToolTipProvider(), null, null, true, 8, 2);
            this.buildFigure(diamondFigure, shape, label);
        } else if (event) {
            ActivityOvalFigure ovalFigure = new ActivityOvalFigure(this.getConnectionAnchorFactory());
            WrapLabelWithToolTip label = new WrapLabelWithToolTip(this.getToolTipProvider(), null, null, true, 8, 2);
            this.buildFigure(ovalFigure, shape, label);
        } else {
            this.wrappedFigure.add(shape);
            this.contentPane = this.setupContentPane(shape);
        }
        return figure;
    }

    protected IFigure setupContentPaneGen(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            EObject element = this.resolveSemanticElement();
            int activityType = 0;
            if (element instanceof Activity) {
                activityType = ((Activity)element).getActivityType().getValue();
            }
            if (activityType == 0) {
                StackLayout layout = new StackLayout();
                nodeShape.setLayoutManager((LayoutManager)layout);
            } else {
                return this.setupContentPaneGen(nodeShape);
            }
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(4001));
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    private boolean isEventOrGateway() {
        boolean event;
        ActivityType activityType = ((Activity)this.getPrimaryView().getElement()).getActivityType();
        boolean gateway = ActivityType.VALUES_GATEWAYS.contains(activityType);
        boolean bl = event = ActivityType.VALUES_EVENTS.contains(activityType) || ActivityType.VALUES_EVENTS_INTERMEDIATE.contains(activityType);
        return gateway || event;
    }

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getEventType() == 1 || notification.getEventType() == 2) {
            if (BpmnPackage.eINSTANCE.getActivity_ActivityType().equals(notification.getFeature())) {
                this.handleMajorSemanticChange();
                return;
            }
            if (BpmnPackage.eINSTANCE.getActivity_Looping().equals(notification.getFeature())) {
                this.getPrimaryShape().setLooping(notification.getNewBooleanValue());
            }
            Activity activity = (Activity)this.getPrimaryView().getElement();
            if (this.getPrimaryShape() != null && this.setActivityTypeAndLabelAndLayout(this.getPrimaryShape(), activity)) {
                this.refreshVisuals();
            }
            if (NotationPackage.eINSTANCE.getSize_Width().equals(notification.getFeature()) || NotationPackage.eINSTANCE.getSize_Height().equals(notification.getFeature()) || NotationPackage.eINSTANCE.getLocation_X().equals(notification.getFeature()) || NotationPackage.eINSTANCE.getLocation_Y().equals(notification.getFeature()) || NotationPackage.eINSTANCE.getLocation().equals(notification.getFeature()) || NotationPackage.eINSTANCE.getLayoutConstraint().equals(notification.getFeature())) {
                for (Object e : this.getSourceConnections()) {
                    if (!(e instanceof ConnectionEditPart)) continue;
                    ((ConnectionEditPart)e).getTarget().refresh();
                }
                for (Object e : this.getTargetConnections()) {
                    if (!(e instanceof ConnectionEditPart)) continue;
                    ((ConnectionEditPart)e).getSource().refresh();
                }
                this.refresh();
            }
        }
        super.handleNotificationEvent(notification);
    }

    public void refreshSourceConnections() {
        try {
            super.refreshSourceConnections();
            this.updateAnchors(true);
        }
        catch (Exception e) {
            EObject eo = this.resolveSemanticElement();
            IllegalArgumentException e2 = new IllegalArgumentException("Corrupted model " + eo);
            e2.initCause(e);
            throw e2;
        }
    }

    public void refreshTargetConnections() {
        try {
            super.refreshTargetConnections();
            this.updateAnchors(false);
        }
        catch (Exception e) {
            EObject eo = this.resolveSemanticElement();
            IllegalArgumentException e2 = new IllegalArgumentException("Corrupted model " + eo);
            e2.initCause(e);
            throw e2;
        }
    }

    private void updateAnchors(boolean sourceOnly) {
        List<Edge> seqs;
        Node thisModel;
        View model;
        ConnectionEditPart connEditPart;
        HashMap<EObject, ConnectionEditPart> connIndex = new HashMap<EObject, ConnectionEditPart>();
        for (Object object : this.getSourceConnections()) {
            connEditPart = (ConnectionEditPart)object;
            model = (View)connEditPart.getModel();
            connIndex.put(model.getElement(), connEditPart);
        }
        for (Object object : this.getTargetConnections()) {
            connEditPart = (ConnectionEditPart)object;
            model = (View)connEditPart.getModel();
            connIndex.put(model.getElement(), connEditPart);
        }
        EObject element = this.resolveSemanticElement();
        if (!(element instanceof Activity)) {
            return;
        }
        Activity act = (Activity)element;
        FeatureMap messages = act.getOrderedMessages();
        int totalLength = messages.size();
        int i = 0;
        for (FeatureMap.Entry msg : messages) {
            switch (msg.getEStructuralFeature().getFeatureID()) {
                case 7: {
                    this.setAnchorIndex(connIndex, (EModelElement)msg.getValue(), i, totalLength, true);
                    ++i;
                    break;
                }
                case 6: {
                    this.setAnchorIndex(connIndex, (EModelElement)msg.getValue(), i, totalLength, false);
                    ++i;
                    break;
                }
                default: {
                    throw new IllegalStateException("Corrupted model?");
                }
            }
        }
        if (sourceOnly) {
            if (!ActivityEditPart.isOrderImportant((IGraphicalEditPart)this, sourceOnly)) {
                thisModel = (Node)this.getModel();
                seqs = ActivityEditPart.getSourceSequenceEdges(thisModel, true);
                totalLength = seqs.size();
                int ind = 0;
                for (Edge edge : seqs) {
                    this.setAnchorIndex(connIndex, (EModelElement)edge.getElement(), i, totalLength, true);
                    ++ind;
                }
            } else {
                EList outEdges = act.getOutgoingEdges();
                int ind = 0;
                totalLength = outEdges.size();
                for (SequenceEdge edge : outEdges) {
                    this.setAnchorIndex(connIndex, (EModelElement)edge, i, totalLength, true);
                    ++ind;
                }
            }
        } else if (!ActivityEditPart.isOrderImportant((IGraphicalEditPart)this, false)) {
            thisModel = (Node)this.getModel();
            seqs = ActivityEditPart.getTargetSequenceEdges(thisModel, true);
            totalLength = seqs.size();
            int ind = 0;
            for (Edge edge : seqs) {
                this.setAnchorIndex(connIndex, (EModelElement)edge.getElement(), i, totalLength, false);
                ++ind;
            }
        } else {
            EList inEdges = act.getIncomingEdges();
            int ind = 0;
            totalLength = inEdges.size();
            for (SequenceEdge edge : inEdges) {
                this.setAnchorIndex(connIndex, (EModelElement)edge, ind, totalLength, false);
                ++ind;
            }
        }
        if (!sourceOnly) {
            int ii = 0;
            int l = act.getAssociations().size();
            for (Association assoc : act.getAssociations()) {
                this.setAnchorIndex(connIndex, (EModelElement)assoc, ii, l, false);
                ++i;
            }
        }
    }

    protected String getEdgeType(EModelElement obj) {
        if (obj instanceof SequenceEdge) {
            return String.valueOf(3001);
        }
        if (obj instanceof MessagingEdge) {
            return String.valueOf(3002);
        }
        if (obj instanceof Association) {
            return String.valueOf(3003);
        }
        return null;
    }

    protected void setAnchorIndex(Map<EObject, ConnectionEditPart> connIndex, EModelElement semanticModelOfConn, int index, int totalLength, boolean isSource) {
        ConnectionEditPart conn = connIndex.get(semanticModelOfConn);
        if (conn != null) {
            ConnectionAnchor anchor;
            String edgeType = this.getEdgeType(semanticModelOfConn);
            PolylineConnectionEx connFigure = (PolylineConnectionEx)conn.getFigure();
            ConnectionAnchor connectionAnchor = anchor = isSource ? connFigure.getSourceAnchor() : connFigure.getTargetAnchor();
            if (anchor instanceof IModelAwareAnchor) {
                ((IModelAwareAnchor)anchor).setConnectionType(isSource, edgeType, index, totalLength);
                conn.refresh();
            }
        }
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new ResizableActivityEditPolicy();
    }

    private static int getShapeType(int activityType) {
        int shapeType;
        switch (activityType) {
            case 0: {
                shapeType = 0;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                shapeType = 1;
                break;
            }
            default: {
                shapeType = 2;
            }
        }
        return shapeType;
    }

    public DragTracker getDragTracker(Request request) {
        return new TaskDragEditPartsTrackerEx((IGraphicalEditPart)this);
    }

    protected WrapLabelWithToolTip.IToolTipProvider getToolTipProvider() {
        return ActivityPainter.createToolTipProvider((NamedBpmnObject)this.resolveSemanticElement(), true);
    }

    public static boolean isOrderImportant(IGraphicalEditPart part, boolean forOutgoing) {
        if (!forOutgoing || part.resolveSemanticElement() == null) {
            return false;
        }
        Activity act = (Activity)part.resolveSemanticElement();
        ActivityType type = act.getActivityType();
        if (type.equals((Object)ActivityType.GATEWAY_DATA_BASED_EXCLUSIVE_LITERAL) || type.equals((Object)ActivityType.GATEWAY_DATA_BASED_INCLUSIVE_LITERAL)) {
            if (act.getOutgoingEdges().size() == 2) {
                for (SequenceEdge se : act.getOutgoingEdges()) {
                    if (!se.isIsDefault() && (se.getConditionType() == null || se.getConditionType().getValue() != 2)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean shouldShowSetAsThrowingOrCatching() {
        boolean b = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean("bpmn.1.1.style");
        if (!b) {
            return false;
        }
        return this.resolveSemanticElement() instanceof Activity && ((Activity)this.resolveSemanticElement()).getOrderedMessages().isEmpty() && ActivityType.VALUES_EVENTS.contains(((Activity)this.resolveSemanticElement()).getActivityType());
    }

    public static List<Edge> getSourceSequenceEdges(Node thisModel, boolean dosort) {
        ArrayList<Edge> res = new ArrayList<Edge>();
        for (Object e : thisModel.getSourceEdges()) {
            Edge ee = (Edge)e;
            if (!(ee.getElement() instanceof SequenceEdge)) continue;
            res.add(ee);
        }
        if (dosort) {
            Collections.sort(res, EDGE_AT_END_COMPARATOR);
        }
        return res;
    }

    public static List<Edge> getTargetSequenceEdges(Node thisModel, boolean dosort) {
        ArrayList<Edge> res = new ArrayList<Edge>();
        for (Object e : thisModel.getTargetEdges()) {
            Edge ee = (Edge)e;
            if (!(ee.getElement() instanceof SequenceEdge) || ee.getSource() == null || ee.getTarget() == null) continue;
            res.add(ee);
        }
        if (dosort) {
            Collections.sort(res, EDGE_AT_START_COMPARATOR);
        }
        return res;
    }

    public static int getStartAnchorVisualIndex(Edge thisEdge) {
        Node target = (Node)thisEdge.getSource();
        List<Edge> res = ActivityEditPart.getSourceSequenceEdges(target, true);
        return res.indexOf(thisEdge);
    }

    public static int getTargetAnchorVisualIndex(Edge thisEdge) {
        Node source = (Node)thisEdge.getTarget();
        List<Edge> res = ActivityEditPart.getTargetSequenceEdges(source, true);
        return res.indexOf(thisEdge);
    }

    public class ActivityFigure
    extends org.eclipse.stp.bpmn.figures.activities.ActivityFigure {
        private WrappingLabel fActivityNameFigure;
        private boolean myUseLocalCoordinates = false;

        public ActivityFigure() {
            EObject a = ActivityEditPart.this.resolveSemanticElement();
            if (a instanceof Activity) {
                this.setActivityType(((Activity)a).getActivityType().getLiteral());
            } else {
                this.setActivityType(ActivityType.TASK_LITERAL.getLiteral());
            }
            this.setForegroundColor(ColorConstants.black);
            this.createContents();
        }

        private void createContents() {
            if (!(ActivityEditPart.this.resolveSemanticElement() instanceof Activity) || ((Activity)ActivityEditPart.this.resolveSemanticElement()).getActivityType().equals((Object)ActivityType.TASK_LITERAL)) {
                this.createContentsGen();
            }
        }

        private void createContentsGen() {
            WrapLabelWithToolTip fig_0 = new WrapLabelWithToolTip(ActivityEditPart.this.getToolTipProvider(), null, null, true, 8, 8);
            fig_0.setText(BpmnDiagramMessages.ActivityEditPart_task_default_name);
            this.setFigureActivityNameFigure(fig_0);
            Object layData0 = null;
            this.add((IFigure)fig_0, layData0);
        }

        public WrappingLabel getFigureActivityNameFigure() {
            return this.fActivityNameFigure;
        }

        private void setFigureActivityNameFigure(WrappingLabel fig) {
            this.fActivityNameFigure = fig;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public boolean isCatching() {
            Activity activity = (Activity)ActivityEditPart.this.resolveSemanticElement();
            if (activity == null) {
                return false;
            }
            if (ActivityType.VALUES_EVENTS_INTERMEDIATE.contains(activity.getActivityType())) {
                if (!activity.getOrderedMessages().isEmpty()) {
                    return activity.getIncomingMessages().contains(((FeatureMap.Entry)activity.getOrderedMessages().get(0)).getValue());
                }
                String str = EcoreUtil.getAnnotation((EModelElement)activity, (String)"isThrowing", (String)"isThrowing");
                return !"true".equals(str);
            }
            return ActivityType.VALUES_EVENTS_START.contains(activity.getActivityType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EdgeComparator
    implements Comparator<Edge> {
        private boolean compareWithSources;

        EdgeComparator(boolean accordingToStartY) {
            this.compareWithSources = accordingToStartY;
        }

        @Override
        public int compare(Edge o1, Edge o2) {
            Node n1 = null;
            Node n2 = null;
            if (this.compareWithSources) {
                n1 = (Node)o1.getSource();
                n2 = (Node)o2.getSource();
            } else {
                n1 = (Node)o1.getTarget();
                n2 = (Node)o2.getTarget();
            }
            Bounds y1 = BpmnShapesDefaultSizes.getBounds(n1);
            Bounds y2 = BpmnShapesDefaultSizes.getBounds(n2);
            return 2 * y1.getY() + y1.getHeight() - (2 * y2.getY() + y2.getHeight());
        }
    }
}

