/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramModificationListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDiagramModificationListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDocumentProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.ui.IFileEditorInput;

public class BpmnDocumentProvider
extends FileDiagramDocumentProvider {
    protected void saveDocumentToFile(IDocument document, IFile file, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        Diagram diagram = (Diagram)document.getContent();
        IDiagramDocument diagramDocument = (IDiagramDocument)document;
        TransactionalEditingDomain domain = diagramDocument.getEditingDomain();
        EList resources = domain.getResourceSet().getResources();
        monitor.beginTask("Saving diagram", resources.size() + 1);
        try {
            URI semanticURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            if (!semanticURI.equals((Object)diagram.getElement().eResource().getURI())) {
                this.handleElementMoved(diagram, file.getFullPath());
            }
            diagram.getElement().eResource().save(Collections.EMPTY_MAP);
            diagram.eResource().save(Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            BpmnDiagramEditorPlugin.getInstance().logError("Unable to save resource: " + diagram.eResource().getURI(), e);
        }
        monitor.done();
    }

    protected ISchedulingRule getSaveRule(Object element) {
        Diagram diagram;
        IDiagramDocument diagramDocument = this.getDiagramDocument(element);
        if (diagramDocument != null && (diagram = diagramDocument.getDiagram()) != null) {
            ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
            Iterator it = diagramDocument.getEditingDomain().getResourceSet().getResources().iterator();
            while (it.hasNext()) {
                IFile nextFile = WorkspaceSynchronizer.getFile((Resource)((Resource)it.next()));
                if (nextFile == null) continue;
                rules.add(this.computeSaveSchedulingRule((IResource)nextFile));
            }
            return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
        }
        return super.getSaveRule(element);
    }

    protected FileDocumentProvider.FileInfo createFileInfo(IDocument document, FileDocumentProvider.FileSynchronizer synchronizer, IFileEditorInput input) {
        assert (document instanceof DiagramDocument);
        CustomModificationListener diagramListener = new CustomModificationListener(this, (DiagramDocument)document, input);
        FileDiagramDocumentProvider.DiagramFileInfo info = new FileDiagramDocumentProvider.DiagramFileInfo((FileDiagramDocumentProvider)this, document, synchronizer, (DiagramModificationListener)diagramListener);
        diagramListener.startListening();
        return info;
    }

    private ISchedulingRule computeSaveSchedulingRule(IResource toCreateOrModify) {
        if (toCreateOrModify.exists() && toCreateOrModify.isSynchronized(0)) {
            return this.fResourceRuleFactory.modifyRule(toCreateOrModify);
        }
        IResource parent = toCreateOrModify;
        while ((parent = (toCreateOrModify = parent).getParent()) != null && !parent.exists() && !parent.isSynchronized(0)) {
        }
        return this.fResourceRuleFactory.createRule(toCreateOrModify);
    }

    protected void handleElementMoved(IFileEditorInput fileEditorInput, IPath path) {
        if (path != null) {
            IDiagramDocument diagramDocument = this.getDiagramDocument(fileEditorInput);
            Diagram diagram = null;
            if (diagramDocument != null) {
                diagram = diagramDocument.getDiagram();
            }
            if (diagram != null) {
                diagram.getElement().eResource().setURI(URI.createPlatformResourceURI((String)path.removeFileExtension().addFileExtension("bpmn").toString()));
            }
        }
        super.handleElementMoved(fileEditorInput, path);
    }

    protected void handleElementMoved(Diagram diagram, IPath path) {
        if (path != null && diagram != null) {
            diagram.getElement().eResource().setURI(URI.createPlatformResourceURI((String)path.removeFileExtension().addFileExtension("bpmn").toString()));
            diagram.eResource().setURI(URI.createPlatformResourceURI((String)path.toString()));
        }
    }

    private class CustomModificationListener
    extends FileDiagramModificationListener {
        private DemultiplexingListener myListener;

        public CustomModificationListener(BpmnDocumentProvider documentProviderParameter, DiagramDocument documentParameter, IFileEditorInput inputParameter) {
            super((FileDocumentProvider)documentProviderParameter, documentParameter, inputParameter);
            this.myListener = null;
            final DiagramDocument document = documentParameter;
            this.myListener = new DemultiplexingListener(NotificationFilter.NOT_TOUCH){

                protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
                    Resource modifiedResource;
                    if (notification.getNotifier() instanceof EObject && (modifiedResource = ((EObject)notification.getNotifier()).eResource()) != document.getDiagram().eResource()) {
                        document.setContent(document.getContent());
                    }
                }
            };
        }

        public void startListening() {
            super.startListening();
            this.getEditingDomain().addResourceSetListener((ResourceSetListener)this.myListener);
        }

        public void stopListening() {
            this.getEditingDomain().removeResourceSetListener((ResourceSetListener)this.myListener);
            super.stopListening();
        }
    }
}

