/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.DataObject;
import org.eclipse.stp.bpmn.Group;
import org.eclipse.stp.bpmn.Lane;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.TextAnnotation;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;

public class BpmnVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(BpmnDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if (BpmnDiagramEditPart.MODEL_ID.equals(view.getType())) {
                return 79;
            }
            return -1;
        }
        return BpmnVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                BpmnDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return BpmnVisualIDRegistry.getDiagramVisualID(domainElement, domainElementMetaclass);
    }

    private static int getDiagramVisualID(EObject domainElement, EClass domainElementMetaclass) {
        if (BpmnPackage.eINSTANCE.getBpmnDiagram().isSuperTypeOf(domainElementMetaclass) && BpmnVisualIDRegistry.isDiagramBpmnDiagram_79((BpmnDiagram)domainElement)) {
            return 79;
        }
        return BpmnVisualIDRegistry.getUnrecognizedDiagramID(domainElement);
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return BpmnVisualIDRegistry.getNodeVisualID(containerView, domainElement, domainElementMetaclass, null);
    }

    public static int getNodeVisualID(View containerView, EObject domainElement, EClass domainElementMetaclass, String semanticHint) {
        int containerVisualID;
        String containerModelID = BpmnVisualIDRegistry.getModelID(containerView);
        if (!BpmnDiagramEditPart.MODEL_ID.equals(containerModelID)) {
            return -1;
        }
        if (BpmnDiagramEditPart.MODEL_ID.equals(containerModelID)) {
            containerVisualID = BpmnVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 79;
        } else {
            return -1;
        }
        int nodeVisualID = semanticHint != null ? BpmnVisualIDRegistry.getVisualID(semanticHint) : -1;
        switch (containerVisualID) {
            case 1001: {
                if (4008 == nodeVisualID) {
                    return 4008;
                }
                if (5001 == nodeVisualID) {
                    return 5001;
                }
                return BpmnVisualIDRegistry.getUnrecognizedPool_1001ChildNodeID(domainElement, semanticHint);
            }
            case 1002: {
                if (4009 == nodeVisualID) {
                    return 4009;
                }
                return BpmnVisualIDRegistry.getUnrecognizedTextAnnotation_1002ChildNodeID(domainElement, semanticHint);
            }
            case 1003: {
                if (4010 == nodeVisualID) {
                    return 4010;
                }
                return BpmnVisualIDRegistry.getUnrecognizedDataObject_1003ChildNodeID(domainElement, semanticHint);
            }
            case 1004: {
                if (4011 == nodeVisualID) {
                    return 4011;
                }
                return BpmnVisualIDRegistry.getUnrecognizedGroup_1004ChildNodeID(domainElement, semanticHint);
            }
            case 2001: {
                if (4001 == nodeVisualID) {
                    return 4001;
                }
                return BpmnVisualIDRegistry.getUnrecognizedActivity_2001ChildNodeID(domainElement, semanticHint);
            }
            case 2002: {
                if (4006 == nodeVisualID) {
                    return 4006;
                }
                if (5002 == nodeVisualID) {
                    return 5002;
                }
                if (5003 == nodeVisualID) {
                    return 5003;
                }
                return BpmnVisualIDRegistry.getUnrecognizedSubProcess_2002ChildNodeID(domainElement, semanticHint);
            }
            case 2003: {
                if (4002 == nodeVisualID) {
                    return 4002;
                }
                return BpmnVisualIDRegistry.getUnrecognizedActivity_2003ChildNodeID(domainElement, semanticHint);
            }
            case 2004: {
                if (4003 == nodeVisualID) {
                    return 4003;
                }
                return BpmnVisualIDRegistry.getUnrecognizedTextAnnotation_2004ChildNodeID(domainElement, semanticHint);
            }
            case 2005: {
                if (4004 == nodeVisualID) {
                    return 4004;
                }
                return BpmnVisualIDRegistry.getUnrecognizedDataObject_2005ChildNodeID(domainElement, semanticHint);
            }
            case 2006: {
                if (4005 == nodeVisualID) {
                    return 4005;
                }
                return BpmnVisualIDRegistry.getUnrecognizedGroup_2006ChildNodeID(domainElement, semanticHint);
            }
            case 2007: {
                if (4007 == nodeVisualID) {
                    return 4007;
                }
                return BpmnVisualIDRegistry.getUnrecognizedLane_2007ChildNodeID(domainElement, semanticHint);
            }
            case 5001: {
                if ((semanticHint == null || 2001 == nodeVisualID) && BpmnPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeActivity_2001((Activity)domainElement))) {
                    return 2001;
                }
                if ((semanticHint == null || 2002 == nodeVisualID) && BpmnPackage.eINSTANCE.getSubProcess().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeSubProcess_2002((SubProcess)domainElement))) {
                    return 2002;
                }
                if ((semanticHint == null || 2007 == nodeVisualID) && BpmnPackage.eINSTANCE.getLane().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeLane_2007((Lane)domainElement))) {
                    return 2007;
                }
                if ((semanticHint == null || 2004 == nodeVisualID) && BpmnPackage.eINSTANCE.getTextAnnotation().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeTextAnnotation_2004((TextAnnotation)domainElement))) {
                    return 2004;
                }
                if ((semanticHint == null || 2005 == nodeVisualID) && BpmnPackage.eINSTANCE.getDataObject().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeDataObject_2005((DataObject)domainElement))) {
                    return 2005;
                }
                if ((semanticHint == null || 2006 == nodeVisualID) && BpmnPackage.eINSTANCE.getGroup().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeGroup_2006((Group)domainElement))) {
                    return 2006;
                }
                return BpmnVisualIDRegistry.getUnrecognizedPoolPoolCompartment_5001ChildNodeID(domainElement, semanticHint);
            }
            case 5002: {
                if ((semanticHint == null || 2001 == nodeVisualID) && BpmnPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeActivity_2001((Activity)domainElement))) {
                    return 2001;
                }
                if ((semanticHint == null || 2002 == nodeVisualID) && BpmnPackage.eINSTANCE.getSubProcess().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeSubProcess_2002((SubProcess)domainElement))) {
                    return 2002;
                }
                if ((semanticHint == null || 2004 == nodeVisualID) && BpmnPackage.eINSTANCE.getTextAnnotation().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeTextAnnotation_2004((TextAnnotation)domainElement))) {
                    return 2004;
                }
                if ((semanticHint == null || 2005 == nodeVisualID) && BpmnPackage.eINSTANCE.getDataObject().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeDataObject_2005((DataObject)domainElement))) {
                    return 2005;
                }
                if ((semanticHint == null || 2006 == nodeVisualID) && BpmnPackage.eINSTANCE.getGroup().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeGroup_2006((Group)domainElement))) {
                    return 2006;
                }
                return BpmnVisualIDRegistry.getUnrecognizedSubProcessSubProcessBodyCompartment_5002ChildNodeID(domainElement, semanticHint);
            }
            case 5003: {
                if ((semanticHint == null || 2003 == nodeVisualID) && BpmnPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeActivity_2003((Activity)domainElement))) {
                    return 2003;
                }
                return BpmnVisualIDRegistry.getUnrecognizedSubProcessSubProcessBorderCompartment_5003ChildNodeID(domainElement, semanticHint);
            }
            case 79: {
                if ((semanticHint == null || 1001 == nodeVisualID) && BpmnPackage.eINSTANCE.getPool().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodePool_1001((Pool)domainElement))) {
                    return 1001;
                }
                if ((semanticHint == null || 1002 == nodeVisualID) && BpmnPackage.eINSTANCE.getTextAnnotation().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeTextAnnotation_1002((TextAnnotation)domainElement))) {
                    return 1002;
                }
                if ((semanticHint == null || 1003 == nodeVisualID) && BpmnPackage.eINSTANCE.getDataObject().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeDataObject_1003((DataObject)domainElement))) {
                    return 1003;
                }
                if ((semanticHint == null || 1004 == nodeVisualID) && BpmnPackage.eINSTANCE.getGroup().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isNodeGroup_1004((Group)domainElement))) {
                    return 1004;
                }
                return BpmnVisualIDRegistry.getUnrecognizedBpmnDiagram_79ChildNodeID(domainElement, semanticHint);
            }
            case 3001: {
                if (4012 == nodeVisualID) {
                    return 4012;
                }
                return BpmnVisualIDRegistry.getUnrecognizedSequenceEdge_3001LinkLabelID(semanticHint);
            }
            case 3002: {
                if (4013 == nodeVisualID) {
                    return 4013;
                }
                return BpmnVisualIDRegistry.getUnrecognizedMessagingEdge_3002LinkLabelID(semanticHint);
            }
        }
        return -1;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return BpmnVisualIDRegistry.getLinkWithClassVisualID(domainElement, domainElementMetaclass);
    }

    public static int getLinkWithClassVisualID(EObject domainElement, EClass domainElementMetaclass) {
        if (BpmnPackage.eINSTANCE.getSequenceEdge().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isLinkWithClassSequenceEdge_3001((SequenceEdge)domainElement))) {
            return 3001;
        }
        if (BpmnPackage.eINSTANCE.getMessagingEdge().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isLinkWithClassMessagingEdge_3002((MessagingEdge)domainElement))) {
            return 3002;
        }
        if (BpmnPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || BpmnVisualIDRegistry.isLinkWithClassAssociation_3003((Association)domainElement))) {
            return 3003;
        }
        return BpmnVisualIDRegistry.getUnrecognizedLinkWithClassID(domainElement);
    }

    private static boolean isDiagramBpmnDiagram_79(BpmnDiagram element) {
        return true;
    }

    private static int getUnrecognizedDiagramID(EObject domainElement) {
        return -1;
    }

    private static boolean isNodePool_1001(Pool element) {
        return true;
    }

    private static boolean isNodeTextAnnotation_1002(TextAnnotation element) {
        return true;
    }

    private static boolean isNodeDataObject_1003(DataObject element) {
        return true;
    }

    private static boolean isNodeGroup_1004(Group element) {
        return true;
    }

    private static boolean isNodeActivity_2001(Activity element) {
        return true;
    }

    private static boolean isNodeSubProcess_2002(SubProcess element) {
        return true;
    }

    private static boolean isNodeActivity_2003(Activity element) {
        return true;
    }

    private static boolean isNodeTextAnnotation_2004(TextAnnotation element) {
        return true;
    }

    private static boolean isNodeDataObject_2005(DataObject element) {
        return true;
    }

    private static boolean isNodeGroup_2006(Group element) {
        return true;
    }

    private static boolean isNodeLane_2007(Lane element) {
        return true;
    }

    private static int getUnrecognizedPool_1001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedTextAnnotation_1002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedDataObject_1003ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedGroup_1004ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedActivity_2001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedSubProcess_2002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedActivity_2003ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedTextAnnotation_2004ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedDataObject_2005ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedGroup_2006ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedLane_2007ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedPoolPoolCompartment_5001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedSubProcessSubProcessBodyCompartment_5002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedSubProcessSubProcessBorderCompartment_5003ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedBpmnDiagram_79ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedSequenceEdge_3001LinkLabelID(String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedMessagingEdge_3002LinkLabelID(String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedLinkWithClassID(EObject domainElement) {
        return -1;
    }

    private static boolean isLinkWithClassSequenceEdge_3001(SequenceEdge element) {
        return true;
    }

    private static boolean isLinkWithClassMessagingEdge_3002(MessagingEdge element) {
        return true;
    }

    private static boolean isLinkWithClassAssociation_3003(Association element) {
        return true;
    }
}

