/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.palette;

import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gef.ui.palette.DefaultPaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.palette.BpmnPaletteEditPartFactory;
import org.eclipse.stp.bpmn.palette.IStickableToolEntry;
import org.eclipse.swt.widgets.Composite;

public class BpmnPaletteViewer
extends PaletteViewer {
    public static PaletteViewerProvider getBpmnPaletteViewerProvider(EditDomain editDomain) {
        return new PaletteViewerProvider(editDomain){

            public PaletteViewer createPaletteViewer(Composite parent) {
                BpmnPaletteViewer pViewer = new BpmnPaletteViewer();
                IPreferenceStore preferenceStore = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore();
                int trueDefaultPrefLayout = preferenceStore.getInt("Layout Setting");
                DefaultPaletteViewerPreferences prefs = new DefaultPaletteViewerPreferences(preferenceStore);
                preferenceStore.setDefault("Layout Setting", trueDefaultPrefLayout);
                pViewer.setPaletteViewerPreferences((PaletteViewerPreferences)prefs);
                pViewer.createControl(parent);
                this.configurePaletteViewer(pViewer);
                this.hookPaletteViewer(pViewer);
                return pViewer;
            }
        };
    }

    public BpmnPaletteViewer() {
        super.setEditPartFactory((EditPartFactory)new BpmnPaletteEditPartFactory());
    }

    public void setActiveTool(ToolEntry newMode) {
        Tool tool;
        boolean updateUnloadWhenFinished = false;
        if (newMode != null && newMode instanceof IStickableToolEntry) {
            if (newMode == this.getActiveTool()) {
                if (((IStickableToolEntry)newMode).isSticky()) {
                    ((IStickableToolEntry)newMode).setIsSticky(false);
                    super.setActiveTool(null);
                    return;
                }
                ((IStickableToolEntry)newMode).setIsSticky(true);
            } else {
                ((IStickableToolEntry)newMode).setIsSticky(false);
                if (this.getActiveTool() instanceof IStickableToolEntry) {
                    ((IStickableToolEntry)this.getActiveTool()).setIsSticky(false);
                }
            }
            updateUnloadWhenFinished = true;
        }
        super.setActiveTool(newMode);
        if (updateUnloadWhenFinished && (tool = this.getEditDomain().getActiveTool()) != null && tool instanceof AbstractTool) {
            ((AbstractTool)tool).setUnloadWhenFinished(!((IStickableToolEntry)newMode).isSticky());
        }
    }
}

