/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.in.sca.transform;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.stp.im.Process;
import org.eclipse.stp.im.Service;
import org.eclipse.stp.im.StpIntermediateModel;
import org.eclipse.stp.im.in.sca.transform.SCAModelReader;
import org.eclipse.stp.im.util.IMHandler;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.swt.widgets.Shell;

public class SCA2IMTransformer {
    private SCAModelReader scaReader = new SCAModelReader();
    private Shell shell;

    public SCA2IMTransformer(Shell shell) {
        this.shell = shell;
    }

    public synchronized void createIMfromSCA(URI uri, IContainer container) {
        DocumentRoot scaRoot = null;
        Composite composite = null;
        try {
            scaRoot = this.scaReader.loadSCAModel(uri);
            composite = scaRoot.getComposite();
        }
        catch (Throwable t) {
            this.displayIMError("Could not obtain the SCA contents", t);
            return;
        }
        IMHandler imHandler = new IMHandler();
        StpIntermediateModel im = imHandler.getStpIM();
        for (Component comp : composite.getComponent()) {
            for (ComponentService service : comp.getService()) {
                Service service2 = imHandler.createService(service.getName());
            }
        }
        for (org.eclipse.stp.sca.Service compService : composite.getService()) {
            Process proc = imHandler.createProcess(compService.getName());
            Iterator iterator = imHandler.createStep(compService.getPromote().getName(), proc);
        }
        try {
            URI imURI = uri.trimFileExtension().appendFileExtension("im");
            imHandler.persistIM(imURI);
            container.refreshLocal(2, null);
        }
        catch (IOException e) {
            this.displayIMError("Could not save the IM file", e);
        }
        catch (CoreException e) {
            this.displayIMError("Could not refresh the workspace", e);
        }
    }

    private void displayIMError(String msg, Throwable t) {
        Status iStatus = null;
        iStatus = t != null ? new Status(4, "org.eclipse.stp.im.in.sca", t.getLocalizedMessage(), t) : new Status(4, "org.eclipse.stp.im.in.sca", msg);
        ErrorDialog.openError((Shell)this.shell, (String)"Intermediate Model Generation Error", (String)msg, (IStatus)iStatus);
    }
}

