/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.runtime;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.im.runtime.IComboProviderValues;
import org.eclipse.stp.im.util.ImLogger;

public class ComboProviderValuesProxy {
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_CLASS = "class";
    private static final String ATT_TARGET_COMBO = "target-combo";
    private final IConfigurationElement configElement;
    private final String id;
    private final String name;
    private final String targetCombo;

    public ComboProviderValuesProxy(IConfigurationElement configElement) {
        this.configElement = configElement;
        this.id = ComboProviderValuesProxy.getAttribute(configElement, ATT_ID, null);
        this.name = ComboProviderValuesProxy.getAttribute(configElement, ATT_NAME, this.id);
        this.targetCombo = ComboProviderValuesProxy.getAttribute(configElement, ATT_TARGET_COMBO, this.id);
        ComboProviderValuesProxy.getAttribute(configElement, ATT_CLASS, null);
    }

    private static String getAttribute(IConfigurationElement configElem, String name, String defaultValue) {
        String value = configElem.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException("Missing " + name + " attribute");
    }

    public IComboProviderValues getComboProviderValue() {
        try {
            IComboProviderValues comboProviderValues = (IComboProviderValues)this.configElement.createExecutableExtension(ATT_CLASS);
            return comboProviderValues;
        }
        catch (Exception e) {
            ImLogger.error((String)"org.eclipse.stp.im.runtime", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetCombo() {
        return this.targetCombo;
    }
}

