/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.tool.in.bpmneditor.section;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.im.runtime.IProperty;
import org.eclipse.stp.im.runtime.IRuntime;
import org.eclipse.stp.im.runtime.ImRuntimeActivator;
import org.eclipse.stp.im.runtime.comboproviders.ComboEntries;
import org.eclipse.stp.im.runtime.comboproviders.IComboProvider;
import org.eclipse.stp.im.tool.in.bpmneditor.BpmnEditorExtensionActivator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechnologySection
extends AbstractPropertySection
implements SelectionListener {
    protected CLabel poolLabel = null;
    protected CLabel runtimeLabel = null;
    protected CCombo technologyText = null;
    protected Button btnSetTechnology = null;
    protected Pool pool = null;
    protected String[] data = null;
    protected TabbedPropertySheetPage page = null;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        FontData fTextFontData = new FontData();
        fTextFontData.setStyle(1);
        fTextFontData.setName("Tahoma");
        fTextFontData.setHeight(8);
        Font boldText = new Font((Device)PlatformUI.getWorkbench().getDisplay(), fTextFontData);
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        this.page = aTabbedPropertySheetPage;
        GridData gd = new GridData(4);
        gd.minimumWidth = 500;
        gd.widthHint = 500;
        CLabel label2 = this.getWidgetFactory().createCLabel(parent, "Pool");
        label2.setFont(boldText);
        this.poolLabel = this.getWidgetFactory().createCLabel(parent, "");
        this.poolLabel.setLayoutData((Object)gd);
        CLabel label3 = this.getWidgetFactory().createCLabel(parent, "Runtime");
        label3.setFont(boldText);
        this.runtimeLabel = this.getWidgetFactory().createCLabel(parent, "Not Defined");
        this.runtimeLabel.setLayoutData((Object)gd);
        this.technologyText = this.getWidgetFactory().createCCombo(parent, 780);
        this.data = ImRuntimeActivator.getRuntimeNames();
        this.technologyText.setItems(this.data);
        this.technologyText.select(0);
        GridData gd4 = new GridData(4);
        gd4.minimumWidth = 100;
        gd4.widthHint = 100;
        this.btnSetTechnology = this.getWidgetFactory().createButton(parent, " Bind to Runtime ", 8);
        this.btnSetTechnology.setLayoutData((Object)gd4);
        this.btnSetTechnology.addSelectionListener((SelectionListener)this);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (selection instanceof IStructuredSelection) {
            Activity activity;
            Graph graph;
            Object unknownInput = ((IStructuredSelection)selection).getFirstElement();
            if (unknownInput instanceof IGraphicalEditPart && ((IGraphicalEditPart)unknownInput).resolveSemanticElement() != null) {
                unknownInput = ((IGraphicalEditPart)unknownInput).resolveSemanticElement();
            }
            if (unknownInput instanceof Pool) {
                this.pool = (Pool)unknownInput;
                this.technologyText.setEnabled(true);
                this.btnSetTechnology.setEnabled(true);
                EAnnotation technologyAnnotation = this.pool.getEAnnotation("technology");
                if (technologyAnnotation != null) {
                    String technologyName = (String)technologyAnnotation.getDetails().get((Object)"TechnologyName");
                    this.runtimeLabel.setText(technologyName);
                    this.technologyText.select(this.findSelectionIndex(technologyName));
                }
                return;
            }
            if (unknownInput instanceof Activity && (graph = (activity = (Activity)unknownInput).getGraph()) instanceof Pool && graph.getEAnnotation("technology") != null) {
                this.technologyText.setEnabled(false);
                this.btnSetTechnology.setEnabled(false);
                this.technologyText.select(this.findSelectionIndex((String)graph.getEAnnotation("technology").getDetails().get((Object)"TechnologyName")));
                return;
            }
        }
        this.technologyText.setEnabled(false);
        this.btnSetTechnology.setEnabled(false);
    }

    protected EAnnotation createAnnotation(String source, Map<String, String> details) {
        EAnnotation ea = EcoreFactory.eINSTANCE.createEAnnotation();
        ea.setSource(source);
        ea.getDetails().putAll(details);
        return ea;
    }

    public void widgetDefaultSelected(SelectionEvent ev) {
        this.widgetSelected(ev);
    }

    public void widgetSelected(SelectionEvent ev) {
        if (ev.getSource() instanceof Button) {
            int selectionIndex = this.technologyText.getSelectionIndex();
            final String technologyName = this.data[selectionIndex];
            String technologyId = ImRuntimeActivator.getIdForRuntimeName((String)technologyName);
            String previousTechnologyId = null;
            String previousTechnologyName = null;
            if (this.pool.getEAnnotation("technology") != null) {
                previousTechnologyId = (String)this.pool.getEAnnotation("technology").getDetails().get((Object)"im.pool.runtimeID");
                previousTechnologyName = (String)this.pool.getEAnnotation("technology").getDetails().get((Object)"TechnologyName");
            }
            boolean safeUpdate = false;
            if (technologyId.equalsIgnoreCase(previousTechnologyId)) {
                safeUpdate = true;
            } else if (previousTechnologyId == null || previousTechnologyId.equalsIgnoreCase("AbstractModel")) {
                safeUpdate = true;
            }
            System.out.println(" Technology Change [" + previousTechnologyId + "] --> [" + technologyId + "] Update Safe [" + safeUpdate + "]");
            if (safeUpdate) {
                CreateOrUpdateTechnologyEAnnotationCommand command = new CreateOrUpdateTechnologyEAnnotationCommand(this.pool, "Modifying Technology"){

                    protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
                        EAnnotation poolTechnologyAnnotation = TechnologySection.this.pool.getEAnnotation("technology");
                        String runtimeID = ImRuntimeActivator.getIdForRuntimeName((String)technologyName);
                        if (poolTechnologyAnnotation == null) {
                            HashMap<String, String> details = new HashMap<String, String>();
                            details.put("im.pool.runtimeID", runtimeID);
                            details.put("TechnologyName", technologyName);
                            this.createProcessProperties(details, runtimeID);
                            poolTechnologyAnnotation = TechnologySection.this.createAnnotation("technology", details);
                            SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)poolTechnologyAnnotation, (Object)EcorePackage.eINSTANCE.getEAnnotation_EModelElement(), (Object)TechnologySection.this.pool).execute();
                        } else {
                            EMap existDetails = poolTechnologyAnnotation.getDetails();
                            existDetails.put((Object)"TechnologyName", (Object)technologyName);
                            existDetails.put((Object)"im.pool.runtimeID", (Object)ImRuntimeActivator.getIdForRuntimeName((String)technologyName));
                            HashMap<String, String> newDetails = new HashMap<String, String>();
                            this.createProcessProperties(newDetails, runtimeID);
                            for (String key : newDetails.keySet()) {
                                if (existDetails.get((Object)key) != null) continue;
                                existDetails.put((Object)key, (Object)((String)newDetails.get(key)));
                            }
                        }
                        return CommandResult.newOKCommandResult();
                    }

                    public void createProcessProperties(Map<String, String> details, String runtimeId) {
                        ComboEntries ce;
                        IComboProvider comboProvider;
                        String value;
                        IRuntime imRuntime = ImRuntimeActivator.getRuntime((String)runtimeId);
                        for (IProperty property : imRuntime.getProcessProperties().getDefinedProperties()) {
                            if (property.isMap() || property.isVisibleUnderCondition()) continue;
                            String string = value = property.getDefaultValue() != null ? property.getDefaultValue() : "";
                            if ((value == null || value.trim().length() == 0) && property.getPropertyEditor().equalsIgnoreCase("combo")) {
                                comboProvider = property.getComboProvider();
                                if (comboProvider == null) {
                                    comboProvider = imRuntime.getNamedComboProvider(property.getComboProviderName());
                                }
                                ce = comboProvider.getComboEntries();
                                value = ce.getValues()[0];
                            }
                            details.put(property.getName(), value);
                        }
                        for (IProperty property : imRuntime.getProcessProperties().getDefinedProperties()) {
                            if (!property.isVisibleUnderCondition() || !this.evaluateVisibilityCondition(property.getVisibleCondition(), details)) continue;
                            String string = value = property.getDefaultValue() != null ? property.getDefaultValue() : "";
                            if ((value == null || value.trim().length() == 0) && property.getPropertyEditor().equalsIgnoreCase("combo")) {
                                comboProvider = property.getComboProvider();
                                if (comboProvider == null) {
                                    comboProvider = imRuntime.getNamedComboProvider(property.getComboProviderName());
                                }
                                ce = comboProvider.getComboEntries();
                                value = ce.getValues()[0];
                            }
                            details.put(property.getName(), value);
                        }
                    }

                    protected boolean evaluateVisibilityCondition(String visibleCondition, Map<String, String> details) {
                        if (visibleCondition.startsWith("if-is-true")) {
                            String propName = visibleCondition.substring(visibleCondition.indexOf("(") + 1, visibleCondition.indexOf(")"));
                            String value = details.get(propName);
                            return Boolean.valueOf(value);
                        }
                        if (visibleCondition.startsWith("if-is-false")) {
                            String propName = visibleCondition.substring(visibleCondition.indexOf("(") + 1, visibleCondition.indexOf(")"));
                            String value = details.get(propName);
                            return Boolean.valueOf(value) == false;
                        }
                        if (visibleCondition.startsWith("if-has-value")) {
                            String propName = visibleCondition.substring(visibleCondition.indexOf("(") + 1, visibleCondition.indexOf(","));
                            String valueToEnableVisibility = visibleCondition.substring(visibleCondition.indexOf(",") + 1, visibleCondition.indexOf(")"));
                            String value = details.get(propName);
                            return valueToEnableVisibility.equalsIgnoreCase(value);
                        }
                        if (visibleCondition.startsWith("if-isone-of")) {
                            String propName = visibleCondition.substring(visibleCondition.indexOf("(") + 1, visibleCondition.indexOf(","));
                            String valueToEnableVisibility = visibleCondition.substring(visibleCondition.indexOf(",") + 1, visibleCondition.indexOf(")"));
                            String arrValues = valueToEnableVisibility.substring(1, valueToEnableVisibility.length() - 1);
                            String[] splitterArr = arrValues.split(";");
                            List<String> splittedValues = Arrays.asList(splitterArr);
                            String value = details.get(propName);
                            return splittedValues.contains(value);
                        }
                        return false;
                    }
                };
                try {
                    command.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException exception) {
                    BpmnEditorExtensionActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.im.tool.in.bpmneditor", 4, exception.getMessage(), (Throwable)exception));
                }
                this.runtimeLabel.setText(technologyName);
            } else {
                MessageDialog.openError((Shell)this.page.getSite().getShell(), (String)" Error ", (String)(" Technology Change [" + previousTechnologyId + "] --> [" + technologyId + "] Cannot be done"));
                this.technologyText.select(this.findSelectionIndex(previousTechnologyName));
            }
        }
    }

    public int findSelectionIndex(String str) {
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i].equalsIgnoreCase(str)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private abstract class CreateOrUpdateTechnologyEAnnotationCommand
    extends AbstractTransactionalCommand {
        public CreateOrUpdateTechnologyEAnnotationCommand(Pool pool, String label) {
            super((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)pool), label, CreateOrUpdateTechnologyEAnnotationCommand.getWorkspaceFiles((EObject)pool));
        }
    }
}

